/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.StringManager;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class ProxyDirContext
implements DirContext {
    public static final String CONTEXT = "context";
    public static final String HOST = "host";
    protected Hashtable env;
    protected StringManager sm = StringManager.getManager("org.apache.naming.resources");
    protected DirContext dirContext;
    protected String hostName;
    protected String contextName;
    protected Hashtable cache = null;
    protected int cacheTTL = 5000;
    protected int cacheObjectMaxSize = 32768;

    public ProxyDirContext(Hashtable hashtable, DirContext dirContext) {
        this.env = hashtable;
        this.dirContext = dirContext;
        if (dirContext instanceof BaseDirContext && ((BaseDirContext)dirContext).isCached()) {
            this.cache = new Hashtable();
            this.cacheTTL = ((BaseDirContext)dirContext).getCacheTTL();
            this.cacheObjectMaxSize = ((BaseDirContext)dirContext).getCacheObjectMaxSize();
        }
        this.hostName = (String)hashtable.get(HOST);
        this.contextName = (String)hashtable.get(CONTEXT);
    }

    public DirContext getDirContext() {
        return this.dirContext;
    }

    public String getDocBase() {
        if (this.dirContext instanceof BaseDirContext) {
            return ((BaseDirContext)this.dirContext).getDocBase();
        }
        return "";
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Object lookup(Name name) throws NamingException {
        CacheEntry cacheEntry = this.cacheLookup(name.toString());
        if (cacheEntry != null) {
            if (cacheEntry.resource != null) {
                return cacheEntry.resource;
            }
            return cacheEntry.context;
        }
        Object object = this.dirContext.lookup(this.parseName(name));
        if (object instanceof InputStream) {
            return new Resource((InputStream)object);
        }
        return object;
    }

    public Object lookup(String string) throws NamingException {
        CacheEntry cacheEntry = this.cacheLookup(string);
        if (cacheEntry != null) {
            if (cacheEntry.resource != null) {
                return cacheEntry.resource;
            }
            return cacheEntry.context;
        }
        Object object = this.dirContext.lookup(this.parseName(string));
        if (object instanceof InputStream) {
            return new Resource((InputStream)object);
        }
        if (object instanceof DirContext) {
            return object;
        }
        if (object instanceof Resource) {
            return object;
        }
        return new Resource(new ByteArrayInputStream(object.toString().getBytes()));
    }

    public void bind(Name name, Object object) throws NamingException {
        this.dirContext.bind(this.parseName(name), object);
        this.cacheUnload(name.toString());
    }

    public void bind(String string, Object object) throws NamingException {
        this.dirContext.bind(this.parseName(string), object);
        this.cacheUnload(string);
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.dirContext.rebind(this.parseName(name), object);
        this.cacheUnload(name.toString());
    }

    public void rebind(String string, Object object) throws NamingException {
        this.dirContext.rebind(this.parseName(string), object);
        this.cacheUnload(string);
    }

    public void unbind(Name name) throws NamingException {
        this.dirContext.unbind(this.parseName(name));
        this.cacheUnload(name.toString());
    }

    public void unbind(String string) throws NamingException {
        this.dirContext.unbind(this.parseName(string));
        this.cacheUnload(string);
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.dirContext.rename(this.parseName(name), this.parseName(name2));
        this.cacheUnload(name.toString());
    }

    public void rename(String string, String string2) throws NamingException {
        this.dirContext.rename(this.parseName(string), this.parseName(string2));
        this.cacheUnload(string);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.dirContext.list(this.parseName(name));
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.dirContext.list(this.parseName(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.dirContext.listBindings(this.parseName(name));
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.dirContext.listBindings(this.parseName(string));
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.dirContext.destroySubcontext(this.parseName(name));
        this.cacheUnload(name.toString());
    }

    public void destroySubcontext(String string) throws NamingException {
        this.dirContext.destroySubcontext(this.parseName(string));
        this.cacheUnload(string);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.dirContext.createSubcontext(this.parseName(name));
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.dirContext.createSubcontext(this.parseName(string));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.dirContext.lookupLink(this.parseName(name));
    }

    public Object lookupLink(String string) throws NamingException {
        return this.dirContext.lookupLink(this.parseName(string));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.dirContext.getNameParser(this.parseName(name));
    }

    public NameParser getNameParser(String string) throws NamingException {
        return this.dirContext.getNameParser(this.parseName(string));
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        name2 = (Name)name.clone();
        return name2.addAll(name);
    }

    public String composeName(String string, String string2) throws NamingException {
        return string2 + "/" + string;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.dirContext.addToEnvironment(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.dirContext.removeFromEnvironment(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.dirContext.getEnvironment();
    }

    public void close() throws NamingException {
        this.dirContext.close();
    }

    public String getNameInNamespace() throws NamingException {
        return this.dirContext.getNameInNamespace();
    }

    public Attributes getAttributes(Name name) throws NamingException {
        CacheEntry cacheEntry = this.cacheLookup(name.toString());
        if (cacheEntry != null) {
            return cacheEntry.attributes;
        }
        Attributes attributes = this.dirContext.getAttributes(this.parseName(name));
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    public Attributes getAttributes(String string) throws NamingException {
        CacheEntry cacheEntry = this.cacheLookup(string);
        if (cacheEntry != null) {
            return cacheEntry.attributes;
        }
        Attributes attributes = this.dirContext.getAttributes(this.parseName(string));
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        Attributes attributes = this.dirContext.getAttributes(this.parseName(name), stringArray);
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        Attributes attributes = this.dirContext.getAttributes(this.parseName(string), stringArray);
        if (!(attributes instanceof ResourceAttributes)) {
            attributes = new ResourceAttributes(attributes);
        }
        return attributes;
    }

    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(name), n, attributes);
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(string), n, attributes);
    }

    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(name), modificationItemArray);
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        this.dirContext.modifyAttributes(this.parseName(string), modificationItemArray);
    }

    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        this.dirContext.bind(this.parseName(name), object, attributes);
    }

    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        this.dirContext.bind(this.parseName(string), object, attributes);
    }

    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        this.dirContext.rebind(this.parseName(name), object, attributes);
    }

    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        this.dirContext.rebind(this.parseName(string), object, attributes);
    }

    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        return this.dirContext.createSubcontext(this.parseName(name), attributes);
    }

    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        return this.dirContext.createSubcontext(this.parseName(string), attributes);
    }

    public DirContext getSchema(Name name) throws NamingException {
        return this.dirContext.getSchema(this.parseName(name));
    }

    public DirContext getSchema(String string) throws NamingException {
        return this.dirContext.getSchema(this.parseName(string));
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.dirContext.getSchemaClassDefinition(this.parseName(name));
    }

    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        return this.dirContext.getSchemaClassDefinition(this.parseName(string));
    }

    public NamingEnumeration search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        return this.dirContext.search(this.parseName(name), attributes, stringArray);
    }

    public NamingEnumeration search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        return this.dirContext.search(this.parseName(string), attributes, stringArray);
    }

    public NamingEnumeration search(Name name, Attributes attributes) throws NamingException {
        return this.dirContext.search(this.parseName(name), attributes);
    }

    public NamingEnumeration search(String string, Attributes attributes) throws NamingException {
        return this.dirContext.search(this.parseName(string), attributes);
    }

    public NamingEnumeration search(Name name, String string, SearchControls searchControls) throws NamingException {
        return this.dirContext.search(this.parseName(name), string, searchControls);
    }

    public NamingEnumeration search(String string, String string2, SearchControls searchControls) throws NamingException {
        return this.dirContext.search(this.parseName(string), string2, searchControls);
    }

    public NamingEnumeration search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return this.dirContext.search(this.parseName(name), string, objectArray, searchControls);
    }

    public NamingEnumeration search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return this.dirContext.search(this.parseName(string), string2, objectArray, searchControls);
    }

    protected String parseName(String string) throws NamingException {
        return string;
    }

    protected Name parseName(Name name) throws NamingException {
        return name;
    }

    protected CacheEntry cacheLookup(String string) {
        if (this.cache == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(string);
        if (cacheEntry == null) {
            cacheEntry = new CacheEntry();
            cacheEntry.name = string;
            if (!this.cacheLoad(cacheEntry)) {
                return null;
            }
            return cacheEntry;
        }
        if (!this.validate(cacheEntry)) {
            if (!this.revalidate(cacheEntry)) {
                this.cacheUnload(cacheEntry.name);
                return null;
            }
            cacheEntry.timestamp = System.currentTimeMillis() + (long)this.cacheTTL;
        }
        return cacheEntry;
    }

    protected boolean validate(CacheEntry cacheEntry) {
        return cacheEntry.resource != null && cacheEntry.resource.getContent() != null && System.currentTimeMillis() < cacheEntry.timestamp;
    }

    protected boolean revalidate(CacheEntry cacheEntry) {
        if (cacheEntry.attributes == null) {
            return false;
        }
        long l = cacheEntry.attributes.getLastModified();
        long l2 = cacheEntry.attributes.getContentLength();
        if (l <= 0L) {
            return false;
        }
        try {
            Attributes attributes = this.dirContext.getAttributes(cacheEntry.name);
            ResourceAttributes resourceAttributes = null;
            resourceAttributes = !(attributes instanceof ResourceAttributes) ? new ResourceAttributes(attributes) : (ResourceAttributes)attributes;
            long l3 = resourceAttributes.getLastModified();
            long l4 = resourceAttributes.getContentLength();
            return l == l3 && l2 == l4;
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean cacheLoad(CacheEntry cacheEntry) {
        String string;
        block24: {
            Object object;
            if (this.cache == null) {
                return false;
            }
            string = cacheEntry.name;
            if (cacheEntry.attributes == null) {
                try {
                    object = this.dirContext.getAttributes(cacheEntry.name);
                    cacheEntry.attributes = !(object instanceof ResourceAttributes) ? new ResourceAttributes((Attributes)object) : (ResourceAttributes)object;
                }
                catch (NamingException namingException) {
                    return false;
                }
            }
            if (cacheEntry.resource == null && cacheEntry.context == null) {
                try {
                    object = this.dirContext.lookup(string);
                    if (object instanceof InputStream) {
                        cacheEntry.resource = new Resource((InputStream)object);
                    } else if (object instanceof DirContext) {
                        cacheEntry.context = (DirContext)object;
                    } else {
                        cacheEntry.resource = object instanceof Resource ? (Resource)object : new Resource(new ByteArrayInputStream(object.toString().getBytes()));
                    }
                }
                catch (NamingException namingException) {
                    return false;
                }
            }
            if (cacheEntry.resource != null && cacheEntry.resource.getContent() == null && cacheEntry.attributes.getContentLength() >= 0L && cacheEntry.attributes.getContentLength() < (long)this.cacheObjectMaxSize) {
                int n = (int)cacheEntry.attributes.getContentLength();
                InputStream inputStream = null;
                inputStream = cacheEntry.resource.streamContent();
                int n2 = 0;
                byte[] byArray = new byte[n];
                while (n2 < n) {
                    int n3 = inputStream.read(byArray, n2, n - n2);
                    if (n3 < 0) break;
                    n2 += n3;
                }
                cacheEntry.resource.setContent(byArray);
                Object var9_12 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block24;
                }
                catch (IOException iOException) {}
                break block24;
                {
                    catch (IOException iOException) {
                        Object var9_13 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block24;
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        cacheEntry.timestamp = System.currentTimeMillis() + (long)this.cacheTTL;
        this.cache.put(string, cacheEntry);
        return true;
    }

    protected boolean cacheUnload(String string) {
        if (this.cache == null) {
            return false;
        }
        return this.cache.remove(string) != null;
    }

    protected class CacheEntry {
        long timestamp = -1L;
        String name = null;
        ResourceAttributes attributes = null;
        Resource resource = null;
        DirContext context = null;

        protected CacheEntry() {
        }

        public void recycle() {
            this.timestamp = -1L;
            this.name = null;
            this.attributes = null;
            this.resource = null;
            this.context = null;
        }

        public String toString() {
            return "Cache entry: " + this.name + "\n" + "Attributes: " + this.attributes + "\n" + "Resource: " + this.resource + "\n" + "Context: " + this.context;
        }
    }
}

