/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.InetAddress;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.http.HttpConnector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.logger.FileLogger;
import org.apache.catalina.logger.SystemOutLogger;
import org.apache.catalina.net.SSLServerSocketFactory;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public class Embedded
implements Lifecycle {
    protected Connector[] connectors = new Connector[0];
    protected int debug = 0;
    protected boolean useNaming = true;
    protected Engine[] engines = new Engine[0];
    protected static final String info = "org.apache.catalina.startup.Embedded/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected Logger logger = null;
    protected Realm realm = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected String socketFactory = "org.apache.catalina.net.SSLSocketFactory";
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public Embedded() {
        this(null, null);
    }

    public Embedded(Logger logger, Realm realm) {
        this.setLogger(logger);
        this.setRealm(realm);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        int n2 = this.debug;
        this.debug = n;
        this.support.firePropertyChange("debug", new Integer(n2), new Integer(this.debug));
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean bl) {
        boolean bl2 = this.useNaming;
        this.useNaming = bl;
        this.support.firePropertyChange("useNaming", new Boolean(bl2), new Boolean(this.useNaming));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        Logger logger2 = this.logger;
        this.logger = logger;
        this.support.firePropertyChange("logger", logger2, this.logger);
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        Realm realm2 = this.realm;
        this.realm = realm;
        this.support.firePropertyChange("realm", realm2, this.realm);
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(String string) {
        this.socketFactory = string;
    }

    public synchronized void addConnector(Connector connector) {
        block8: {
            Connector[] connectorArray;
            if (this.debug >= 1) {
                if (connector instanceof HttpConnector) {
                    connectorArray = (Connector[])connector;
                    this.logger.log("Adding connector for address '" + (connectorArray.getAddress() == null ? "ALL" : connectorArray.getAddress()) + "' port='" + connectorArray.getPort() + "'");
                } else {
                    this.logger.log("Adding connector (" + connector.getInfo() + ")");
                }
            }
            if (this.engines.length < 1) {
                throw new IllegalStateException(sm.getString("embedded.noEngines"));
            }
            connector.setContainer(this.engines[this.engines.length - 1]);
            connectorArray = new Connector[this.connectors.length + 1];
            int n = 0;
            while (n < this.connectors.length) {
                connectorArray[n] = this.connectors[n];
                ++n;
            }
            connectorArray[this.connectors.length] = connector;
            this.connectors = connectorArray;
            if (!this.started) break block8;
            try {
                connector.initialize();
                if (connector instanceof Lifecycle) {
                    ((Lifecycle)((Object)connector)).start();
                }
            }
            catch (LifecycleException lifecycleException) {
                this.logger.log("Connector.start", lifecycleException);
            }
        }
    }

    public synchronized void addEngine(Engine engine) {
        block4: {
            if (this.debug >= 1) {
                this.logger.log("Adding engine (" + engine.getInfo() + ")");
            }
            Engine[] engineArray = new Engine[this.engines.length + 1];
            int n = 0;
            while (n < this.engines.length) {
                engineArray[n] = this.engines[n];
                ++n;
            }
            engineArray[this.engines.length] = engine;
            this.engines = engineArray;
            if (!this.started || !(engine instanceof Lifecycle)) break block4;
            try {
                ((Lifecycle)((Object)engine)).start();
            }
            catch (LifecycleException lifecycleException) {
                this.logger.log("Engine.start", lifecycleException);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public Connector createConnector(InetAddress inetAddress, int n, boolean bl) {
        if (this.debug >= 1) {
            this.logger.log("Creating connector for address='" + (inetAddress == null ? "ALL" : inetAddress.getHostAddress()) + "' port='" + n + "' secure='" + bl + "'");
        }
        HttpConnector httpConnector = new HttpConnector();
        if (inetAddress != null) {
            httpConnector.setAddress(inetAddress.getHostAddress());
        }
        httpConnector.setDebug(this.debug);
        httpConnector.setPort(n);
        if (bl) {
            httpConnector.setScheme("https");
            httpConnector.setSecure(true);
            httpConnector.setFactory(new SSLServerSocketFactory());
        }
        return httpConnector;
    }

    public Context createContext(String string, String string2) {
        if (this.debug >= 1) {
            this.logger.log("Creating context '" + string + "' with docBase '" + string2 + "'");
        }
        StandardContext standardContext = new StandardContext();
        standardContext.setDebug(this.debug);
        standardContext.setDocBase(string2);
        standardContext.setPath(string);
        ContextConfig contextConfig = new ContextConfig();
        contextConfig.setDebug(this.debug);
        standardContext.addLifecycleListener(contextConfig);
        return standardContext;
    }

    public Engine createEngine() {
        if (this.debug >= 1) {
            this.logger.log("Creating engine");
        }
        StandardEngine standardEngine = new StandardEngine();
        standardEngine.setDebug(this.debug);
        standardEngine.setLogger(this.logger);
        standardEngine.setRealm(this.realm);
        return standardEngine;
    }

    public Host createHost(String string, String string2) {
        if (this.debug >= 1) {
            this.logger.log("Creating host '" + string + "' with appBase '" + string2 + "'");
        }
        StandardHost standardHost = new StandardHost();
        standardHost.setAppBase(string2);
        standardHost.setDebug(this.debug);
        standardHost.setName(string);
        return standardHost;
    }

    public Loader createLoader(ClassLoader classLoader) {
        if (this.debug >= 1) {
            this.logger.log("Creating Loader with parent class loader '" + classLoader + "'");
        }
        WebappLoader webappLoader = new WebappLoader(classLoader);
        return webappLoader;
    }

    public String getInfo() {
        return info;
    }

    public synchronized void removeConnector(Connector connector) {
        if (this.debug >= 1) {
            if (connector instanceof HttpConnector) {
                HttpConnector httpConnector = (HttpConnector)connector;
                this.logger.log("Removing connector for address '" + (httpConnector.getAddress() == null ? "ALL" : httpConnector.getAddress()) + "' port='" + httpConnector.getPort() + "'");
            } else {
                this.logger.log("Removing connector (" + connector.getInfo() + ")");
            }
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.connectors.length) {
            if (connector == this.connectors[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n < 0) {
            return;
        }
        if (connector instanceof Lifecycle) {
            if (this.debug >= 1) {
                this.logger.log(" Stopping this Connector");
            }
            try {
                ((Lifecycle)((Object)connector)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.logger.log("Connector.stop", lifecycleException);
            }
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Connector");
        }
        int n3 = 0;
        Connector[] connectorArray = new Connector[this.connectors.length - 1];
        int n4 = 0;
        while (n4 < this.connectors.length) {
            if (n4 != n) {
                connectorArray[n3++] = this.connectors[n4];
            }
            ++n4;
        }
        this.connectors = connectorArray;
    }

    public synchronized void removeContext(Context context) {
        if (this.debug >= 1) {
            this.logger.log("Removing context[" + context.getPath() + "]");
        }
        boolean bl = false;
        int n = 0;
        while (n < this.engines.length) {
            Container[] containerArray = this.engines[n].findChildren();
            int n2 = 0;
            while (n2 < containerArray.length) {
                Container[] containerArray2 = containerArray[n2].findChildren();
                int n3 = 0;
                while (n3 < containerArray2.length) {
                    if (context == (Context)containerArray2[n3]) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (bl) break;
                ++n2;
            }
            if (bl) break;
            ++n;
        }
        if (!bl) {
            return;
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Context");
        }
        context.getParent().removeChild(context);
    }

    public synchronized void removeEngine(Engine engine) {
        if (this.debug >= 1) {
            this.logger.log("Removing engine (" + engine.getInfo() + ")");
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.engines.length) {
            if (engine == this.engines[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n < 0) {
            return;
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing related Containers");
        }
        while (true) {
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.connectors.length) {
                if (this.connectors[n4].getContainer() == engine) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
            if (n3 < 0) break;
            this.removeConnector(this.connectors[n3]);
        }
        if (engine instanceof Lifecycle) {
            if (this.debug >= 1) {
                this.logger.log(" Stopping this Engine");
            }
            try {
                ((Lifecycle)((Object)engine)).stop();
            }
            catch (LifecycleException lifecycleException) {
                this.logger.log("Engine.stop", lifecycleException);
            }
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Engine");
        }
        int n5 = 0;
        Engine[] engineArray = new Engine[this.engines.length - 1];
        int n6 = 0;
        while (n6 < this.engines.length) {
            if (n6 != n) {
                engineArray[n5++] = this.engines[n6];
            }
            ++n6;
        }
        this.engines = engineArray;
    }

    public synchronized void removeHost(Host host) {
        if (this.debug >= 1) {
            this.logger.log("Removing host[" + host.getName() + "]");
        }
        boolean bl = false;
        int n = 0;
        while (n < this.engines.length) {
            Container[] containerArray = this.engines[n].findChildren();
            int n2 = 0;
            while (n2 < containerArray.length) {
                if (host == (Host)containerArray[n2]) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) break;
            ++n;
        }
        if (!bl) {
            return;
        }
        if (this.debug >= 1) {
            this.logger.log(" Removing this Host");
        }
        host.getParent().removeChild(host);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        String string;
        if (this.debug >= 1) {
            this.logger.log("Starting embedded server");
        }
        if (System.getProperty("catalina.home") == null) {
            string = System.getProperty("com.sun.enterprise.home");
            if (string != null) {
                System.setProperty("catalina.home", System.getProperty("com.sun.enterprise.home"));
            } else {
                throw new LifecycleException("Must set 'catalina.home' system property");
            }
        }
        if (System.getProperty("catalina.base") == null) {
            System.setProperty("catalina.base", System.getProperty("catalina.home"));
        }
        if (this.started) {
            throw new LifecycleException(sm.getString("embedded.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (!this.useNaming) {
            System.setProperty("catalina.useNaming", "false");
        } else {
            System.setProperty("catalina.useNaming", "true");
            string = "org.apache.naming";
            String string2 = System.getProperty("java.naming.factory.url.pkgs");
            if (string2 != null) {
                string = string2 + ":" + string;
            }
            System.setProperty("java.naming.factory.url.pkgs", string);
            System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
        }
        int n = 0;
        while (n < this.engines.length) {
            if (this.engines[n] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.engines[n])).start();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.connectors.length) {
            this.connectors[n2].initialize();
            if (this.connectors[n2] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.connectors[n2])).start();
            }
            ++n2;
        }
    }

    public void stop() throws LifecycleException {
        if (this.debug >= 1) {
            this.logger.log("Stopping embedded server");
        }
        if (!this.started) {
            throw new LifecycleException(sm.getString("embedded.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        int n = 0;
        while (n < this.connectors.length) {
            if (this.connectors[n] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.connectors[n])).stop();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.engines.length) {
            if (this.engines[n2] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.engines[n2])).stop();
            }
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        String string;
        Embedded embedded = new Embedded(new SystemOutLogger(), new MemoryRealm());
        embedded.setDebug(5);
        embedded.setLogger(new SystemOutLogger());
        String string2 = System.getProperty("catalina.home");
        if (string2 == null) {
            System.err.println("You must set the 'catalina.home' system property");
            System.exit(1);
        }
        if ((string = System.getProperty("catalina.base")) == null) {
            string = string2;
            System.setProperty("catalina.base", string);
        }
        try {
            embedded.start();
        }
        catch (LifecycleException lifecycleException) {
            System.err.println("start: " + lifecycleException.toString());
            lifecycleException.printStackTrace();
        }
        Engine engine = embedded.createEngine();
        engine.setDefaultHost("localhost");
        Host host = embedded.createHost("localhost", string2 + "/webapps");
        engine.addChild(host);
        Context context = embedded.createContext("", string2 + "/webapps/ROOT");
        host.addChild(context);
        Context context2 = embedded.createContext("/examples", string2 + "/webapps/examples");
        Embedded.customize(context2);
        host.addChild(context2);
        embedded.addEngine(engine);
        Connector connector = embedded.createConnector(null, 8080, false);
        embedded.addConnector(connector);
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        embedded.removeContext(context2);
        embedded.removeEngine(engine);
        try {
            embedded.stop();
        }
        catch (LifecycleException lifecycleException) {
            System.err.println("stop: " + lifecycleException.toString());
            lifecycleException.printStackTrace();
        }
    }

    private static void customize(Context context) {
        String string = context.getPath();
        string = string.length() < 1 ? "ROOT" : string.substring(1);
        FileLogger fileLogger = new FileLogger();
        fileLogger.setPrefix(string + "_log.");
        fileLogger.setSuffix(".txt");
        fileLogger.setTimestamp(true);
        context.setLogger(fileLogger);
    }
}

