/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jtsxa;

import javax.transaction.xa.Xid;
import org.omg.CosTransactions.otid_t;

public class XID
implements Xid {
    private int formatID = -1;
    private int gtrid_length;
    private int bqual_length;
    private byte[] data = new byte[128];
    private static final int XIDDATASIZE = 128;
    public static final int MAXGTRIDSIZE = 64;
    public static final int MAXBQUALSIZE = 64;
    private static final String hextab = "0123456789ABCDEF";

    public void copy(XID xID) {
        this.formatID = -1;
        if (xID == null) {
            return;
        }
        if (xID.formatID == -1) {
            return;
        }
        this.gtrid_length = xID.gtrid_length;
        this.bqual_length = xID.bqual_length;
        if (this.data != null && xID.data != null) {
            System.arraycopy(xID.data, 0, this.data, 0, 128);
        }
        this.formatID = xID.formatID;
    }

    public void copy(otid_t otid_t2) {
        this.formatID = -1;
        if (otid_t2 == null) {
            return;
        }
        if (otid_t2.formatID == -1) {
            return;
        }
        int n = otid_t2.tid.length;
        this.gtrid_length = n - otid_t2.bqual_length;
        this.bqual_length = otid_t2.bqual_length;
        if (this.data != null && otid_t2.tid != null) {
            System.arraycopy(otid_t2.tid, 0, this.data, 0, n);
        }
        this.formatID = otid_t2.formatID;
    }

    public boolean equals(Object object) {
        if (!(object instanceof XID)) {
            return false;
        }
        XID xID = (XID)object;
        if (this.formatID == -1 && xID.formatID == -1) {
            return true;
        }
        if (this.formatID != xID.formatID || this.gtrid_length != xID.gtrid_length || this.bqual_length != xID.bqual_length) {
            return false;
        }
        int n = this.gtrid_length + this.bqual_length;
        int n2 = 0;
        while (n2 < n) {
            if (this.data[n2] != xID.data[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        if (this.formatID == -1) {
            return -1;
        }
        return this.formatID + this.gtrid_length - this.bqual_length;
    }

    public String toString() {
        int n = this.gtrid_length + this.bqual_length;
        StringBuffer stringBuffer = new StringBuffer(n + n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.data[n2] & 0xFF;
            stringBuffer.append(hextab.charAt(n3 / 16));
            stringBuffer.append(hextab.charAt(n3 & 0xF));
            if ((n2 + 1) % 4 == 0 && n2 + 1 < n) {
                stringBuffer.append(" ");
            }
            ++n2;
        }
        String string = new String("{XID: formatID(" + this.formatID + "), " + "gtrid_length(" + this.gtrid_length + "), " + "bqual_length(" + this.bqual_length + "), " + "data(" + stringBuffer + ")" + "}");
        return string;
    }

    public byte[] getBranchQualifier() {
        byte[] byArray = new byte[this.bqual_length];
        System.arraycopy(this.data, this.gtrid_length, byArray, 0, this.bqual_length);
        return byArray;
    }

    public void setBranchQualifier(byte[] byArray) {
        this.bqual_length = byArray.length > 64 ? 64 : byArray.length;
        System.arraycopy(byArray, 0, this.data, this.gtrid_length, this.bqual_length);
    }

    public int getFormatID() {
        return this.formatID;
    }

    public void setFormatID(int n) {
        this.formatID = n;
    }

    public boolean isEqualBranchQualifier(byte[] byArray) {
        int n;
        int n2 = n = byArray.length > 64 ? 64 : byArray.length;
        if (n != this.bqual_length) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (byArray[n3] != this.data[this.gtrid_length + n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean isEqualGtrid(XID xID) {
        if (this.gtrid_length != xID.gtrid_length) {
            return false;
        }
        int n = 0;
        while (n < this.gtrid_length) {
            if (this.data[n] != xID.data[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public byte[] getGlobalTransactionIdentifier() {
        byte[] byArray = new byte[this.gtrid_length];
        System.arraycopy(this.data, 0, byArray, 0, this.gtrid_length);
        return byArray;
    }

    public int getFormatId() {
        return this.getFormatID();
    }

    public byte[] getGlobalTransactionId() {
        return this.getGlobalTransactionIdentifier();
    }
}

