/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.CompletionHandler;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CoordinatorResourceImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.LogicErrorException;
import com.sun.jts.CosTransactions.NestingInfo;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.RegisteredResources;
import com.sun.jts.CosTransactions.SuperiorInfo;
import com.sun.jts.CosTransactions.TerminatorImpl;
import com.sun.jts.CosTransactions.TimeoutManager;
import com.sun.jts.CosTransactions.TransactionState;
import com.sun.jts.otsidl.CoordinatorResource;
import com.sun.jts.otsidl.JCoordinator;
import com.sun.jts.otsidl.JCoordinatorHelper;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionAwareResourceHelper;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.Vote;
import org.omg.CosTransactions.otid_t;

class SubCoordinator
extends CoordinatorImpl {
    String name = null;
    RegisteredResources participants = null;
    SuperiorInfo superInfo = null;
    NestingInfo nestingInfo = null;
    TransactionState tranState = null;
    CompletionHandler terminator = null;
    boolean registered = false;
    boolean root = true;
    boolean rollbackOnly = false;
    boolean dying = false;
    boolean temporary = false;
    int hash = 0;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");
    static String[] resultName = new String[]{"Commit", "Rollback", "Read-only"};
    private static Any emptyData = null;

    SubCoordinator(GlobalTID globalTID, Long l, CoordinatorImpl[] coordinatorImplArray) throws LogicErrorException {
        this.tranState = new TransactionState(l, globalTID);
        this.superInfo = new SuperiorInfo(this.tranState.localTID, this.tranState.globalTID, null, null);
        this.name = this.superInfo.globalTID.toString();
        this.hash = this.superInfo.globalTID.hashCode();
        this.nestingInfo = new NestingInfo(coordinatorImplArray);
        this.participants = null;
        this.root = true;
        this.registered = true;
        this.rollbackOnly = false;
        this.dying = false;
        this.temporary = false;
        this.terminator = null;
        if (!this.tranState.setState(1)) {
            LogicErrorException logicErrorException = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.invalid_state_change"));
            throw logicErrorException;
        }
        RecoveryManager.addCoordinator(this.tranState.globalTID, this.tranState.localTID, this, 0);
    }

    SubCoordinator(GlobalTID globalTID, Coordinator coordinator, boolean bl, CoordinatorImpl[] coordinatorImplArray) throws LogicErrorException {
        this.tranState = new TransactionState(globalTID, null);
        this.superInfo = new SuperiorInfo(this.tranState.localTID, globalTID, coordinator, null);
        this.name = this.superInfo.globalTID.toString();
        this.hash = this.superInfo.globalTID.hashCode();
        this.nestingInfo = new NestingInfo(coordinatorImplArray);
        this.participants = null;
        this.root = false;
        this.registered = false;
        this.rollbackOnly = false;
        this.dying = false;
        this.temporary = bl;
        this.terminator = null;
        if (!this.tranState.setState(1)) {
            LogicErrorException logicErrorException = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.invalid_state_change"));
            throw logicErrorException;
        }
        if (!RecoveryManager.addCoordinator(globalTID, this.tranState.localTID, this, 0)) {
            LogicErrorException logicErrorException = new LogicErrorException(LogFormatter.getLocalizedMessage(_logger, "jts.transaction_id_already_in_use"));
            throw logicErrorException;
        }
    }

    public void finalize() {
        this.dying = true;
        int n = 9;
        if (this.tranState != null && !this.temporary) {
            n = this.tranState.state;
        }
        switch (n) {
            case 1: {
                this.rollback(true);
                break;
            }
            case 7: 
            case 9: {
                if (this.tranState != null) {
                    this.tranState.finalize();
                }
                if (this.superInfo != null) {
                    this.superInfo.finalize();
                }
                if (this.nestingInfo != null) {
                    this.nestingInfo.finalize();
                }
                if (this.participants != null) {
                    this.participants.finalize();
                }
                this.tranState = null;
                this.superInfo = null;
                this.nestingInfo = null;
                this.participants = null;
                this.terminator = null;
                this.name = null;
                break;
            }
        }
    }

    public synchronized Status get_status() {
        Status status = Status.StatusUnknown;
        if (this.tranState != null) {
            switch (this.tranState.state) {
                case 1: {
                    if (this.rollbackOnly) {
                        status = Status.StatusMarkedRollback;
                        break;
                    }
                    status = Status.StatusActive;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    status = Status.StatusPrepared;
                    break;
                }
                case 0: {
                    status = Status.StatusNoTransaction;
                    break;
                }
                case 2: {
                    status = Status.StatusPreparing;
                    break;
                }
                case 6: {
                    status = Status.StatusCommitting;
                    break;
                }
                case 7: {
                    status = Status.StatusCommitted;
                    break;
                }
                case 8: {
                    status = Status.StatusRollingBack;
                    break;
                }
                case 9: {
                    status = Status.StatusRolledBack;
                    break;
                }
                default: {
                    status = Status.StatusUnknown;
                    break;
                }
            }
        } else {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        return status;
    }

    public synchronized Status get_parent_status() throws SystemException {
        Status status = Status.StatusNoTransaction;
        if (this.tranState != null) {
            CoordinatorImpl coordinatorImpl = this.nestingInfo.getParent(false);
            if (coordinatorImpl != null) {
                status = coordinatorImpl.get_status();
            }
        } else {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        return status;
    }

    public synchronized Status get_top_level_status() throws SystemException {
        Status status = Status.StatusNoTransaction;
        if (this.tranState != null) {
            CoordinatorImpl coordinatorImpl = this.nestingInfo.getTopLevel();
            if (coordinatorImpl != null) {
                status = coordinatorImpl.get_status();
            }
        } else {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        return status;
    }

    public synchronized boolean is_same_transaction(Coordinator coordinator) throws SystemException {
        boolean bl = false;
        if (this.name == null) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        bl = this.name.equals(coordinator.get_transaction_name());
        return bl;
    }

    public synchronized boolean is_related_transaction(Coordinator coordinator) throws SystemException {
        boolean bl = false;
        if (this.tranState != null) {
            CoordinatorImpl coordinatorImpl = this.nestingInfo.getTopLevel();
            if (coordinatorImpl != null) {
                bl = coordinator.is_descendant_transaction(coordinatorImpl.object());
            }
        } else {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        return bl;
    }

    public boolean is_ancestor_transaction(Coordinator coordinator) throws SystemException {
        boolean bl = false;
        if (this.tranState == null) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        bl = coordinator.is_descendant_transaction(this.object());
        return bl;
    }

    public synchronized boolean is_descendant_transaction(Coordinator coordinator) throws SystemException {
        boolean bl = false;
        if (this.tranState != null) {
            bl = this.is_same_transaction(coordinator) ? true : this.nestingInfo.isDescendant(coordinator);
        } else {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        return bl;
    }

    public boolean is_top_level_transaction() {
        boolean bl = false;
        if (this.tranState == null) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        return bl;
    }

    public synchronized int hash_transaction() {
        int n = this.hash;
        if (this.tranState == null) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        return n;
    }

    public synchronized int hash_top_level_tran() throws SystemException {
        int n = 0;
        if (this.tranState != null) {
            CoordinatorImpl coordinatorImpl = this.nestingInfo.getTopLevel();
            if (coordinatorImpl != null) {
                n = coordinatorImpl.hash_transaction();
            }
        } else {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        return n;
    }

    public synchronized RecoveryCoordinator register_resource(Resource resource) throws SystemException, Inactive, TRANSACTION_ROLLEDBACK {
        RecoveryCoordinator recoveryCoordinator = null;
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive inactive = new Inactive();
            throw inactive;
        }
        if (this.rollbackOnly) {
            TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw tRANSACTION_ROLLEDBACK;
        }
        CoordinatorImpl coordinatorImpl = this.nestingInfo.getTopLevel();
        try {
            recoveryCoordinator = coordinatorImpl.register_resource(resource);
        }
        catch (SystemException systemException) {
            throw (SystemException)systemException.fillInStackTrace();
        }
        catch (Inactive inactive) {
            throw (Inactive)inactive.fillInStackTrace();
        }
        boolean bl = resource._is_a(SubtransactionAwareResourceHelper.id());
        if (bl) {
            if (!this.registered) {
                CoordinatorResourceImpl coordinatorResourceImpl = new CoordinatorResourceImpl(this.superInfo.globalTID, this, true);
                try {
                    CoordinatorResource coordinatorResource = coordinatorResourceImpl.object();
                    this.superInfo.superior.register_subtran_aware(coordinatorResource);
                    this.superInfo.setResource(coordinatorResource);
                    this.registered = true;
                }
                catch (Throwable throwable) {
                    coordinatorResourceImpl.destroy();
                    if (throwable instanceof OBJECT_NOT_EXIST) {
                        TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
                        throw tRANSACTION_ROLLEDBACK;
                    }
                    if (throwable instanceof Inactive) {
                        throw (Inactive)throwable;
                    }
                    if (throwable instanceof SystemException) {
                        throw (SystemException)throwable;
                    }
                    INTERNAL iNTERNAL = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                    throw iNTERNAL;
                }
            }
            if (this.participants == null) {
                this.participants = new RegisteredResources(null);
            }
            this.participants.addRes((Resource)resource._duplicate());
            this.temporary = false;
        }
        return recoveryCoordinator;
    }

    public synchronized void register_subtran_aware(SubtransactionAwareResource subtransactionAwareResource) throws SystemException, Inactive, TRANSACTION_ROLLEDBACK {
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive inactive = new Inactive();
            throw inactive;
        }
        if (this.rollbackOnly) {
            TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw tRANSACTION_ROLLEDBACK;
        }
        if (!this.registered) {
            CoordinatorResourceImpl coordinatorResourceImpl = new CoordinatorResourceImpl(this.superInfo.globalTID, this, true);
            try {
                CoordinatorResource coordinatorResource = coordinatorResourceImpl.object();
                this.superInfo.superior.register_subtran_aware(coordinatorResource);
                this.superInfo.setResource(coordinatorResource);
                this.registered = true;
            }
            catch (Throwable throwable) {
                coordinatorResourceImpl.destroy();
                if (throwable instanceof OBJECT_NOT_EXIST) {
                    TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
                    throw tRANSACTION_ROLLEDBACK;
                }
                if (throwable instanceof Inactive) {
                    throw (Inactive)throwable;
                }
                if (throwable instanceof SystemException) {
                    throw (SystemException)throwable;
                }
                INTERNAL iNTERNAL = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                throw iNTERNAL;
            }
        }
        if (this.participants == null) {
            this.participants = new RegisteredResources(null);
        }
        this.participants.addRes((Resource)subtransactionAwareResource._duplicate());
        this.temporary = false;
    }

    public synchronized void rollback_only() throws Inactive {
        if (this.tranState.state != 1) {
            Inactive inactive = new Inactive();
            throw inactive;
        }
        this.rollbackOnly = true;
    }

    public synchronized String get_transaction_name() {
        String string = null;
        if (this.tranState == null) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        string = new String(this.name);
        return string;
    }

    public synchronized Control create_subtransaction() throws Inactive {
        Control control = null;
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive inactive = new Inactive();
            throw inactive;
        }
        CoordinatorImpl[] coordinatorImplArray = this.nestingInfo.getAncestors();
        CoordinatorImpl[] coordinatorImplArray2 = new CoordinatorImpl[coordinatorImplArray.length + 1];
        System.arraycopy(coordinatorImplArray, 0, coordinatorImplArray2, 1, coordinatorImplArray.length);
        coordinatorImplArray2[0] = this;
        SubCoordinator subCoordinator = null;
        TerminatorImpl terminatorImpl = null;
        try {
            subCoordinator = new SubCoordinator(this.superInfo.globalTID, this.superInfo.localTID, coordinatorImplArray2);
            terminatorImpl = new TerminatorImpl(subCoordinator, true);
            control = new ControlImpl(terminatorImpl, subCoordinator, new GlobalTID(subCoordinator.getGlobalTID()), new Long(subCoordinator.getLocalTID())).object();
        }
        catch (Throwable throwable) {
            Inactive inactive = new Inactive();
            throw inactive;
        }
        this.nestingInfo.addChild(subCoordinator);
        return control;
    }

    public otid_t getGlobalTID() {
        otid_t otid_t2 = null;
        otid_t2 = this.superInfo.globalTID.realTID;
        return otid_t2;
    }

    public long getLocalTID() {
        long l = this.superInfo.localTID;
        return l;
    }

    synchronized CoordinatorImpl replyAction(int[] nArray) throws SystemException {
        CoordinatorImpl coordinatorImpl = null;
        nArray[0] = 1;
        if (!this.root && this.nestingInfo.replyCheck()) {
            nArray[0] = 3;
        } else {
            if (!this.registered) {
                if (this.participants != null && this.participants.involved()) {
                    INTERNAL iNTERNAL = new INTERNAL(263, CompletionStatus.COMPLETED_NO);
                    throw iNTERNAL;
                }
                nArray[0] = 2;
            }
            if (nArray[0] == 1 && !this.registered) {
                nArray[0] = 2;
            }
        }
        coordinatorImpl = null;
        return coordinatorImpl;
    }

    synchronized Long setPermanent() {
        Long l = this.superInfo.localTID;
        this.temporary = false;
        return l;
    }

    public synchronized boolean isRollbackOnly() {
        boolean bl = this.rollbackOnly;
        return bl;
    }

    synchronized boolean isActive() {
        boolean bl = this.tranState.state == 1;
        return bl;
    }

    synchronized boolean hasRegistered() {
        boolean bl = this.registered;
        return bl;
    }

    public synchronized TransIdentity[] getAncestors() {
        CoordinatorImpl[] coordinatorImplArray = this.nestingInfo.getAncestors();
        TransIdentity[] transIdentityArray = new TransIdentity[coordinatorImplArray.length];
        int n = 0;
        while (n < coordinatorImplArray.length) {
            try {
                transIdentityArray[n] = new TransIdentity(coordinatorImplArray[n].object(), null, coordinatorImplArray[n].getGlobalTID());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n;
        }
        return transIdentityArray;
    }

    synchronized boolean addChild(CoordinatorImpl coordinatorImpl) {
        boolean bl = this.nestingInfo.addChild(coordinatorImpl);
        return bl;
    }

    synchronized boolean removeChild(CoordinatorImpl coordinatorImpl) {
        boolean bl = false;
        bl = this.nestingInfo.removeChild(coordinatorImpl);
        if (!(!this.temporary || this.registered || this.participants != null && this.participants.involved() || this.nestingInfo != null && this.nestingInfo.numChildren() > 0)) {
            CoordinatorImpl coordinatorImpl2 = this.nestingInfo.getParent(true);
            this.cleanUpEmpty(coordinatorImpl2);
        }
        return bl;
    }

    synchronized Vote prepare() throws INVALID_TRANSACTION {
        Vote vote = Vote.VoteRollback;
        int n = 4;
        if (this.root && this.nestingInfo.numChildren() != 0) {
            INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(1, CompletionStatus.COMPLETED_NO);
            throw iNVALID_TRANSACTION;
        }
        if (!this.tranState.setState(2)) {
            return Vote.VoteRollback;
        }
        if (this.rollbackOnly) {
            if (!this.tranState.setState(4)) {
                return Vote.VoteRollback;
            }
        } else {
            n = 3;
            vote = Vote.VoteCommit;
        }
        if (!this.tranState.setState(n)) {
            vote = Vote.VoteRollback;
        }
        return vote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() {
        Coordinator coordinator = null;
        SubCoordinator subCoordinator = this;
        synchronized (subCoordinator) {
            if (!this.tranState.setState(6)) {
                _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "commit");
                String string = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"commit"});
                throw new INTERNAL(string);
            }
            coordinator = this.nestingInfo.getParent(false).object();
        }
        if (this.participants != null) {
            try {
                this.participants.distributeSubcommit(coordinator);
            }
            catch (Throwable throwable) {
                _logger.log(Level.SEVERE, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "commit"});
                String string = LogFormatter.getLocalizedMessage(_logger, "jts.exception_on_resource_operation", new java.lang.Object[]{throwable.toString(), "commit"});
                throw new INTERNAL(string);
            }
        }
        SubCoordinator subCoordinator2 = this;
        synchronized (subCoordinator2) {
            if (!this.tranState.setState(7)) {
                _logger.log(Level.SEVERE, "jts.transaction_wrong_state", "commit");
                String string = LogFormatter.getLocalizedMessage(_logger, "jts.transaction_wrong_state", new java.lang.Object[]{"commit"});
                throw new INTERNAL(string);
            }
            this.nestingInfo.removeFromParent(this);
            if (this.terminator != null) {
                this.terminator.setCompleted(false, false);
            }
            RecoveryManager.removeCoordinator(this.superInfo.globalTID, this.superInfo.localTID, false);
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback(boolean bl) {
        SubCoordinator subCoordinator = this;
        synchronized (subCoordinator) {
            if (this.tranState == null) {
                return;
            }
            if (!(bl || this.tranState.state != 3 && this.tranState.setState(8))) {
                return;
            }
            if (this.temporary || !this.tranState.setState(8)) {
                // empty if block
            }
            if (this.nestingInfo != null) {
                this.nestingInfo.rollbackFamily();
            }
        }
        if (this.participants != null) {
            this.participants.distributeSubrollback();
        }
        SubCoordinator subCoordinator2 = this;
        synchronized (subCoordinator2) {
            if (this.temporary || !this.tranState.setState(9)) {
                // empty if block
            }
            this.nestingInfo.removeFromParent(this);
            if (this.terminator != null) {
                this.terminator.setCompleted(true, false);
            }
            RecoveryManager.removeCoordinator(this.superInfo.globalTID, this.superInfo.localTID, false);
            if (!this.dying) {
                this.destroy();
            }
        }
    }

    public synchronized void register_synchronization(Synchronization synchronization) throws Inactive, SynchronizationUnavailable {
        if (this.tranState == null || this.tranState.state != 1) {
            Inactive inactive = new Inactive();
            throw inactive;
        }
        CoordinatorImpl coordinatorImpl = this.nestingInfo.getTopLevel();
        coordinatorImpl.register_synchronization(synchronization);
    }

    synchronized void setTerminator(CompletionHandler completionHandler) {
        this.terminator = completionHandler;
    }

    Coordinator getParent() {
        Coordinator coordinator = this.nestingInfo.getParent(false).object();
        return coordinator;
    }

    Coordinator getSuperior() {
        Coordinator coordinator = this.superInfo.superior;
        return coordinator;
    }

    CompletionHandler getTerminator() {
        CompletionHandler completionHandler = this.terminator;
        return completionHandler;
    }

    public synchronized PropagationContext get_txcontext() throws Unavailable {
        if (this.tranState == null || this.tranState.state != 1 || this.rollbackOnly) {
            Unavailable unavailable = new Unavailable();
            throw unavailable;
        }
        long l = TimeoutManager.timeLeft(this.superInfo.localTID);
        int n = 0;
        if (l > 0L) {
            n = (int)l / 1000;
        } else if (l == 0L) {
            TimeoutManager.timeoutCoordinator(this.superInfo.localTID, 1);
            TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            throw tRANSACTION_ROLLEDBACK;
        }
        TransIdentity transIdentity = new TransIdentity(this.object(), null, this.superInfo.globalTID.realTID);
        TransIdentity[] transIdentityArray = this.getAncestors();
        if (emptyData == null) {
            emptyData = Configuration.getORB().create_any();
            emptyData.insert_boolean(false);
        }
        PropagationContext propagationContext = new PropagationContext(n, transIdentity, transIdentityArray, emptyData);
        return propagationContext;
    }

    void cleanUpEmpty(CoordinatorImpl coordinatorImpl) {
        try {
            this.rollback(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (coordinatorImpl != null) {
            coordinatorImpl.removeChild(this);
        }
    }

    boolean commitOnePhase() {
        Vote vote = this.prepare();
        if (vote == Vote.VoteCommit) {
            this.commit();
        } else if (vote != Vote.VoteReadOnly) {
            this.rollback(true);
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(java.lang.Object object) throws INVALID_TRANSACTION {
        if (this == object) {
            return true;
        }
        otid_t otid_t2 = null;
        if (object instanceof CoordinatorImpl) {
            if (object instanceof SubCoordinator) {
                otid_t2 = ((SubCoordinator)object).superInfo.globalTID.realTID;
            }
        } else if (object instanceof Object) {
            try {
                JCoordinator jCoordinator = JCoordinatorHelper.narrow((Object)object);
                otid_t2 = jCoordinator.getGlobalTID();
            }
            catch (BAD_PARAM bAD_PARAM) {
                try {
                    Coordinator coordinator = CoordinatorHelper.narrow((Object)object);
                    PropagationContext propagationContext = coordinator.get_txcontext();
                    otid_t2 = propagationContext.current.otid;
                }
                catch (BAD_PARAM bAD_PARAM2) {
                }
                catch (Unavailable unavailable) {
                    INVALID_TRANSACTION iNVALID_TRANSACTION = new INVALID_TRANSACTION(7, CompletionStatus.COMPLETED_NO);
                    throw iNVALID_TRANSACTION;
                }
            }
        }
        if (otid_t2 != null) {
            return this.superInfo.globalTID.equals(otid_t2);
        }
        return false;
    }
}

