/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.security.SecurityContext;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;

public class ResourcePrincipalMapper
implements Serializable {
    private Hashtable mapTable = new Hashtable();
    private ResourcePrincipal defaultRP = null;
    static Logger _logger = null;

    public void setDefaultResourcePrincipal(ResourcePrincipal resourcePrincipal) {
        this.defaultRP = resourcePrincipal;
    }

    public ResourcePrincipal getDefaultResourcePrincipal() {
        return this.defaultRP;
    }

    public void assignResourcePrincipal(Principal principal, ResourcePrincipal resourcePrincipal) {
        this.mapTable.put(principal, resourcePrincipal);
    }

    public Enumeration getPrincipals() {
        return this.mapTable.keys();
    }

    public Enumeration getResourcePrincipals() {
        Vector<ResourcePrincipal> vector = new Vector<ResourcePrincipal>();
        Enumeration enumeration = this.mapTable.elements();
        while (enumeration.hasMoreElements()) {
            ResourcePrincipal resourcePrincipal = (ResourcePrincipal)enumeration.nextElement();
            if (vector.contains(resourcePrincipal)) continue;
            vector.addElement(resourcePrincipal);
        }
        return vector.elements();
    }

    public Enumeration getPrincipalsFor(ResourcePrincipal resourcePrincipal) {
        Vector<Principal> vector = new Vector<Principal>();
        Enumeration enumeration = this.getPrincipals();
        while (enumeration.hasMoreElements()) {
            Principal principal = (Principal)enumeration.nextElement();
            ResourcePrincipal resourcePrincipal2 = (ResourcePrincipal)this.mapTable.get(principal);
            if (!resourcePrincipal2.equals(resourcePrincipal) || vector.contains(principal)) continue;
            vector.addElement(principal);
        }
        return vector.elements();
    }

    public ResourcePrincipal getResourcePrincipalFor(Principal principal) {
        return (ResourcePrincipal)this.mapTable.get(principal);
    }

    public void removePrincipal(Principal principal) {
        this.mapTable.remove(principal);
    }

    public ResourcePrincipal getResourcePrincipal() {
        ResourcePrincipal resourcePrincipal;
        Principal principal;
        SecurityContext securityContext = SecurityContext.getCurrent();
        if (securityContext != null && (principal = securityContext.getCallerPrincipal()) != null && (resourcePrincipal = (ResourcePrincipal)this.mapTable.get(principal)) != null) {
            return resourcePrincipal;
        }
        return this.defaultRP;
    }

    public String toString() {
        String string = "ResourcePrincipaMapper: ";
        if (this.defaultRP != null) {
            string = string + "dflt:" + this.defaultRP.getName();
        }
        Enumeration enumeration = this.getPrincipals();
        while (enumeration.hasMoreElements()) {
            Principal principal = (Principal)enumeration.nextElement();
            ResourcePrincipal resourcePrincipal = this.getResourcePrincipalFor(principal);
            string = string + "," + principal.getName() + "->" + resourcePrincipal.getName();
        }
        return string;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    }
}

