/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.JdbcXAConnection;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class Jdbc10XaAllocator
implements ResourceAllocator {
    private String jdbcUrl;
    private Hashtable listenerTable = new Hashtable();
    private PoolManager poolMgr;
    private ResourceSpec spec;
    private ClientSecurityInfo info;

    public Jdbc10XaAllocator(PoolManager poolManager, String string, ResourceSpec resourceSpec, ClientSecurityInfo clientSecurityInfo) {
        this.poolMgr = poolManager;
        this.spec = resourceSpec;
        this.info = clientSecurityInfo;
        this.jdbcUrl = string;
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            ResourceSpec resourceSpec = new ResourceSpec(this.jdbcUrl, 0);
            resourceSpec.setJDBCConnectionPoolResourceName(this.jdbcUrl);
            JdbcXAConnection jdbcXAConnection = new JdbcXAConnection(resourceSpec, this.jdbcUrl, this.info, this.poolMgr);
            ResourceHandle resourceHandle = new ResourceHandle(jdbcXAConnection, this.spec, this, this.info);
            ConnectionListenerImpl connectionListenerImpl = new ConnectionListenerImpl(resourceHandle);
            jdbcXAConnection.addConnectionEventListener(connectionListenerImpl);
            this.getListenerTable().put(resourceHandle, connectionListenerImpl);
            return resourceHandle;
        }
        catch (Exception exception) {
            if (exception instanceof PoolingException) {
                throw (PoolingException)exception;
            }
            throw new PoolingException(exception);
        }
    }

    public void fillInResourceObjects(ResourceHandle resourceHandle) throws PoolingException {
        try {
            XAConnection xAConnection = (XAConnection)resourceHandle.getResource();
            Connection connection = xAConnection.getConnection();
            XAResource xAResource = xAConnection.getXAResource();
            resourceHandle.fillInResourceObjects(connection, xAResource);
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    public void closeUserConnection(ResourceHandle resourceHandle) throws PoolingException {
        try {
            Connection connection = (Connection)resourceHandle.getUserConnection();
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    public void destroyResource(ResourceHandle resourceHandle) throws PoolingException {
        XAConnection xAConnection = (XAConnection)resourceHandle.getResource();
        ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.getListenerTable().remove(resourceHandle);
        if (connectionEventListener != null) {
            xAConnection.removeConnectionEventListener(connectionEventListener);
        }
        try {
            this.closeUserConnection(resourceHandle);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            xAConnection.close();
        }
        catch (SQLException sQLException) {
            throw new PoolingException(sQLException);
        }
    }

    private Hashtable getListenerTable() {
        return this.listenerTable;
    }

    public boolean matchConnection(ResourceHandle resourceHandle) {
        return resourceHandle.getClientSecurityInfo().equals(this.info);
    }

    public boolean supportsReauthentication() {
        return false;
    }

    public void cleanup(ResourceHandle resourceHandle) throws PoolingException {
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle resourceHandle) throws PoolingException {
        throw new IllegalStateException("getSharedConnection not supported");
    }

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;

        public ConnectionListenerImpl(ResourceHandle resourceHandle) {
            this.resource = resourceHandle;
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            Jdbc10XaAllocator.this.poolMgr.resourceClosed(this.resource);
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            XAConnection xAConnection = (XAConnection)connectionEvent.getSource();
            xAConnection.removeConnectionEventListener(this);
            Jdbc10XaAllocator.this.poolMgr.resourceErrorOccurred(this.resource);
            try {
                xAConnection.close();
            }
            catch (SQLException sQLException) {}
        }
    }
}

