/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.security.acl.Role;

public class MethodPermission {
    private static MethodPermission unchecked;
    private static MethodPermission excluded;
    private boolean isUnchecked = false;
    private boolean isExcluded = false;
    private Role role;

    public MethodPermission(Role role) {
        this.role = role;
    }

    private MethodPermission() {
    }

    public static MethodPermission getUncheckedMethodPermission() {
        if (unchecked == null) {
            unchecked = new MethodPermission();
            MethodPermission.unchecked.isUnchecked = true;
        }
        return unchecked;
    }

    public static MethodPermission getExcludedMethodPermission() {
        if (excluded == null) {
            excluded = new MethodPermission();
            MethodPermission.excluded.isExcluded = true;
        }
        return excluded;
    }

    public boolean isRoleBased() {
        return this.role != null;
    }

    public boolean isUnchecked() {
        return this.isUnchecked;
    }

    public boolean isExcluded() {
        return this.isExcluded;
    }

    public Role getRole() {
        return this.role;
    }

    public int hashCode() {
        if (this.role != null) {
            return this.role.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MethodPermission) {
            MethodPermission methodPermission = (MethodPermission)object;
            bl = this.isRoleBased() ? this.role.equals(methodPermission.getRole()) : this.isExcluded == methodPermission.isExcluded() && this.isUnchecked == methodPermission.isUnchecked();
        }
        return bl;
    }

    public String toString() {
        if (this.isRoleBased()) {
            return this.role.toString();
        }
        if (this.isExcluded) {
            return "excluded";
        }
        return "unchecked";
    }
}

