/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.iplanet.ias.deployment.AppClientXmlReader;
import com.iplanet.ias.deployment.Utils;
import com.iplanet.ias.tools.common.dd.appclient.SunApplicationClient;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ApplicationClientRuntimeDescriptorNode;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class ApplicationClientArchivist
extends Archivist {
    public static final String DEPLOYMENT_DESCRIPTOR_ENTRY = "META-INF/application-client.xml";
    private ApplicationClientDescriptor applicationClientDescriptor;
    public static final String RI_SPECIFIC_DESCRIPTOR_ENTRY = "META-INF/sun-j2ee-ri.xml";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$ApplicationClientArchivist == null ? (class$com$sun$enterprise$deployment$ApplicationClientArchivist = ApplicationClientArchivist.class$("com.sun.enterprise.deployment.ApplicationClientArchivist")) : class$com$sun$enterprise$deployment$ApplicationClientArchivist);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ApplicationClientArchivist;

    public ApplicationClientArchivist(String string, ApplicationClientDescriptor applicationClientDescriptor) {
        this(true, string, applicationClientDescriptor, new HashSet());
    }

    public ApplicationClientArchivist(String string, ApplicationClientDescriptor applicationClientDescriptor, Set set) {
        this(true, string, applicationClientDescriptor, set);
    }

    public ApplicationClientArchivist(boolean bl, String string, ApplicationClientDescriptor applicationClientDescriptor, Set set) {
        super(string, bl);
        this.manifestClasspath = new HashSet(set);
        this.applicationClientDescriptor = applicationClientDescriptor;
        this.applicationClientDescriptor.setArchivist(this);
    }

    protected File getArchiveFile() throws IOException {
        if (!this.hasArchive()) {
            throw new IOException("No archive file for " + this);
        }
        File file = null;
        Application application = this.applicationClientDescriptor.getApplication();
        if (application != null) {
            ApplicationArchivist applicationArchivist = application.getApplicationArchivist();
            File file2 = applicationArchivist.getApplicationFile();
            file = Archivist.getApplicationClientTemp(Archivist.getDirectory(file2));
            applicationArchivist.extractBundleToFile(this.applicationClientDescriptor, file);
            file.deleteOnExit();
        } else {
            file = this.getApplicationClientJarFile();
        }
        return file;
    }

    public File getApplicationClientJarFile() {
        return new File(this.getArchiveUri());
    }

    public Descriptor getDescriptor() {
        return this.applicationClientDescriptor;
    }

    public static boolean isApplicationClientJar(File file) throws IOException {
        Archivist.checkExists(file);
        JarFile jarFile = new JarFile(file);
        ZipEntry zipEntry = jarFile.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        boolean bl = zipEntry != null;
        jarFile.close();
        return bl;
    }

    public boolean isDeletable(String string) {
        boolean bl = true;
        if (string.equals("META-INF/MANIFEST.MF") || string.equals(DEPLOYMENT_DESCRIPTOR_ENTRY) || string.equals(RI_SPECIFIC_DESCRIPTOR_ENTRY)) {
            bl = false;
        }
        return bl;
    }

    public void updateFiles(Hashtable hashtable) throws IOException {
        super.updateFiles(hashtable);
        this.applicationClientDescriptor.changed();
    }

    public void removeEntries(Vector vector) throws IOException {
        super.removeEntries(vector);
        this.applicationClientDescriptor.changed();
    }

    public Hashtable createEntryNameMap(FileContentsDescriptor fileContentsDescriptor) throws IOException {
        Hashtable hashtable = super.createEntryNameMap(fileContentsDescriptor);
        hashtable.remove(DEPLOYMENT_DESCRIPTOR_ENTRY);
        hashtable.remove(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        return hashtable;
    }

    public static void createPackage(FileContentsDescriptor fileContentsDescriptor, String string, File file, File file2) throws IOException, ArchiveException {
        _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.packageappclassesmainclassdescriptorinfileintodestfil", "Package app client classes {0} with main class {1} using descriptor in {2} into the file {3}", new Object[]{fileContentsDescriptor, string, file, file2}));
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptioncannotpackageappclient", "Cannot package Application Client: {0} does not exist.", new Object[]{file}));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        ApplicationClientDescriptor applicationClientDescriptor = null;
        ApplicationClientNode applicationClientNode = ApplicationClientNode.read(fileInputStream, false);
        fileInputStream.close();
        if (applicationClientNode != null) {
            Object object;
            applicationClientDescriptor = applicationClientNode.getDescriptor();
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            ApplicationClientArchivist applicationClientArchivist = new ApplicationClientArchivist(file2.toString(), applicationClientDescriptor);
            boolean bl = false;
            Enumeration enumeration = fileContentsDescriptor.getFiles();
            while (enumeration.hasMoreElements()) {
                object = (File)enumeration.nextElement();
                String string2 = ((File)object).toString().replace(File.separatorChar, '.');
                if (string2.equals(string + ".class")) {
                    bl = true;
                }
                File file3 = fileContentsDescriptor.getFullFileFor((File)object);
                String string3 = ((File)object).toString().replace(File.separatorChar, '/');
                ZipEntry zipEntry = new ZipEntry(string3);
                zipEntry.setTime(System.currentTimeMillis());
                fileInputStream = new FileInputStream(file3);
                zipOutputStream.putNextEntry(zipEntry);
                ApplicationArchivist.copy(fileInputStream, zipOutputStream);
                fileInputStream.close();
                zipOutputStream.closeEntry();
            }
            applicationClientArchivist.writeDeploymentInfo(zipOutputStream, true);
            if (!bl) {
                throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionincludeclassfileinpackcommand", "You must include the class file for {0} in the packaging command", new Object[]{string}));
            }
            object = ApplicationClientArchivist.createManifest(string, fileContentsDescriptor.getClassLoader(), applicationClientArchivist);
            ApplicationClientArchivist.writeManifest((Manifest)object, zipOutputStream);
            zipOutputStream.close();
            _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.createdappclientjar", "Created Application Client JAR {0}", new Object[]{file2}));
        } else {
            _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.nodeployinfofound", "There was no deployment information in {0}", new Object[]{file}));
        }
    }

    private static Manifest createManifest(String string, Archivist archivist) {
        Manifest manifest = archivist.createManifest();
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, string);
        return manifest;
    }

    private static Manifest createManifest(String string, ClassLoader classLoader, Archivist archivist) throws IOException {
        try {
            classLoader.loadClass(string);
            return ApplicationClientArchivist.createManifest(string, archivist);
        }
        catch (ClassNotFoundException classNotFoundException) {
            _logger.log(Level.WARNING, "enterprise.deployment_class_not_found", classNotFoundException);
            throw new IOException(classNotFoundException.getMessage());
        }
    }

    public void writeDeploymentInfo(ZipOutputStream zipOutputStream, boolean bl) throws IOException {
        this.writeDeploymentInfo(zipOutputStream, bl, DEPLOYMENT_DESCRIPTOR_ENTRY, false);
    }

    public void writeDeploymentInfo(ZipOutputStream zipOutputStream, boolean bl, String string, boolean bl2) throws IOException {
        Archivist.writeDocumentToJar((Document)ApplicationClientNode.getDocument(this.applicationClientDescriptor), string, zipOutputStream);
        if (bl && this.applicationClientDescriptor.hasRuntimeInformation()) {
            String string2 = RI_SPECIFIC_DESCRIPTOR_ENTRY;
            if (bl2) {
                string2 = ApplicationClientArchivist.getRuntimeEntryNameFrom(string);
            }
            Archivist.writeDocumentToJar((Document)ApplicationClientRuntimeDescriptorNode.getDocument(this.applicationClientDescriptor), string2, zipOutputStream);
        }
    }

    private static String getRuntimeEntryNameFrom(String string) {
        return RI_SPECIFIC_DESCRIPTOR_ENTRY + string;
    }

    public static ApplicationClientDescriptor open(File file) throws IOException, ArchiveException {
        try {
            return ApplicationClientArchivist.open(file, false);
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
    }

    public static ApplicationClientDescriptor open(File file, boolean bl) throws IOException, ArchiveException, SAXParseException {
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionappclientjarinfodoesn'texist", "{0} does not exist", new Object[]{file}));
        }
        JarFile jarFile = new JarFile(file);
        ApplicationClientDescriptor applicationClientDescriptor = ApplicationClientArchivist.open(file, DEPLOYMENT_DESCRIPTOR_ENTRY, jarFile, bl);
        jarFile.close();
        return applicationClientDescriptor;
    }

    static ApplicationClientDescriptor open(File file, String string, JarFile jarFile) throws IOException, ArchiveException {
        try {
            return ApplicationClientArchivist.open(file, string, jarFile, false);
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
    }

    static ApplicationClientDescriptor open(File file, String string, JarFile jarFile, boolean bl) throws IOException, ArchiveException, SAXParseException {
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionappclientjarinfodoesn'texist", "{0} does not exist", new Object[]{file}));
        }
        ZipEntry zipEntry = jarFile.getEntry(string);
        if (zipEntry != null) {
            Object object;
            Object object2;
            boolean bl2;
            if (bl) {
                Archivist.validate(jarFile.getInputStream(zipEntry));
            }
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            ApplicationClientNode applicationClientNode = ApplicationClientNode.read(inputStream, bl);
            inputStream.close();
            ApplicationClientDescriptor applicationClientDescriptor = applicationClientNode.getDescriptor();
            ApplicationClientArchivist applicationClientArchivist = new ApplicationClientArchivist(file.toString(), applicationClientDescriptor);
            applicationClientArchivist.setManifestClasspaths(jarFile.getManifest());
            applicationClientDescriptor.setArchivist(applicationClientArchivist);
            boolean bl3 = bl2 = !jarFile.getName().equals(file.toString());
            if (bl2) {
                object2 = new JarFile(file);
                object = ((JarFile)object2).getManifest();
                applicationClientDescriptor.setMainClassName(ApplicationClientArchivist.getMainClassNameFrom((Manifest)object));
                ((ZipFile)object2).close();
            } else {
                object2 = jarFile.getManifest();
                applicationClientDescriptor.setMainClassName(ApplicationClientArchivist.getMainClassNameFrom((Manifest)object2));
            }
            object2 = null;
            object2 = bl2 ? jarFile.getEntry(ApplicationClientArchivist.getRuntimeEntryNameFrom(string)) : jarFile.getEntry(RI_SPECIFIC_DESCRIPTOR_ENTRY);
            if (object2 != null) {
                inputStream = jarFile.getInputStream((ZipEntry)object2);
                object = ApplicationClientRuntimeDescriptorNode.read(inputStream);
                inputStream.close();
                ((ApplicationClientRuntimeDescriptorNode)((Object)object)).updateRuntimeInformation(applicationClientDescriptor);
            }
            return applicationClientDescriptor;
        }
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionnodeployinfofoundatin", "No deployment info found at: {0} in {1}", new Object[]{string, jarFile.getName()}));
    }

    private static String getMainClassNameFrom(Manifest manifest) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        if (attributes != null && attributes.get(Attributes.Name.MAIN_CLASS) != null) {
            return (String)attributes.get(Attributes.Name.MAIN_CLASS);
        }
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionincorrectmanifestformat", "Incorrect Manifest format"));
    }

    public void save(File file, boolean bl) throws IOException {
        this.save(file, bl, DEPLOYMENT_DESCRIPTOR_ENTRY, null);
    }

    void save(File file, boolean bl, String string, ZipOutputStream zipOutputStream) throws IOException {
        File file2 = Archivist.getApplicationClientTemp(Archivist.getDirectory(file));
        ZipOutputStream zipOutputStream2 = new ZipOutputStream(new FileOutputStream(file2));
        if (zipOutputStream == null) {
            this.writeDeploymentInfo(zipOutputStream2, bl, string, false);
        } else {
            this.writeDeploymentInfo(zipOutputStream, bl, string, true);
        }
        Manifest manifest = ApplicationClientArchivist.createManifest(this.applicationClientDescriptor.getMainClassName(), this);
        ApplicationClientArchivist.writeManifest(manifest, zipOutputStream2);
        Vector<String> vector = new Vector<String>();
        if (zipOutputStream == null) {
            vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
            vector.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        }
        vector.addElement("META-INF/MANIFEST.MF");
        this.writeEntriesToOutput(zipOutputStream2, vector);
        zipOutputStream2.close();
        file.delete();
        boolean bl2 = file2.renameTo(file);
        if (!bl2) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrorsavingjar", "Error saving JAR"));
        }
        this.setHasArchive(true, file.toString());
    }

    protected Vector getListOfExemptForClassLoadableFormat() {
        Vector vector = super.getListOfExemptForClassLoadableFormat();
        vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        vector.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        return vector;
    }

    static ApplicationClientDescriptor open(File file, String string, JarFile jarFile, boolean bl, boolean bl2) throws IOException, ArchiveException, SAXParseException {
        ApplicationClientDescriptor applicationClientDescriptor = ApplicationClientArchivist.open(file, string, jarFile, bl);
        if (bl2 && applicationClientDescriptor != null) {
            String string2 = Utils.getSunDescriptorName(string);
            SunApplicationClient sunApplicationClient = ApplicationClientArchivist.createSunApplicationClientJar(jarFile, string2, false);
            applicationClientDescriptor.setSunDescriptor(sunApplicationClient);
        }
        return applicationClientDescriptor;
    }

    static ApplicationClientDescriptor open(File file, boolean bl, boolean bl2) throws IOException, ArchiveException, SAXParseException {
        ApplicationClientDescriptor applicationClientDescriptor = ApplicationClientArchivist.open(file, bl);
        if (bl2 && applicationClientDescriptor != null) {
            JarFile jarFile = new JarFile(file);
            SunApplicationClient sunApplicationClient = ApplicationClientArchivist.createSunApplicationClientJar(jarFile, "META-INF/sun-application-client.xml", false);
            applicationClientDescriptor.setSunDescriptor(sunApplicationClient);
            jarFile.close();
        }
        return applicationClientDescriptor;
    }

    public void save(File file, boolean bl, boolean bl2) throws IOException {
        this.save(file, bl, DEPLOYMENT_DESCRIPTOR_ENTRY, null, bl2);
    }

    void save(File file, boolean bl, String string, ZipOutputStream zipOutputStream, boolean bl2) throws IOException {
        File file2 = Archivist.getApplicationClientTemp(Archivist.getDirectory(file));
        ZipOutputStream zipOutputStream2 = new ZipOutputStream(new FileOutputStream(file2));
        String string2 = Utils.getSunDescriptorName(string);
        if (zipOutputStream == null) {
            this.writeDeploymentInfo(zipOutputStream2, bl, string, false);
            if (bl2) {
                this.writeSunDeploymentInfo(zipOutputStream2, string2);
            }
        } else {
            this.writeDeploymentInfo(zipOutputStream, bl, string, true);
            if (bl2) {
                this.writeSunDeploymentInfo(zipOutputStream, string2);
            }
        }
        Manifest manifest = ApplicationClientArchivist.createManifest(this.applicationClientDescriptor.getMainClassName(), this);
        ApplicationClientArchivist.writeManifest(manifest, zipOutputStream2);
        Vector<String> vector = new Vector<String>();
        if (zipOutputStream == null) {
            vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
            if (bl2) {
                vector.addElement("META-INF/sun-application-client.xml");
            }
        }
        vector.addElement("META-INF/MANIFEST.MF");
        this.writeEntriesToOutput(zipOutputStream2, vector);
        zipOutputStream2.close();
        file.delete();
        boolean bl3 = file2.renameTo(file);
        if (!bl3) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrorsavingjar", "Error saving JAR"));
        }
        this.setHasArchive(true, file.toString());
    }

    private void writeSunDeploymentInfo(ZipOutputStream zipOutputStream, String string) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(System.currentTimeMillis());
        zipOutputStream.putNextEntry(zipEntry);
        SunApplicationClient sunApplicationClient = this.applicationClientDescriptor.getSunDescriptor();
        sunApplicationClient.write(zipOutputStream);
        zipOutputStream.closeEntry();
    }

    public static SunApplicationClient createSunApplicationClientJar(JarFile jarFile, String string, boolean bl) throws IOException, ArchiveException {
        SunApplicationClient sunApplicationClient = null;
        ZipEntry zipEntry = jarFile.getEntry(string);
        if (zipEntry != null) {
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            try {
                sunApplicationClient = AppClientXmlReader.createSunAppClientDescriptorObj(inputStream, bl);
                inputStream.close();
            }
            catch (Exception exception) {
                throw new ArchiveException(exception.getMessage());
            }
        }
        return sunApplicationClient;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

