/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.iplanet.ias.cis.connection.ConnectException;
import com.iplanet.ias.cis.connection.CryptoManager;
import com.iplanet.ias.cis.connection.ServerConnection;
import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.corba.EncapsOutputStream;
import com.sun.corba.ee.internal.corba.ORB;
import com.sun.corba.ee.internal.core.ClientGIOP;
import com.sun.corba.ee.internal.core.EndPoint;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.RequestHandler;
import com.sun.corba.ee.internal.core.ServerGIOP;
import com.sun.corba.ee.internal.iiop.Connection;
import com.sun.corba.ee.internal.iiop.ConnectionTable;
import com.sun.corba.ee.internal.iiop.EndPointImpl;
import com.sun.corba.ee.internal.iiop.ListenerThread;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.ior.IIOPProfile;
import com.sun.corba.ee.internal.ior.ObjectId;
import com.sun.corba.ee.internal.ior.ObjectKeyTemplate;
import com.sun.corba.ee.internal.orbutil.ORBUtility;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;

public class GIOPImpl
implements ClientGIOP,
ServerGIOP {
    private int requestId = 5;
    protected ConnectionTable table;
    protected ORB orb;
    private RequestHandler handler;
    protected HashMap listenerThreads = new HashMap();
    protected Vector endPoints = new Vector();
    private EndPoint bootstrapEndpoint;
    private boolean wasExplicitInitializationDone = false;

    protected synchronized int getNextRequestId() {
        return this.requestId++;
    }

    public GIOPImpl(ORB oRB, RequestHandler requestHandler) {
        this.orb = oRB;
        this.table = new ConnectionTable(oRB, this);
        this.setRequestHandler(requestHandler);
    }

    public Connection getConnection(IOR iOR) {
        return this.table.getConnection(iOR);
    }

    public void deleteConnection(EndPoint endPoint) {
        try {
            this.table.deleteConn(endPoint);
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.FINE, "", exception);
        }
    }

    final ConnectionTable getConnectionTable() {
        return this.table;
    }

    public int allocateRequestId() {
        return this.getNextRequestId();
    }

    public void setRequestHandler(RequestHandler requestHandler) {
        this.handler = requestHandler;
    }

    public RequestHandler getRequestHandler() {
        return this.handler;
    }

    public IOR locate(IOR iOR) {
        IIOPProfile iIOPProfile = iOR.getProfile();
        ObjectKeyTemplate objectKeyTemplate = iIOPProfile.getTemplate().getObjectKeyTemplate();
        ObjectId objectId = iIOPProfile.getObjectId();
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream(this.orb);
        objectKeyTemplate.write(objectId, encapsOutputStream);
        byte[] byArray = encapsOutputStream.toByteArray();
        Connection connection = this.table.getConnection(iOR);
        IOR iOR2 = connection.locate(this.getNextRequestId(), byArray, iOR);
        if (iOR2 == null) {
            iOR2 = iOR;
        }
        return iOR2;
    }

    public synchronized void initEndpoints() {
        if (!this.wasExplicitInitializationDone) {
            if (this.endPoints.size() == 0) {
                this.getEndpoint("IIOP_CLEAR_TEXT", 0, null);
            }
            Iterator iterator = this.orb.getUserSpecifiedListenPorts().iterator();
            while (iterator.hasNext()) {
                ORB.UserSpecifiedListenPort userSpecifiedListenPort = (ORB.UserSpecifiedListenPort)iterator.next();
                this.getEndpoint(userSpecifiedListenPort);
            }
            this.wasExplicitInitializationDone = true;
        }
    }

    public synchronized EndPoint getDefaultEndpoint() {
        if (this.endPoints.size() == 0) {
            return null;
        }
        return (EndPoint)this.endPoints.elementAt(0);
    }

    public synchronized EndPoint getEndpoint(ORB.UserSpecifiedListenPort userSpecifiedListenPort) {
        Object object;
        String string = userSpecifiedListenPort.getType();
        int n = userSpecifiedListenPort.getPort();
        String string2 = userSpecifiedListenPort.getHost();
        if (string2 == null || string2.equals("")) {
            string2 = this.orb.getORBServerHost();
            userSpecifiedListenPort.setHost(string2);
        }
        if (string.equals("IIOP_CLEAR_TEXT")) {
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                Object[] objectArray = new Object[]{string2};
                LogWrap.logger.log(Level.SEVERE, "iiop.host_unknown", objectArray);
                LogWrap.logger.log(Level.SEVERE, "iiop.unknown_host_exception", unknownHostException);
                throw new INTERNAL(1398079697, CompletionStatus.COMPLETED_NO);
            }
            return this.getEndpoint(string, n, inetAddress);
        }
        Enumeration enumeration = this.endPoints.elements();
        while (enumeration.hasMoreElements()) {
            object = (EndPoint)enumeration.nextElement();
            if (!object.getType().equals(string) || object.getPort() != n || !object.getHostName().equals(string2)) continue;
            return object;
        }
        object = this.createListener(userSpecifiedListenPort);
        this.listenerThreads.put(string, object);
        EndPointImpl endPointImpl = new EndPointImpl(string, ((ListenerThread)object).getConnection().getServerEndpoint().getPort(), string2);
        this.endPoints.addElement(endPointImpl);
        return endPointImpl;
    }

    public synchronized EndPoint getEndpoint(String string, int n, InetAddress inetAddress) {
        Object object;
        if (this.orb.transportDebugFlag) {
            ORBUtility.dprint(this, "getEndpoint(" + string + ", " + n + ", " + inetAddress + ")");
        }
        String string2 = null;
        string2 = inetAddress != null ? inetAddress.getHostAddress().toLowerCase() : this.orb.getORBServerHost();
        Enumeration enumeration = this.endPoints.elements();
        while (enumeration.hasMoreElements()) {
            object = (EndPoint)enumeration.nextElement();
            if (!object.getType().equals(string) || object.getPort() != n || !object.getHostName().equals(string2)) continue;
            return object;
        }
        if (string == "IIOP_CLEAR_TEXT" && n == 0 && this.orb.getORBServerPort() != 0) {
            n = this.orb.getORBServerPort();
        }
        object = this.orb.listeningOnAddrAny() ? this.createListener(string, this.orb.getAddressOfAddrAny(), n) : this.createListener(string, string2, n);
        this.listenerThreads.put(string, object);
        EndPointImpl endPointImpl = new EndPointImpl(string, ((ListenerThread)object).getConnection().getServerEndpoint().getPort(), string2);
        this.endPoints.addElement(endPointImpl);
        return endPointImpl;
    }

    public synchronized EndPoint getBootstrapEndpoint(int n) {
        if (this.bootstrapEndpoint == null) {
            this.bootstrapEndpoint = this.getEndpoint("IIOP_CLEAR_TEXT", n, null);
        }
        return this.bootstrapEndpoint;
    }

    private synchronized ListenerThread createListener(final String string, String string2, int n) {
        ListenerThread listenerThread;
        final ConnectionTable connectionTable = this.table;
        if (this.orb.transportDebugFlag) {
            ORBUtility.dprint(this, "createListener( connectionType = " + string + " port = " + n + " )");
        }
        try {
            final ServerConnection serverConnection = new ServerConnection(com.iplanet.ias.cis.connection.EndPoint.getEndPoint(string2, n));
            listenerThread = (ListenerThread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ListenerThread listenerThread = new ListenerThread(connectionTable, serverConnection, string);
                    listenerThread.setDaemon(true);
                    return listenerThread;
                }
            });
            Collection collection = this.orb.getDisabledPorts();
            if (collection != null && collection.contains("" + n)) {
                listenerThread.setDisabled(true);
            }
            listenerThread.start();
        }
        catch (ConnectException connectException) {
            Object[] objectArray = new Object[]{new Integer(n), string2};
            LogWrap.logger.log(Level.SEVERE, "iiop.cannot_create_listener", objectArray);
            LogWrap.logger.log(Level.FINE, "iiop.listener_create_exception", connectException);
            throw new INTERNAL(1398079697, CompletionStatus.COMPLETED_NO);
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
            throw new INTERNAL(1398079697, CompletionStatus.COMPLETED_NO);
        }
        return listenerThread;
    }

    private synchronized ListenerThread createListener(ORB.UserSpecifiedListenPort userSpecifiedListenPort) {
        ListenerThread listenerThread;
        final String string = userSpecifiedListenPort.getType();
        int n = userSpecifiedListenPort.getPort();
        String string2 = userSpecifiedListenPort.getHost();
        if (string2 == null || string2.equals("")) {
            string2 = this.orb.getORBServerHost();
        }
        final ConnectionTable connectionTable = this.table;
        if (this.orb.transportDebugFlag) {
            ORBUtility.dprint(this, "createListener( connectionType = " + string + " port = " + n + " )");
        }
        try {
            if (this.orb.getCertDBPath() != null || this.orb.getCertDBPassword() != null) {
                CryptoManager.initialize(this.orb.getCertDBPath(), this.orb.getCertDBPassword());
            }
            final ServerConnection serverConnection = new ServerConnection(com.iplanet.ias.cis.connection.EndPoint.getEndPoint(string, string2, n), userSpecifiedListenPort.getCertNickname(), userSpecifiedListenPort.getSslVersion(), userSpecifiedListenPort.getSsl2Ciphers(), userSpecifiedListenPort.getSsl3Ciphers(), userSpecifiedListenPort.getTlsRollback());
            listenerThread = (ListenerThread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ListenerThread listenerThread = new ListenerThread(connectionTable, serverConnection, string);
                    listenerThread.setDaemon(true);
                    return listenerThread;
                }
            });
            Collection collection = this.orb.getDisabledPorts();
            if (collection != null && collection.contains("" + n)) {
                listenerThread.setDisabled(true);
            }
            listenerThread.start();
        }
        catch (ConnectException connectException) {
            Object[] objectArray = new Object[]{new Integer(n), string2};
            LogWrap.logger.log(Level.SEVERE, "iiop.cannot_create_listener", objectArray);
            LogWrap.logger.log(Level.SEVERE, "iiop.listener_create_exception", connectException);
            throw new INTERNAL(1398079697, CompletionStatus.COMPLETED_NO);
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
            throw new INTERNAL(1398079697, CompletionStatus.COMPLETED_NO);
        }
        return listenerThread;
    }

    public int getServerPort(String string) {
        return this.getServerPort(string, false);
    }

    public int getPersistentServerPort(String string) {
        return this.getServerPort(string, true);
    }

    private int getServerPort(String string, boolean bl) {
        if (this.endPoints.size() == 0) {
            throw new INITIALIZE("GIOPImpl.get*ServerPort called before endpoints initialized.", 1398079692, CompletionStatus.COMPLETED_NO);
        }
        Iterator iterator = this.endPoints.iterator();
        while (iterator.hasNext()) {
            EndPoint endPoint = (EndPoint)iterator.next();
            if (!endPoint.getType().equals(string)) continue;
            if (bl) {
                return endPoint.getLocatorPort();
            }
            return endPoint.getPort();
        }
        return -1;
    }

    public Collection getServerEndpoints() {
        return this.endPoints;
    }

    void destroyConnections() {
        Iterator iterator = this.listenerThreads.entrySet().iterator();
        while (iterator.hasNext()) {
            ((ListenerThread)iterator.next().getValue()).shutdown();
        }
        this.table.destroyConnections();
    }
}

