/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.core;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.core.CodeSetCache;
import com.sun.corba.ee.internal.core.CodeSetComponentInfo;
import com.sun.corba.ee.internal.core.OSFCodeSetRegistry;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class CodeSetConversion {
    private static CodeSetConversion implementation;
    private static final int FALLBACK_CODESET = 0;
    private CodeSetCache cache = new CodeSetCache();

    public CTBConverter getCTBConverter(OSFCodeSetRegistry.Entry entry) {
        int n = !entry.isFixedWidth() ? 1 : entry.getMaxBytesPerChar();
        return new JavaCTBConverter(entry, n);
    }

    public CTBConverter getCTBConverter(OSFCodeSetRegistry.Entry entry, boolean bl, boolean bl2) {
        if (entry == OSFCodeSetRegistry.UCS_2) {
            return new UTF16CTBConverter(bl);
        }
        if (entry == OSFCodeSetRegistry.UTF_16) {
            if (bl2) {
                return new UTF16CTBConverter();
            }
            return new UTF16CTBConverter(bl);
        }
        int n = !entry.isFixedWidth() ? 1 : entry.getMaxBytesPerChar();
        return new JavaCTBConverter(entry, n);
    }

    public BTCConverter getBTCConverter(OSFCodeSetRegistry.Entry entry) {
        return new JavaBTCConverter(entry);
    }

    public BTCConverter getBTCConverter(OSFCodeSetRegistry.Entry entry, boolean bl) {
        if (entry == OSFCodeSetRegistry.UTF_16 || entry == OSFCodeSetRegistry.UCS_2) {
            return new UTF16BTCConverter(bl);
        }
        return new JavaBTCConverter(entry);
    }

    private int selectEncoding(CodeSetComponentInfo.CodeSetComponent codeSetComponent, CodeSetComponentInfo.CodeSetComponent codeSetComponent2) {
        int n = codeSetComponent2.nativeCodeSet;
        if (n == 0) {
            if (codeSetComponent2.conversionCodeSets.length > 0) {
                n = codeSetComponent2.conversionCodeSets[0];
            } else {
                return 0;
            }
        }
        if (codeSetComponent.nativeCodeSet == n) {
            return n;
        }
        int n2 = 0;
        while (n2 < codeSetComponent.conversionCodeSets.length) {
            if (n == codeSetComponent.conversionCodeSets[n2]) {
                return n;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < codeSetComponent2.conversionCodeSets.length) {
            if (codeSetComponent.nativeCodeSet == codeSetComponent2.conversionCodeSets[n3]) {
                return codeSetComponent.nativeCodeSet;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < codeSetComponent2.conversionCodeSets.length) {
            int n5 = 0;
            while (n5 < codeSetComponent.conversionCodeSets.length) {
                if (codeSetComponent2.conversionCodeSets[n4] == codeSetComponent.conversionCodeSets[n5]) {
                    return codeSetComponent2.conversionCodeSets[n4];
                }
                ++n5;
            }
            ++n4;
        }
        return 0;
    }

    public CodeSetComponentInfo.CodeSetContext negotiate(CodeSetComponentInfo codeSetComponentInfo, CodeSetComponentInfo codeSetComponentInfo2) {
        int n;
        int n2 = this.selectEncoding(codeSetComponentInfo.getCharComponent(), codeSetComponentInfo2.getCharComponent());
        if (n2 == 0) {
            n2 = OSFCodeSetRegistry.UTF_8.getNumber();
        }
        if ((n = this.selectEncoding(codeSetComponentInfo.getWCharComponent(), codeSetComponentInfo2.getWCharComponent())) == 0) {
            n = OSFCodeSetRegistry.UTF_16.getNumber();
        }
        return new CodeSetComponentInfo.CodeSetContext(n2, n);
    }

    private CodeSetConversion() {
    }

    public static final CodeSetConversion impl() {
        return CodeSetConversionHolder.csc;
    }

    private static class CodeSetConversionHolder {
        static final CodeSetConversion csc = new CodeSetConversion();

        private CodeSetConversionHolder() {
        }
    }

    private class UTF16BTCConverter
    extends JavaBTCConverter {
        private boolean defaultToLittleEndian;
        private boolean converterUsesBOM;
        private static final char UTF16_BE_MARKER = '\ufeff';
        private static final char UTF16_LE_MARKER = '\ufffe';

        public UTF16BTCConverter(boolean bl) {
            super(OSFCodeSetRegistry.UTF_16);
            this.converterUsesBOM = true;
            this.defaultToLittleEndian = bl;
        }

        public char[] getChars(byte[] byArray, int n, int n2) {
            if (this.hasUTF16ByteOrderMarker(byArray, n, n2)) {
                if (!this.converterUsesBOM) {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16);
                }
                this.converterUsesBOM = true;
                return super.getChars(byArray, n, n2);
            }
            if (this.converterUsesBOM) {
                if (this.defaultToLittleEndian) {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16LE);
                } else {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16BE);
                }
                this.converterUsesBOM = false;
            }
            return super.getChars(byArray, n, n2);
        }

        private boolean hasUTF16ByteOrderMarker(byte[] byArray, int n, int n2) {
            if (n2 >= 4) {
                int n3 = byArray[n] & 0xFF;
                int n4 = byArray[n + 1] & 0xFF;
                char c = (char)(n3 << 8 | n4 << 0);
                return c == '\ufeff' || c == '\ufffe';
            }
            return false;
        }

        private void switchToConverter(OSFCodeSetRegistry.Entry entry) {
            this.btc = this.getConverter(entry.getName());
        }
    }

    private class JavaBTCConverter
    extends BTCConverter {
        protected ByteToCharConverter btc;
        private char[] buffer;
        private int resultingNumChars;
        private OSFCodeSetRegistry.Entry codeset;

        public JavaBTCConverter(OSFCodeSetRegistry.Entry entry) {
            this.btc = this.getConverter(entry.getName());
            this.codeset = entry;
        }

        public final boolean isFixedWidthEncoding() {
            return this.codeset.isFixedWidth();
        }

        public final int getFixedCharWidth() {
            return this.codeset.getMaxBytesPerChar();
        }

        public final int getNumChars() {
            return this.resultingNumChars;
        }

        public char[] getChars(byte[] byArray, int n, int n2) {
            if (this.buffer == null || this.buffer.length < n2 * this.btc.getMaxCharsPerByte()) {
                this.buffer = new char[n2 * this.btc.getMaxCharsPerByte()];
            }
            try {
                this.btc.reset();
                this.resultingNumChars = this.btc.convert(byArray, n, n + n2, this.buffer, 0, this.buffer.length);
                this.resultingNumChars += this.btc.flush(this.buffer, 0, this.buffer.length);
                return this.buffer;
            }
            catch (MalformedInputException malformedInputException) {
                LogWrap.logger.log(Level.WARNING, "", malformedInputException);
                throw new DATA_CONVERSION(malformedInputException.getMessage(), 1398079694, CompletionStatus.COMPLETED_NO);
            }
            catch (UnknownCharacterException unknownCharacterException) {
                LogWrap.logger.log(Level.WARNING, "", unknownCharacterException);
                throw new DATA_CONVERSION(unknownCharacterException.getMessage(), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                LogWrap.logger.log(Level.WARNING, "", conversionBufferFullException);
                throw new INTERNAL(conversionBufferFullException.getMessage(), 1398079715, CompletionStatus.COMPLETED_NO);
            }
        }

        protected ByteToCharConverter getConverter(String string) {
            try {
                ByteToCharConverter byteToCharConverter = CodeSetConversion.this.cache.getByteToCharConverter(string);
                if (byteToCharConverter == null) {
                    byteToCharConverter = ByteToCharConverter.getConverter((String)string);
                    CodeSetConversion.this.cache.setConverter((Object)string, byteToCharConverter);
                    byteToCharConverter.setSubstitutionMode(false);
                }
                return byteToCharConverter;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LogWrap.logger.log(Level.WARNING, "", unsupportedEncodingException);
                throw new INTERNAL("Invalid converter name: " + string);
            }
        }
    }

    private class UTF16CTBConverter
    extends JavaCTBConverter {
        public UTF16CTBConverter() {
            super(OSFCodeSetRegistry.UTF_16, 2);
        }

        public UTF16CTBConverter(boolean bl) {
            super(bl ? OSFCodeSetRegistry.UTF_16LE : OSFCodeSetRegistry.UTF_16BE, 2);
        }
    }

    private class JavaCTBConverter
    extends CTBConverter {
        private CharToByteConverter ctb;
        private int alignment;
        private char[] chars = null;
        private int numBytes = 0;
        private int numChars = 0;
        private byte[] buffer;
        private OSFCodeSetRegistry.Entry codeset;

        public JavaCTBConverter(OSFCodeSetRegistry.Entry entry, int n) {
            try {
                this.ctb = CodeSetConversion.this.cache.getCharToByteConverter(entry.getName());
                if (this.ctb == null) {
                    this.ctb = CharToByteConverter.getConverter((String)entry.getName());
                    CodeSetConversion.this.cache.setConverter((Object)entry.getName(), this.ctb);
                    this.ctb.setSubstitutionMode(false);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LogWrap.logger.log(Level.WARNING, "", unsupportedEncodingException);
                throw new INTERNAL("Invalid converter name: " + entry.getName());
            }
            this.codeset = entry;
            this.alignment = n;
        }

        public final int getMaxBytesPerChar() {
            return this.ctb.getMaxBytesPerChar();
        }

        public void convert(char c) {
            if (this.chars == null) {
                this.chars = new char[1];
            }
            this.chars[0] = c;
            this.numChars = 1;
            this.convertCharArray();
        }

        public void convert(String string) {
            if (this.chars == null || this.chars.length < string.length()) {
                this.chars = new char[string.length()];
            }
            this.numChars = string.length();
            string.getChars(0, this.numChars, this.chars, 0);
            this.convertCharArray();
        }

        public final int getNumBytes() {
            return this.numBytes;
        }

        public final int getAlignment() {
            return this.alignment;
        }

        public final boolean isFixedWidthEncoding() {
            return this.codeset.isFixedWidth();
        }

        public byte[] getBytes() {
            return this.buffer;
        }

        private void convertCharArray() {
            try {
                if (this.buffer == null || this.buffer.length < this.numChars * this.ctb.getMaxBytesPerChar()) {
                    this.buffer = new byte[this.numChars * this.ctb.getMaxBytesPerChar()];
                }
                this.ctb.reset();
                this.numBytes = this.ctb.convert(this.chars, 0, this.numChars, this.buffer, 0, this.buffer.length);
                this.numBytes += this.ctb.flush(this.buffer, 0, this.buffer.length);
            }
            catch (MalformedInputException malformedInputException) {
                LogWrap.logger.log(Level.WARNING, "", malformedInputException);
                throw new DATA_CONVERSION(malformedInputException.getMessage(), 1398079694, CompletionStatus.COMPLETED_NO);
            }
            catch (UnknownCharacterException unknownCharacterException) {
                LogWrap.logger.log(Level.WARNING, "", unknownCharacterException);
                throw new DATA_CONVERSION(unknownCharacterException.getMessage(), 1330446337, CompletionStatus.COMPLETED_NO);
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                LogWrap.logger.log(Level.WARNING, "", conversionBufferFullException);
                throw new INTERNAL(conversionBufferFullException.getMessage(), 1398079714, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public static abstract class BTCConverter {
        public abstract boolean isFixedWidthEncoding();

        public abstract int getFixedCharWidth();

        public abstract int getNumChars();

        public abstract char[] getChars(byte[] var1, int var2, int var3);
    }

    public static abstract class CTBConverter {
        public abstract void convert(char var1);

        public abstract void convert(String var1);

        public abstract int getNumBytes();

        public abstract int getMaxBytesPerChar();

        public abstract boolean isFixedWidthEncoding();

        public abstract int getAlignment();

        public abstract byte[] getBytes();
    }
}

