/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web.connector.nsapi;

import com.iplanet.ias.web.connector.nsapi.NSAPIRequest;
import com.iplanet.ias.web.connector.nsapi.NSAPIResponse;
import java.io.IOException;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Service;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.util.StringManager;

public final class NSAPIConnector
implements Connector {
    private long _jniConnector = 0L;
    private int _streamSize = 0;
    protected Container _container = null;
    private int _debug = 0;
    private static final String _info = "com.iplanet.ias.web.connector.nsapi.NSAPIConnector/1.0";
    private int _redirectPort = 443;
    private String _scheme = "http";
    private boolean _secure = false;
    private boolean _isClosing = false;
    private static StringManager _sm = StringManager.getManager("com.iplanet.ias.web.connector.nsapi");

    public void setJNIConnector(long l) {
        this._jniConnector = l;
    }

    public int getConnectionTimeout() {
        return 0;
    }

    public void setClosing() {
        this._isClosing = true;
    }

    public boolean isClosing() {
        return this._isClosing;
    }

    public void setConnectionTimeout(int n) {
    }

    public boolean isChunkingAllowed() {
        return true;
    }

    public void setAllowChunking(boolean bl) {
    }

    public String getAddress() {
        return null;
    }

    public void setAddress(String string) {
    }

    public Container getContainer() {
        return this._container;
    }

    public void setContainer(Container container) {
        this._container = container;
    }

    public int getDebug() {
        return this._debug;
    }

    public void setDebug(int n) {
        this._debug = n;
    }

    public boolean getEnableLookups() {
        return false;
    }

    public void setEnableLookups(boolean bl) {
    }

    public ServerSocketFactory getFactory() {
        return null;
    }

    public void setFactory(ServerSocketFactory serverSocketFactory) {
    }

    public String getInfo() {
        return _info;
    }

    public int getRedirectPort() {
        return this._redirectPort;
    }

    public void setRedirectPort(int n) {
        this._redirectPort = n;
    }

    public String getScheme() {
        return this._scheme;
    }

    public void setScheme(String string) {
        this._scheme = string;
    }

    public boolean getSecure() {
        return this._secure;
    }

    public void setSecure(boolean bl) {
        this._secure = bl;
    }

    public boolean getTcpNoDelay() {
        return true;
    }

    public void setTcpNoDelay(boolean bl) {
    }

    public Service getService() {
        return null;
    }

    public void setService(Service service) {
    }

    public Request createRequest() {
        NSAPIRequest nSAPIRequest = new NSAPIRequest();
        nSAPIRequest.setConnector(this);
        return nSAPIRequest;
    }

    public Response createResponse() {
        NSAPIResponse nSAPIResponse = new NSAPIResponse();
        nSAPIResponse.setConnector(this);
        return nSAPIResponse;
    }

    public void initialize() {
    }

    void setInitialSize(int n) {
        this._streamSize = n;
    }

    int resize(int n) {
        int n2 = this._streamSize;
        if (n != this._streamSize) {
            this._streamSize = n;
            this.jniSetSize(this._jniConnector, n);
        }
        return n2;
    }

    void flush() {
        if (this.isClosing()) {
            this.jniFinishResponse(this._jniConnector);
        } else {
            this.jniFlushResponse(this._jniConnector);
        }
    }

    int readByte() {
        return this.jniReadByte(this._jniConnector);
    }

    int read(byte[] byArray, int n, int n2) {
        return this.jniRead(this._jniConnector, byArray, n, n2);
    }

    int readLine(byte[] byArray, int n, int n2) {
        return this.jniReadLine(this._jniConnector, byArray, n, n2);
    }

    boolean skip(int n) {
        return this.jniSkip(this._jniConnector, n);
    }

    void setAllResponseFields(int n, String string, String string2, int n2, Object[] objectArray, int n3, boolean bl) {
        this.jniSetAllResponseFields(this._jniConnector, n, string, string2, n2, objectArray, n3, bl);
    }

    String getCertificate() {
        return this.jniGetCertificate(this._jniConnector);
    }

    void writeByte(byte by) throws IOException {
        if (!this.jniWriteByte(this._jniConnector, by)) {
            throw new IOException(_sm.getString("nsapiConnector.jniWriteByteError"));
        }
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0 && this.jniWrite(this._jniConnector, byArray, n, n2) != n2) {
            throw new IOException(_sm.getString("nsapiConnector.jniWriteError"));
        }
    }

    protected void recycle() {
        this._isClosing = false;
    }

    private void log(String string) {
        Logger logger = this._container.getLogger();
        if (logger != null) {
            logger.log(string);
        } else {
            System.out.println(string);
        }
    }

    private void log(String string, Throwable throwable) {
        Logger logger = this._container.getLogger();
        if (logger != null) {
            logger.log(string, throwable);
        } else {
            System.out.println(string);
            throwable.printStackTrace(System.out);
        }
    }

    public native void jniSetThreadLocalData(Object var1);

    private native void jniSetSize(long var1, int var3);

    private native void jniFlushResponse(long var1);

    private native void jniFinishResponse(long var1);

    private native int jniWrite(long var1, byte[] var3, int var4, int var5);

    private native boolean jniWriteByte(long var1, byte var3);

    private native int jniReadByte(long var1);

    private native int jniRead(long var1, byte[] var3, int var4, int var5);

    private native int jniReadLine(long var1, byte[] var3, int var4, int var5);

    private native boolean jniSkip(long var1, int var3);

    private native void jniSetAllResponseFields(long var1, int var3, String var4, String var5, int var6, Object[] var7, int var8, boolean var9);

    private native String jniGetCertificate(long var1);
}

