/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.collection;

import com.iplanet.ias.util.MonitorTask;
import com.iplanet.ias.util.collection.QueueClosedException;
import com.iplanet.ias.util.collection.TooManyTasksException;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Logger;

public class BlockingQueue {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private boolean closed = false;
    private boolean aborted = false;
    private int limit;
    private LinkedList list;
    private int waiters = 0;

    public BlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public BlockingQueue(int n) {
        this.limit = n;
        this.list = new LinkedList();
        MonitorTask.addORBMonitorable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(Object object) throws TooManyTasksException, QueueClosedException {
        if (this.closed) {
            throw new QueueClosedException("Queue closed.");
        }
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            if (this.list.size() >= this.limit) {
                throw new TooManyTasksException("Too many tasks in queue...");
            }
            this.list.addFirst(object);
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(Object object) throws TooManyTasksException, QueueClosedException {
        if (this.closed) {
            throw new QueueClosedException("Queue closed.");
        }
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            if (this.list.size() >= this.limit) {
                throw new TooManyTasksException("Too many tasks in queue...");
            }
            this.list.add(object);
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n, Object object) throws TooManyTasksException, QueueClosedException {
        if (this.closed) {
            throw new QueueClosedException("Queue closed.");
        }
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            if (this.list.size() >= this.limit) {
                throw new TooManyTasksException("Too many tasks in queue...");
            }
            this.list.add(n, object);
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection collection) throws TooManyTasksException, QueueClosedException {
        if (this.closed) {
            throw new QueueClosedException("Queue closed.");
        }
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            if (this.list.size() >= this.limit) {
                throw new TooManyTasksException("Too many tasks in queue...");
            }
            this.list.addAll(collection);
            this.list.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            return this.list.size();
        }
    }

    public int getUnsyncSize() {
        return this.list.size();
    }

    public int getUnsyncWaitingThreads() {
        return this.waiters;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BlockingQueue [TW=").append(this.waiters);
        stringBuffer.append(", CS=").append(this.list.size());
        stringBuffer.append(", MS=").append(this.limit).append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(boolean bl) throws InterruptedException, QueueClosedException {
        while (true) {
            if (this.aborted) {
                throw new QueueClosedException("Queue closed....");
            }
            LinkedList linkedList = this.list;
            synchronized (linkedList) {
                if (this.list.size() > 0) {
                    return this.list.removeFirst();
                }
                if (this.closed) {
                    throw new QueueClosedException("Queue closed....");
                }
                if (!bl) {
                    return null;
                }
                ++this.waiters;
                this.list.wait();
                --this.waiters;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long l) throws InterruptedException, QueueClosedException {
        if (this.aborted) {
            throw new QueueClosedException("Queue closed....");
        }
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            if (this.list.size() > 0) {
                return this.list.removeFirst();
            }
            if (this.closed) {
                throw new QueueClosedException("Queue closed....");
            }
            ++this.waiters;
            this.list.wait(l);
            --this.waiters;
            if (this.list.size() > 0) {
                return this.list.removeFirst();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.closed = true;
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            this.list.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        this.aborted = true;
        this.closed = true;
        LinkedList linkedList = this.list;
        synchronized (linkedList) {
            this.list.notifyAll();
        }
    }
}

