/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.cache;

import com.iplanet.ias.util.cache.CacheStore;
import com.iplanet.ias.util.cache.ConcurrentMap;
import com.iplanet.ias.util.scheduler.PeriodicEventScheduler;
import com.iplanet.ias.util.scheduler.PeriodicallyServicable;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileCacheStore
implements CacheStore,
PeriodicallyServicable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static final long MAX_UNUSED_TIME = 60000L;
    File dir;
    ConcurrentMap map;
    private boolean debug = false;

    public FileCacheStore(String string) {
        try {
            this.dir = new File(string);
            this.dir.mkdirs();
            this.map = new ConcurrentMap(1024);
            PeriodicEventScheduler periodicEventScheduler = PeriodicEventScheduler.getInstance();
            PeriodicEventScheduler.getInstance().addTimeRepeatableTask(this, 1);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "iplanet_util.fcstore_create_exception", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object lookup(Object object) {
        Object object2;
        ObjectInputStream objectInputStream;
        File file;
        block11: {
            String string = (String)this.map.removeEntry(object);
            if (string == null) {
                return null;
            }
            file = new File(this.dir, string);
            objectInputStream = null;
            if (file.exists()) break block11;
            Object var5_5 = null;
            Object var8_8 = null;
            try {
                objectInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            file.delete();
            return var5_5;
        }
        objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        Object object3 = object2 = objectInputStream.readObject();
        Object var8_9 = null;
        try {
            objectInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        file.delete();
        return object3;
        catch (Exception exception) {
            try {
                _logger.log(Level.SEVERE, "iplanet_util.lookup_exception", exception);
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                file.delete();
                throw throwable;
            }
            try {
                objectInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            file.delete();
            {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Object object, Object object2) {
        File file = null;
        try {
            try {
                String string = "" + object;
                this.map.putEntry(object, string);
                file = new File(this.dir, string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                objectOutputStream.writeObject(object2);
                objectOutputStream.close();
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "iplanet_util.store_exception", exception);
                Object var7_8 = null;
                file.deleteOnExit();
            }
            Object var7_7 = null;
            file.deleteOnExit();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            file.deleteOnExit();
            throw throwable;
        }
    }

    public long getFrequency() {
        return 60000L;
    }

    public boolean getExecuteIfMissed() {
        return true;
    }

    public boolean getExecutionTolerance(long l) {
        return true;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void prolog() {
    }

    public void service() {
        Iterator iterator = this.map.keys();
        long l = System.currentTimeMillis() - 60000L;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = (String)this.map.getEntry(e);
            File file = new File(this.dir, string);
            if (file.lastModified() >= l) continue;
            this.map.removeEntry(e);
            file.delete();
        }
    }

    public void epilog() {
    }
}

