/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.transaction;

import com.iplanet.ias.transaction.XAResourceWrapper;
import com.iplanet.ias.util.i18n.StringManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class OracleXAResource
extends XAResourceWrapper {
    private static StringManager sm = StringManager.getManager(class$com$iplanet$ias$transaction$OracleXAResource == null ? (class$com$iplanet$ias$transaction$OracleXAResource = OracleXAResource.class$("com.iplanet.ias.transaction.OracleXAResource")) : class$com$iplanet$ias$transaction$OracleXAResource);
    private static int called = 1;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static /* synthetic */ Class class$com$iplanet$ias$transaction$OracleXAResource;

    public Xid[] recover(int n) throws XAException {
        ++called;
        if (n == 0x1000000) {
            return this.recoverList();
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Xid[] recoverList() throws XAException {
        Xid[] xidArray;
        Statement statement;
        block15: {
            statement = null;
            ResultSet resultSet = null;
            Connection connection = null;
            try {
                connection = this.m_xacon.getConnection();
                if (null == connection) {
                    throw new XAException(sm.getString("transaction.oracle_xa_wrapper_connection_failed"));
                }
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select pending.local_tran_id from SYS.PENDING_TRANS$ pending, SYS.DBA_2PC_NEIGHBORS");
                resultSet.close();
                resultSet = null;
                statement.close();
                statement = null;
                xidArray = this.m_xacon.getXAResource().recover(0x1000000);
                if (null == resultSet) break block15;
            }
            catch (SQLException sQLException) {
                try {
                    throw new XAException(sm.getString("transaction.oracle_sqlexception_occurred", sQLException));
                    catch (Exception exception) {
                        throw new XAException(sm.getString("transaction.oracle_unknownexception_occurred", exception));
                    }
                }
                catch (Throwable throwable) {
                    if (null != resultSet) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException2) {
                            // empty catch block
                        }
                    }
                    if (null == statement) throw throwable;
                    try {
                        statement.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException3) {
                        throw throwable;
                    }
                }
            }
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (null == statement) return xidArray;
        try {
            statement.close();
            return xidArray;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return xidArray;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        this.doRecovery(xid, true);
    }

    public void rollback(Xid xid) throws XAException {
        this.doRecovery(xid, false);
    }

    private void doRecovery(Xid xid, boolean bl) throws XAException {
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            connection = this.m_xacon.getConnection();
            if (null == connection) {
                throw new XAException(sm.getString("transaction.oracle_xa_wrapper_connection_failed"));
            }
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select pending.local_tran_id from SYS.PENDING_TRANS$ pending, SYS.DBA_2PC_NEIGHBORS dba where pending.global_foreign_id = '" + OracleXAResource.toHexString(xid.getGlobalTransactionId()) + "' and pending.local_tran_id = dba.local_tran_id and dba.branch = '" + OracleXAResource.toHexString(xid.getBranchQualifier()) + "' and pending.state = 'prepared'");
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                resultSet.close();
                resultSet = null;
                statement.executeUpdate((bl ? "commit force '" : "rollback force '") + string + "'");
                statement.close();
                statement = null;
            }
        }
        catch (SQLException sQLException) {
            throw new XAException(sm.getString("transaction.oracle_sqlexception_occurred", sQLException));
        }
        catch (Exception exception) {
            throw new XAException(sm.getString("transaction.oracle_unknownexception_occurred", exception));
        }
        finally {
            if (null != resultSet) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (null != statement) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null != byArray && 0 < byArray.length) {
            int n = 0;
            while (n < byArray.length) {
                stringBuffer.append(HEX_DIGITS[(byArray[n] & 0xF0) >> 4]);
                stringBuffer.append(HEX_DIGITS[byArray[n] & 0xF]);
                ++n;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

