/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server.logging;

import com.iplanet.ias.util.logging.IASLevel;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class ServerHandler
extends StreamHandler {
    private static final int LOG_WARN = 0;
    private static final int LOG_MISCONFIG = 1;
    private static final int LOG_SECURITY = 2;
    private static final int LOG_FAILURE = 3;
    private static final int LOG_CATASTROPHE = 4;
    private static final int LOG_INFORM = 5;
    private static final int LOG_VERBOSE = 6;
    private static Logger _logger;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise");
        }
        return _logger;
    }

    private static native void logToCore(int var0, byte[] var1, byte[] var2);

    public void publish(LogRecord logRecord) {
        block2: {
            String string = null;
            if (logRecord == null) break block2;
            try {
                string = this.getFormatter().format(logRecord);
                Level level = logRecord.getLevel();
                this.preLogToCore(this.getNativeLevel(level.intValue()), level.getLocalizedName(), string);
            }
            catch (Exception exception) {
                ServerHandler.getLogger().log(Level.WARNING, "could not publish", exception);
            }
        }
    }

    private final void preLogToCore(int n, String string, String string2) throws Exception {
        int n2 = string2.length();
        if (n2 <= 3500) {
            ServerHandler.logToCore(n, string.getBytes(), string2.getBytes());
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            String string3 = n2 > n3 + 3500 ? string2.substring(n3, n3 + 3500) : string2.substring(n3);
            ServerHandler.logToCore(n, string.getBytes(), string3.getBytes());
            n3 += 3500;
        }
    }

    private int getNativeLevel(int n) {
        if (Level.FINE.intValue() >= n) {
            return 6;
        }
        if (Level.WARNING.intValue() == n) {
            return 0;
        }
        if (Level.SEVERE.intValue() == n) {
            return 3;
        }
        if (Level.INFO.intValue() == n) {
            return 5;
        }
        if (Level.CONFIG.intValue() == n) {
            return 5;
        }
        if (IASLevel.ALERT.intValue() == n) {
            return 3;
        }
        if (IASLevel.FATAL.intValue() == n) {
            return 4;
        }
        ServerHandler.getLogger().log(Level.WARNING, "unexpected log level " + n);
        return 6;
    }

    static {
        System.loadLibrary("j2eeplugin");
        _logger = null;
    }
}

