/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.server;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.instance.AppsManager;
import com.iplanet.ias.loader.EJBClassLoader;
import com.iplanet.ias.loader.EJBClassPathUtils;
import com.iplanet.ias.server.AbstractLoader;
import com.sun.logging.LogDomains;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class ApplicationLoader
extends AbstractLoader {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");

    ApplicationLoader(String string, ClassLoader classLoader, AppsManager appsManager) {
        super(string, classLoader, appsManager);
        String[] stringArray = EJBClassPathUtils.getEjbClasspath(string, appsManager);
        this.initializeLoader(stringArray);
        try {
            this.application = appsManager.getAppDescriptor(string, this.ejbClassLoader);
            try {
                Set set = this.getEJBClasses(this.application, this.ejbUrlClassLoader);
                ((EJBClassLoader)this.ejbClassLoader).addEjbClassNames(set);
            }
            catch (ClassNotFoundException classNotFoundException) {
                _logger.log(Level.WARNING, "loader.class_not_found", classNotFoundException);
            }
        }
        catch (ConfigException configException) {
            _logger.log(Level.SEVERE, "loader.error_while_loading_app_desc", configException);
        }
    }

    boolean load() {
        boolean bl = this.loadEjbs();
        if (bl) {
            bl = this.loadRars();
        }
        return bl;
    }

    boolean unload() {
        boolean bl = this.unloadEjbs();
        boolean bl2 = this.unloadRars();
        this.done();
        return bl && bl2;
    }
}

