/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.loader;

import com.iplanet.ias.loader.JasperAdapter;
import com.sun.appserv.server.util.PreprocessorUtil;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class EJBClassLoader
extends SecureClassLoader
implements JasperAdapter {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");
    private static String EJB_CODE_BASE = "ejb_impls/ejb.jar";
    private Set ejbClassSet = new HashSet();
    private List urlSet = Collections.synchronizedList(new ArrayList());
    private Map notFoundResources = new HashMap();
    private Map notFoundClasses = new HashMap();
    private static final boolean debug = false;
    private static CodeSource ejbCodeSource = null;

    public EJBClassLoader() {
    }

    public EJBClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void done() {
        int n = 0;
        while (n < this.urlSet.size()) {
            URLEntry uRLEntry = (URLEntry)this.urlSet.get(n);
            if (uRLEntry.zip != null) {
                try {
                    uRLEntry.zip.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            uRLEntry = null;
            ++n;
        }
        if (this.ejbClassSet != null) {
            this.ejbClassSet.clear();
        }
        if (this.urlSet != null) {
            this.urlSet.clear();
        }
        if (this.notFoundResources != null) {
            this.notFoundResources.clear();
        }
        if (this.notFoundClasses != null) {
            this.notFoundClasses.clear();
        }
        this.ejbClassSet = null;
        this.urlSet = null;
        this.notFoundResources = null;
        this.notFoundClasses = null;
    }

    public void addEjbClassNames(Set set) {
        this.ejbClassSet.addAll(set);
    }

    public synchronized void appendURL(URL uRL) {
        try {
            URLEntry uRLEntry = new URLEntry(uRL);
            this.urlSet.add(uRLEntry);
            if (uRLEntry.isJar) {
                this.checkManifest(uRLEntry.zip, uRLEntry.file);
            }
            this.notFoundResources.clear();
            this.notFoundClasses.clear();
        }
        catch (IOException iOException) {
            _logger.log(Level.SEVERE, "loader.ejbclassloader_bad_url_entry", uRL);
            _logger.log(Level.SEVERE, "loader.ejbclassloader_malformed_url", iOException);
        }
    }

    public synchronized URL[] getURLs() {
        URL[] uRLArray = null;
        if (this.urlSet != null) {
            uRLArray = new URL[this.urlSet.size()];
            int n = 0;
            while (n < uRLArray.length) {
                uRLArray[n] = ((URLEntry)this.urlSet.get((int)n)).source;
                ++n;
            }
        } else {
            uRLArray = new URL[]{};
        }
        return uRLArray;
    }

    private URL findResource0(final URLEntry uRLEntry, final String string) {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (uRLEntry.isJar) {
                    try {
                        JarEntry jarEntry = uRLEntry.zip.getJarEntry(string);
                        if (jarEntry != null) {
                            return new URL("jar:" + uRLEntry.source + "!/" + string);
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    try {
                        File file = new File(uRLEntry.file.getCanonicalPath() + File.separator + string);
                        if (file.exists()) {
                            return file.toURL();
                        }
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
        });
        return (URL)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL findResource(String string) {
        Object object;
        String string2 = (String)this.notFoundResources.get(string);
        if (string2 != null && string2.equals(string)) {
            return null;
        }
        int n = 0;
        while (n < this.urlSet.size()) {
            object = this.findResource0((URLEntry)this.urlSet.get(n), string);
            if (object != null) {
                return object;
            }
            ++n;
        }
        object = this.notFoundResources;
        synchronized (object) {
            this.notFoundResources.put(string, string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkManifest(JarFile jarFile, File file) throws IOException {
        if (jarFile == null || file == null) {
            return;
        }
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            return;
        }
        EJBClassLoader eJBClassLoader = this;
        synchronized (eJBClassLoader) {
            String string = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (string == null) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                File file2 = new File(file.getParentFile(), string2);
                try {
                    this.appendURL(file2.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    _logger.log(Level.SEVERE, "loader.ejbclassloader_malformed_url", malformedURLException);
                }
            }
        }
    }

    private byte[] loadClassData0(final URLEntry uRLEntry, final String string) {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    InputStream inputStream = null;
                    if (uRLEntry.isJar) {
                        JarFile jarFile = uRLEntry.zip;
                        ZipEntry zipEntry = jarFile.getEntry(string);
                        if (zipEntry != null) {
                            inputStream = jarFile.getInputStream(zipEntry);
                            byte[] byArray = EJBClassLoader.this.getClassData(inputStream);
                            return byArray;
                        }
                    } else {
                        File file = new File(uRLEntry.file, string.replace('/', File.separatorChar));
                        if (file.exists()) {
                            inputStream = new FileInputStream(file);
                            byte[] byArray = EJBClassLoader.this.getClassData(inputStream);
                            inputStream.close();
                            return byArray;
                        }
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
        });
        return (byte[])t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String string) throws ClassNotFoundException {
        Object object;
        String string2 = (String)this.notFoundClasses.get(string);
        if (string2 != null && string2.equals(string)) {
            throw new ClassNotFoundException(string);
        }
        String string3 = string.replace('.', '/') + ".class";
        int n = 0;
        while (n < this.urlSet.size()) {
            object = (URLEntry)this.urlSet.get(n);
            byte[] byArray = null;
            byArray = this.loadClassData0((URLEntry)object, string3);
            if (byArray != null) {
                Object object2;
                if (PreprocessorUtil.isPreprocessorEnabled()) {
                    byArray = PreprocessorUtil.processClass(string3, byArray);
                }
                CodeSource codeSource = null;
                codeSource = this.ejbClassSet.contains(string) ? ejbCodeSource : new CodeSource(((URLEntry)object).source, null);
                int n2 = string.lastIndexOf(46);
                if (n2 != -1 && this.getPackage((String)(object2 = string.substring(0, n2))) == null) {
                    try {
                        this.definePackage((String)object2, null, null, null, null, null, null, null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        _logger.log(Level.FINE, "duplicate package definition attempt for " + (String)object2, illegalArgumentException);
                    }
                }
                object2 = this.defineClass(string, byArray, 0, byArray.length, codeSource);
                return object2;
            }
            ++n;
        }
        object = this.notFoundClasses;
        synchronized (object) {
            this.notFoundClasses.put(string, string);
        }
        throw new ClassNotFoundException(string);
    }

    private byte[] getClassData(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void print(Object object) {
    }

    public String toString() {
        return "EJB CL: \n " + this.urlSet + " \n ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.getParent().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                EJBClassLoader eJBClassLoader = this;
                synchronized (eJBClassLoader) {
                    clazz = this.findClass(string);
                }
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    static {
        try {
            String string = System.getProperty("com.sun.aas.installRoot");
            String string2 = null;
            if (string != null) {
                string2 = string + File.separator + EJB_CODE_BASE;
            } else {
                string2 = ".";
                _logger.log(Level.WARNING, "loader.ejbclassloader_codesource_path", new Object[]{"com.sun.aas.installRoot", EJB_CODE_BASE});
            }
            ejbCodeSource = new CodeSource(new File(string2).toURL(), null);
        }
        catch (MalformedURLException malformedURLException) {
            _logger.log(Level.SEVERE, "loader.ejbclassloader_malformed_url", malformedURLException);
        }
    }

    protected static class URLEntry {
        URL source = null;
        File file = null;
        JarFile zip = null;
        boolean isJar = false;

        URLEntry(URL uRL) throws IOException {
            this.source = uRL;
            this.file = new File(uRL.getFile());
            this.isJar = this.file.isFile();
            if (this.isJar) {
                this.zip = new JarFile(this.file);
            }
        }
    }
}

