/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.ejb.codegen;

import com.iplanet.ias.ejb.codegen.EjbcContext;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.ejb.codegen.HomeGenerator;
import com.sun.ejb.codegen.WrapperGenerator;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

abstract class RedeployOptimizer {
    List _descriptorsRequiringCodeGen = new ArrayList();
    List _reusableDescriptors = new ArrayList();
    EjbcContext _ejbcCtx = null;
    boolean _reuse = true;
    private static final Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    RedeployOptimizer(EjbcContext ejbcContext, List list) throws IOException {
        this._ejbcCtx = ejbcContext;
        if (this._ejbcCtx.isRedeploy()) {
            this.validateReuse(list);
        } else {
            this._reuse = false;
        }
        this.init(list);
    }

    private void validateReuse(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)list.get(n2);
            if (arrayList.contains(ejbDescriptor.getHomeClassName()) || arrayList.contains(ejbDescriptor.getRemoteClassName()) || arrayList.contains(ejbDescriptor.getEjbImplClassName())) {
                this._reuse = false;
                break;
            }
            arrayList.add(ejbDescriptor.getHomeClassName());
            arrayList.add(ejbDescriptor.getRemoteClassName());
            arrayList.add(ejbDescriptor.getEjbImplClassName());
            ++n2;
        }
    }

    private void init(List list) throws IOException {
        if (!this._reuse) {
            this._descriptorsRequiringCodeGen = list;
        } else {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)list.get(n2);
                if (this.descriptorRequiresCodeGen(ejbDescriptor)) {
                    this._descriptorsRequiringCodeGen.add(ejbDescriptor);
                } else {
                    this._reusableDescriptors.add(ejbDescriptor);
                    ejbDescriptor.setEJBObjectImplClassName(WrapperGenerator.getDefaultEJBObjectImplClassName(ejbDescriptor));
                    ejbDescriptor.setRemoteHomeImplClassName(HomeGenerator.getDefaultRemoteHomeImplClassName(ejbDescriptor));
                }
                ++n2;
            }
        }
    }

    String findJar(String[] stringArray, String string) {
        String string2 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (FileUtils.hasExtension(stringArray[n], ".jar")) {
                try {
                    ZipFile zipFile = new ZipFile(stringArray[n]);
                    if (zipFile.getEntry(string) != null) {
                        string2 = stringArray[n];
                        _logger.log(Level.FINER, "[EJBC] Found class : " + string + " in path " + stringArray[n]);
                        break;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return string2;
    }

    boolean compareZipEntry(File file, File file2, String string) throws IOException {
        boolean bl = false;
        if (file.exists() && file2.exists()) {
            ZipFile zipFile = new ZipFile(file);
            ZipFile zipFile2 = new ZipFile(file2);
            ZipEntry zipEntry = zipFile.getEntry(string);
            ZipEntry zipEntry2 = zipFile2.getEntry(string);
            if (zipEntry != null && zipEntry2 != null && zipEntry.getCrc() == zipEntry2.getCrc() && zipEntry.getCompressedSize() == zipEntry2.getCompressedSize() && zipEntry.getSize() == zipEntry2.getSize() && zipEntry.hashCode() == zipEntry2.hashCode()) {
                bl = true;
            }
        }
        return bl;
    }

    abstract boolean descriptorRequiresCodeGen(EjbDescriptor var1) throws IOException;

    abstract void processReusableGeneratedFiles(Set var1) throws IOException;

    List getDescriptorsRequiringCodeGen() {
        return this._descriptorsRequiringCodeGen;
    }

    List getReusableDescriptors() {
        return this._reusableDescriptors;
    }

    boolean isReuse() {
        return this._reuse;
    }
}

