/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.deployment.backend.ContextRootChecker;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.deployment.backend.JSPCompiler;
import com.iplanet.ias.deployment.backend.ModuleDeployer;
import com.iplanet.ias.deployment.backend.WarExploder;
import com.iplanet.ias.deployment.backend.WebModuleInfo;
import com.iplanet.ias.instance.BaseManager;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.instance.ModuleEnvironment;
import com.iplanet.ias.instance.WebModulesManager;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFileException;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.ResultsReport;
import com.sun.enterprise.tools.verifier.Verifier;
import java.util.logging.Level;

public class WebModuleDeployer
extends ModuleDeployer {
    private WebModulesManager webModulesMgr = null;
    private boolean redeployWasRegisteredCold = false;
    private boolean redeployWasRegisteredHot = false;
    private String oldRegisteredContextRoot = null;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$WebModuleDeployer;

    WebModuleDeployer(DeploymentRequest deploymentRequest) throws IASDeploymentException {
        super(deploymentRequest);
    }

    public void cleanup_internal() {
        try {
            if (this.request.isUnDeploy()) {
                this.liquidate();
            } else if (this.request.isReDeploy() && this.isArchive() && this.oldModuleDir != null) {
                FileUtils.whack(this.oldModuleDir);
            }
        }
        catch (Exception exception) {
            this.logger.warning("Exception caught and ignored in cleanup_internal()");
        }
    }

    protected BaseManager createConfigManager(InstanceEnvironment instanceEnvironment, ModuleEnvironment moduleEnvironment) throws IASDeploymentException, ConfigException {
        this.webModulesMgr = new WebModulesManager(instanceEnvironment);
        return this.webModulesMgr;
    }

    protected void preDeploy() throws IASDeploymentException {
        try {
            if (!$assertionsDisabled && this.moduleDir == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && !StringUtils.ok((String)this.moduleName)) {
                throw new AssertionError();
            }
            if (this.isRegistered()) {
                String string = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
                throw new IASDeploymentException(string);
            }
            this.verifyContextRoot();
            this.liquidateModuleDirAndStubsDirIfTheyHappenToExist();
            if (this.request.isDirectory()) {
                this.moduleInfo = new WebModuleInfo(this.moduleDir, this.moduleName);
            } else {
                WarExploder warExploder = new WarExploder(this.moduleDir, this.request.getFileSource().getFile(), this.moduleName);
                this.moduleInfo = warExploder.explode();
            }
            this.register();
            this.runVerifier();
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    protected void deploy() throws IASDeploymentException, ConfigException {
        if (this.request.getPrecompileJSP()) {
            long l = System.currentTimeMillis();
            JSPCompiler jSPCompiler = new JSPCompiler(this.moduleDir, this.jspDir);
            jSPCompiler.compile();
            this.addJSPCTime(System.currentTimeMillis() - l);
        }
    }

    protected void preRedeploy() throws IASDeploymentException, ConfigException {
        if (!$assertionsDisabled && this.moduleDir == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !StringUtils.ok((String)this.moduleName)) {
            throw new AssertionError();
        }
        if (!this.isRegistered()) {
            String string = localStrings.getString("enterprise.deployment.backend.redeploy_error_module_not_registered");
            throw new IASDeploymentException(string);
        }
        this.verifyContextRoot();
        this.setOldDirs();
        if (this.request.isDirectory()) {
            this.moduleInfo = new WebModuleInfo(this.moduleDir, this.moduleName);
        } else {
            try {
                WarExploder warExploder = new WarExploder(this.moduleDir, this.request.getFileSource().getFile(), this.moduleName);
                this.moduleInfo = warExploder.explode();
            }
            catch (ZipFileException zipFileException) {
                throw new IASDeploymentException(zipFileException.toString(), zipFileException);
            }
        }
        this.redeployRegister();
        this.runVerifier();
    }

    protected void postRedeploy() throws IASDeploymentException, ConfigException {
        if (FileUtils.safeIsDirectory(this.oldJSPDir)) {
            FileUtils.whack(this.oldJSPDir);
        }
        this.backupFiles();
        this.saveHotConfigRedeploy();
    }

    protected void rollbackRedeploy() throws IASDeploymentException {
        if (this.isArchive() && FileUtils.safeIsDirectory(this.moduleDir)) {
            FileUtils.whack(this.moduleDir);
        }
        this.rollbackRedeployRegister();
        if (FileUtils.safeIsDirectory(this.jspDir)) {
            FileUtils.whack(this.jspDir);
        }
        if (FileUtils.safeIsDirectory(this.oldJSPDir)) {
            this.oldJSPDir.renameTo(this.jspDir);
        }
    }

    protected void register() throws IASDeploymentException, ConfigException {
        super.register();
        String string = this.request.getContextRoot();
        this.setContextRoot(string);
    }

    private void verifyContextRoot() throws IASDeploymentException {
        if (!$assertionsDisabled && this.webModulesMgr == null) {
            throw new AssertionError();
        }
        String string = this.request.getContextRoot();
        if (string == null) {
            String string2 = localStrings.getString("enterprise.deployment.backend.web_module_context_root_not_set");
            throw new IASDeploymentException(string2);
        }
        String[] stringArray = new String[]{string};
        ContextRootChecker contextRootChecker = new ContextRootChecker(this.getInstanceEnv(), stringArray, this.webModulesMgr, this.moduleName);
        contextRootChecker.check();
    }

    protected boolean needsJSPs() {
        return true;
    }

    protected final String whatTypeAmI() {
        return "Web Module";
    }

    final void redeployRegister() throws IASDeploymentException {
        if (!$assertionsDisabled && !this.request.isReDeploy()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.webModulesMgr == null) {
            throw new AssertionError();
        }
        try {
            this.oldRegisteredLocation = this.webModulesMgr.getLocation(this.moduleName);
            String string = this.moduleDir.getAbsolutePath();
            this.oldRegisteredContextRoot = this.webModulesMgr.getContextRoot(this.moduleName);
            String string2 = this.request.getContextRoot();
            if (!this.oldRegisteredLocation.equals(string) || !this.oldRegisteredContextRoot.equals(string2)) {
                this.webModulesMgr.setContextRoot(this.moduleName, string2);
                this.webModulesMgr.setLocation(this.moduleName, string);
                this.saveColdConfig();
                this.redeployWasRegisteredCold = true;
            }
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    final void rollbackRedeployRegister() {
        block6: {
            try {
                if (!$assertionsDisabled && !this.request.isReDeploy()) {
                    throw new AssertionError();
                }
                if (!this.redeployWasRegisteredCold) break block6;
                if (this.oldRegisteredLocation != null) {
                    this.webModulesMgr.setLocation(this.moduleName, this.oldRegisteredLocation);
                }
                if (this.oldRegisteredContextRoot != null) {
                    this.webModulesMgr.setContextRoot(this.moduleName, this.oldRegisteredContextRoot);
                }
                if (this.redeployWasRegisteredHot) {
                    this.saveHotConfig();
                    break block6;
                }
                this.saveColdConfig();
            }
            catch (Throwable throwable) {
                this.logger.warning(throwable.toString());
            }
        }
    }

    final void saveHotConfigRedeploy() throws IASDeploymentException {
        if (!$assertionsDisabled && !this.request.isReDeploy()) {
            throw new AssertionError();
        }
        try {
            if (this.redeployWasRegisteredCold) {
                this.saveHotConfig();
                this.redeployWasRegisteredHot = true;
            }
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    private void runVerifier() throws IASDeploymentException {
        if (this.request.isVerifying()) {
            try {
                String string = this.moduleDir.getCanonicalPath();
                WebBundleDescriptor webBundleDescriptor = WebModulesManager.getDescriptor(this.moduleName, string, true, true);
                Verifier verifier = new Verifier();
                ResultsReport resultsReport = verifier.verifyStdAloneWar(webBundleDescriptor);
                int n = resultsReport.getFailedCount();
                int n2 = resultsReport.getWarningCount();
                int n3 = resultsReport.getErrorCount();
                this.logger.log(Level.INFO, "enterprise.deployment_verifier_result", new Object[]{String.valueOf(n), String.valueOf(n2), String.valueOf(n3)});
                if (n > 0) {
                    String string2 = localStrings.getString("enterprise.deployment.backend.verifier_error", String.valueOf(n));
                    throw new IASDeploymentException(string2);
                }
            }
            catch (IASDeploymentException iASDeploymentException) {
                throw iASDeploymentException;
            }
            catch (Exception exception) {
                throw new IASDeploymentException(exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$deployment$backend$WebModuleDeployer == null ? (class$com$iplanet$ias$deployment$backend$WebModuleDeployer = WebModuleDeployer.class$("com.iplanet.ias.deployment.backend.WebModuleDeployer")) : class$com$iplanet$ias$deployment$backend$WebModuleDeployer).desiredAssertionStatus();
        localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$WebModuleDeployer == null ? (class$com$iplanet$ias$deployment$backend$WebModuleDeployer = WebModuleDeployer.class$("com.iplanet.ias.deployment.backend.WebModuleDeployer")) : class$com$iplanet$ias$deployment$backend$WebModuleDeployer);
    }
}

