/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.deployment.backend.AppDD;
import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.deployment.backend.EjbFullJarMaker;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.deployment.backend.MetaJarMaker;
import com.iplanet.ias.util.diagnostics.SystemProps;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.util.zip.ZipFileException;
import com.iplanet.ias.util.zip.ZipItem;
import com.iplanet.ias.util.zip.ZipWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

class ClientJarMaker {
    private File clientJar;
    private File tempClientJar = null;
    private File rootDir;
    private File[] ejbMetaJars;
    private File[] ejbModuleDirs;
    private File[] ejbClassFiles;
    private String[] ejbMetaJarEntryNames;
    private File[] appClientMetaJars;
    private File[] appClientModuleDirs;
    private File[] appClientClassFiles;
    private String[] appClientMetaJarEntryNames;
    private File[] appMetaFiles;
    private ZipItem[] allFiles;
    private AppDD appDD = null;
    private static boolean useHomemadeParser;
    private final Logger logger = DeploymentLogger.get();
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$ClientJarMaker;

    ClientJarMaker(File file, File file2) throws IASDeploymentException {
        try {
            this.clientJar = file2;
            this.rootDir = file;
            if (!FileUtils.safeIsDirectory(file)) {
                String string = localStrings.getString("enterprise.deployment.backend.bad_app_directory", file.getPath());
                throw new IASDeploymentException(string);
            }
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw iASDeploymentException;
        }
        catch (Exception exception) {
            throw new IASDeploymentException("" + exception, exception);
        }
    }

    void createAppClient(ZipItem[] zipItemArray) throws IASDeploymentException, ZipFileException {
        try {
            this.createAppDD();
            this.createEjbMetaJars();
            this.createAppClientMetaJars();
            this.createAppMetaFileList();
            this.createEjbClassFileList();
            this.createAppClientClassFileList();
            this.createAllFilesList(zipItemArray);
            this.createClientJar();
            this.cleanup();
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw iASDeploymentException;
        }
        catch (Exception exception) {
            throw new IASDeploymentException("" + exception, exception);
        }
    }

    void createAppDD() throws IASDeploymentException {
        try {
            this.appDD = new AppDD(this.rootDir, useHomemadeParser);
        }
        catch (Exception exception) {
            String string = localStrings.getString("enterprise.deployment.backend.error_creating_appdd", exception);
            throw new IASDeploymentException(string, exception);
        }
    }

    void createModuleClient(ZipItem[] zipItemArray) throws IASDeploymentException {
        try {
            new EjbFullJarMaker(this.clientJar, this.rootDir, zipItemArray);
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw iASDeploymentException;
        }
        catch (Exception exception) {
            throw new IASDeploymentException("" + exception, exception);
        }
    }

    private void createEjbMetaJars() throws IASDeploymentException {
        if (!$assertionsDisabled && this.ejbMetaJars != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.appDD == null) {
            throw new AssertionError();
        }
        String[] stringArray = this.appDD.getEjbModules();
        this.ejbModuleDirs = new File[stringArray.length];
        this.ejbMetaJars = new File[stringArray.length];
        this.ejbMetaJarEntryNames = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            this.ejbMetaJars[n] = this.createTempFile(string, this.rootDir);
            this.ejbModuleDirs[n] = new File(this.rootDir, FileUtils.makeFriendlyFilename(string));
            this.ejbMetaJarEntryNames[n] = string;
            this.createEjbMetaJar(this.ejbMetaJars[n], this.ejbModuleDirs[n]);
            ++n;
        }
    }

    private void createAppClientMetaJars() throws IASDeploymentException {
        if (!$assertionsDisabled && this.appClientMetaJars != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.appDD == null) {
            throw new AssertionError();
        }
        String[] stringArray = this.appDD.getClientModules();
        int n = stringArray.length;
        this.appClientModuleDirs = new File[n];
        this.appClientMetaJars = new File[n];
        this.appClientMetaJarEntryNames = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.appClientMetaJars[n2] = this.createTempFile(string, this.rootDir);
            this.appClientModuleDirs[n2] = new File(this.rootDir, FileUtils.makeFriendlyFilename(string));
            this.appClientMetaJarEntryNames[n2] = string;
            this.createAppClientMetaJar(this.appClientMetaJars[n2], this.appClientModuleDirs[n2]);
            ++n2;
        }
    }

    private void createEjbMetaJar(File file, File file2) throws IASDeploymentException {
        if (!FileUtils.safeIsDirectory(file2)) {
            String string = localStrings.getString("enterprise.deployment.backend.ejb_subdirectory_does_not_exist", this.getClass().getName(), file2.getPath());
            throw new IASDeploymentException(string);
        }
        new MetaJarMaker(file, file2);
    }

    private void createAppClientMetaJar(File file, File file2) throws IASDeploymentException {
        if (!FileUtils.safeIsDirectory(file2)) {
            String string = localStrings.getString("enterprise.deployment.backend.appclient_subdirectory_does_not_exist", this.getClass().getName(), file2.getPath());
            throw new IASDeploymentException(string);
        }
        new MetaJarMaker(file, file2);
    }

    private void createAppMetaFileList() {
        this.appMetaFiles = new File(this.rootDir, "META-INF").listFiles();
    }

    private void createEjbClassFileList() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.ejbModuleDirs.length) {
            List list = FileUtils.searchDir(this.ejbModuleDirs[n], ".class");
            if (list != null) {
                arrayList.addAll(list);
            }
            ++n;
        }
        this.ejbClassFiles = new File[arrayList.size()];
        this.ejbClassFiles = arrayList.toArray(this.ejbClassFiles);
    }

    private void createAppClientClassFileList() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.appClientModuleDirs.length) {
            List list = FileUtils.searchDir(this.appClientModuleDirs[n], ".class");
            if (list != null) {
                arrayList.addAll(list);
            }
            ++n;
        }
        this.appClientClassFiles = new File[arrayList.size()];
        this.appClientClassFiles = arrayList.toArray(this.appClientClassFiles);
    }

    private void createAllFilesList(ZipItem[] zipItemArray) throws IASDeploymentException, ZipFileException {
        String string;
        int n;
        int n2 = this.ejbMetaJars.length + this.appMetaFiles.length + this.ejbClassFiles.length;
        int n3 = this.rootDir.getPath().length() + 1;
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<ZipItem> arrayList = new ArrayList<ZipItem>();
        if (zipItemArray != null) {
            n = 0;
            while (n < zipItemArray.length) {
                string = zipItemArray[n].getName();
                if (!hashSet.add(string)) {
                    this.logger.finest("Duplicate file found - it will NOT be added to the list. Jar entry name: " + string + ", Filename: " + zipItemArray[n].getFile());
                } else {
                    arrayList.add(zipItemArray[n]);
                }
                ++n;
            }
        }
        File[] fileArray = this.ejbMetaJars;
        n = 0;
        while (n < fileArray.length) {
            string = this.ejbMetaJarEntryNames[n];
            if (!hashSet.add(string)) {
                this.logger.finest("Duplicate file found - it will NOT be added to the list. Jar entry name: " + string + ", Filename: " + fileArray[n]);
            } else {
                arrayList.add(new ZipItem(fileArray[n], string));
            }
            ++n;
        }
        fileArray = this.appClientMetaJars;
        int n4 = 0;
        while (n4 < fileArray.length) {
            String string2 = this.appClientMetaJarEntryNames[n4];
            if (!hashSet.add(string2)) {
                this.logger.finest("Duplicate file found - it will NOT be added to the list. Jar entry name: " + string2 + ", Filename: " + fileArray[n4]);
            } else {
                arrayList.add(new ZipItem(fileArray[n4], string2));
            }
            ++n4;
        }
        fileArray = this.appMetaFiles;
        int n5 = 0;
        while (n5 < fileArray.length) {
            String string3 = fileArray[n5].getPath().substring(n3).replace('\\', '/');
            if (!hashSet.add(string3)) {
                this.logger.finest("Duplicate file found - it will NOT be added to the list. Jar entry name: " + string3 + ", Filename: " + fileArray[n5]);
            } else {
                arrayList.add(new ZipItem(fileArray[n5], string3));
            }
            ++n5;
        }
        fileArray = this.ejbClassFiles;
        int n6 = 0;
        while (n6 < fileArray.length) {
            String string4 = fileArray[n6].getPath().substring(n3);
            int n7 = string4.indexOf(File.separatorChar);
            if (n7 < 0) {
                throw new IASDeploymentException("Internal Error - didn't find a '" + File.separatorChar + "' in the filename: " + string4);
            }
            if (!hashSet.add(string4 = string4.substring(n7 + 1).replace('\\', '/'))) {
                this.logger.finest("Duplicate file found - it will NOT be added to the list. Jar entry name: " + string4 + ", Filename: " + fileArray[n6]);
            } else {
                arrayList.add(new ZipItem(fileArray[n6], string4));
            }
            ++n6;
        }
        fileArray = this.appClientClassFiles;
        int n8 = 0;
        while (n8 < fileArray.length) {
            String string5 = fileArray[n8].getPath().substring(n3);
            int n9 = string5.indexOf(File.separatorChar);
            if (n9 < 0) {
                String string6 = localStrings.getString("enterprise.deployment.backend.did_not_find_separator", File.separator, string5);
                throw new IASDeploymentException(string6);
            }
            if (!hashSet.add(string5 = string5.substring(n9 + 1).replace('\\', '/'))) {
                this.logger.finest("Duplicate file found - it will NOT be added to the list. Jar entry name: " + string5 + ", Filename: " + fileArray[n8]);
            } else {
                arrayList.add(new ZipItem(fileArray[n8], string5));
            }
            ++n8;
        }
        this.logger.info("" + n2 + " total files, " + arrayList.size() + " files added to jar file");
        this.allFiles = new ZipItem[arrayList.size()];
        this.allFiles = arrayList.toArray(this.allFiles);
    }

    private void createClientJar() throws ZipFileException {
        ZipWriter zipWriter = new ZipWriter(this.clientJar.getPath(), this.rootDir.getPath(), this.allFiles);
        zipWriter.safeWrite();
    }

    private void cleanup() {
        if (!$assertionsDisabled && this.ejbMetaJars == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.appClientMetaJars == null) {
            throw new AssertionError();
        }
        int n = 0;
        while (n < this.ejbMetaJars.length) {
            if (!this.ejbMetaJars[n].delete()) {
                this.ejbMetaJars[n].deleteOnExit();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.appClientMetaJars.length) {
            if (!this.appClientMetaJars[n2].delete()) {
                this.appClientMetaJars[n2].deleteOnExit();
            }
            ++n2;
        }
        if (this.tempClientJar != null && this.tempClientJar.exists() && !this.tempClientJar.delete()) {
            this.tempClientJar.deleteOnExit();
        }
    }

    private File createTempFile(String string, File file) {
        if (string == null || string.length() < 3) {
            string = "tmp";
        }
        try {
            return File.createTempFile(string, ".jar", file);
        }
        catch (Exception exception) {
            return new File(file, string + ".tmp");
        }
    }

    public static void main(String[] stringArray) {
        useHomemadeParser = true;
        if (stringArray == null || stringArray.length != 2) {
            if (System.getProperty("user.name").equals("bnevins")) {
                stringArray = new String[]{"C:/temp/ConverterUser", "C:/temp/ConverterUser/TestClient.jar"};
            } else {
                System.out.println(SystemProps.toStringStatic());
                System.out.println("Usage:  ClientJarMaker app-dir client-jar-name");
                System.exit(1);
            }
        }
        try {
            ClientJarMaker clientJarMaker = new ClientJarMaker(new File(stringArray[0]), new File(stringArray[1]));
            clientJarMaker.createAppClient(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$deployment$backend$ClientJarMaker == null ? (class$com$iplanet$ias$deployment$backend$ClientJarMaker = ClientJarMaker.class$("com.iplanet.ias.deployment.backend.ClientJarMaker")) : class$com$iplanet$ias$deployment$backend$ClientJarMaker).desiredAssertionStatus();
        useHomemadeParser = false;
        localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$ClientJarMaker == null ? (class$com$iplanet$ias$deployment$backend$ClientJarMaker = ClientJarMaker.class$("com.iplanet.ias.deployment.backend.ClientJarMaker")) : class$com$iplanet$ias$deployment$backend$ClientJarMaker);
    }
}

