/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.deployment.backend.AppDeployer;
import com.iplanet.ias.deployment.backend.DeploymentRequest;
import com.iplanet.ias.deployment.backend.DirNameManager;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.util.i18n.StringManager;
import com.iplanet.ias.util.io.FileSource;
import com.iplanet.ias.util.io.FileUtils;
import java.io.File;
import java.util.logging.Level;

public class AppReDeployer
extends AppDeployer {
    private String failureMessage = "\n*********************\n****Redeployment Failed -- rolled back redeployment";
    private String successMessage = "\n*********************\n****Redeployment Successful for ";
    private File oldAppDir = null;
    private File oldStubsDir = null;
    private File oldJSPDir = null;
    private String oldRegisteredLocation = null;
    private boolean locationChangeWasRegisteredCold = false;
    private boolean locationChangeWasRegisteredHot = false;
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$AppReDeployer;

    AppReDeployer(DeploymentRequest deploymentRequest) throws IASDeploymentException {
        super(deploymentRequest);
    }

    public void cleanup_internal() {
        block3: {
            try {
                if (!this.isArchive() || this.oldAppDir == null) break block3;
                FileUtils.whack(this.oldAppDir);
                if (this.oldAppDir.exists()) {
                    this.logger.info("Unable to delete previous deployment directory: " + this.oldAppDir.getPath());
                    break block3;
                }
                this.logger.info("Deleted previous deployment directory: " + this.oldAppDir.getPath());
            }
            catch (Exception exception) {
                this.logger.info("Unable to delete previous deployment directory: " + this.oldAppDir.getPath());
            }
        }
    }

    protected final void predeploy() throws IASDeploymentException {
        this.setOldDirs();
    }

    protected final File setAppDir() throws IASDeploymentException {
        File file;
        if (this.isArchive()) {
            try {
                this.oldAppDir = new File(this.getAppMgr().getLocation(this.getAppName()));
            }
            catch (ConfigException configException) {
                String string = localStrings.getString("enterprise.deployment.backend.error_getting_app_location", this.getAppName());
                throw new IASDeploymentException(string, configException);
            }
            if (!FileUtils.safeIsDirectory(this.oldAppDir)) {
                file = this.oldAppDir;
                this.oldAppDir = null;
                this.logger.warning("Redeployment original directory doesn't exist");
            } else {
                File file2 = new File(this.getInstanceEnv().getApplicationRepositoryPath());
                DirNameManager dirNameManager = new DirNameManager(file2, this.oldAppDir, this.getAppName());
                file = dirNameManager.getNewDir();
            }
        } else if (this.isDirectory()) {
            FileSource fileSource = this.request.getFileSource();
            if (!fileSource.exists()) {
                String string = localStrings.getString("enterprise.deployment.backend.file_source_does_not_exist", fileSource);
                throw new IASDeploymentException(string);
            }
            if (!$assertionsDisabled && !fileSource.isDirectory()) {
                throw new AssertionError();
            }
            file = fileSource.getFile();
            this.oldAppDir = new File(this.getAppEnv().getAppBackupPath());
            if (!FileUtils.safeIsDirectory(this.oldAppDir)) {
                this.oldAppDir = null;
            }
        } else {
            String string = localStrings.getString("enterprise.deployment.backend.redeployment_not_dir_or_archive");
            throw new IASDeploymentException(string);
        }
        file.mkdirs();
        return file;
    }

    protected final File getOldStubsDir() {
        return this.oldStubsDir;
    }

    protected final File getOldAppDir() {
        return this.oldAppDir;
    }

    private final void setOldDirs() throws IASDeploymentException {
        File file = this.getStubsDir();
        File file2 = this.getJSPDir();
        if (FileUtils.safeIsDirectory(file)) {
            this.oldStubsDir = new File(file.getPath() + "_old");
            if (this.oldStubsDir.exists()) {
                if (this.oldStubsDir.isDirectory()) {
                    FileUtils.whack(this.oldStubsDir);
                } else {
                    this.oldStubsDir.delete();
                }
            }
            if (!file.renameTo(this.oldStubsDir)) {
                String string = localStrings.getString("enterprise.deployment.backend.directory_rename_error", file.getPath(), this.oldStubsDir.getPath());
                throw new IASDeploymentException(string);
            }
        }
        if (FileUtils.safeIsDirectory(file2)) {
            this.oldJSPDir = new File(file2.getPath() + "_old");
            if (this.oldJSPDir.exists()) {
                if (FileUtils.safeIsDirectory(this.oldJSPDir)) {
                    FileUtils.whack(this.oldJSPDir);
                } else {
                    this.oldJSPDir.delete();
                }
            }
            if (!file2.renameTo(this.oldJSPDir)) {
                String string = localStrings.getString("enterprise.deployment.backend.directory_rename_error", file2.getPath(), this.oldJSPDir.getPath());
                throw new IASDeploymentException(string);
            }
        }
    }

    protected void postDeploy() throws ConfigException, IASDeploymentException {
        super.postDeploy();
        if (FileUtils.safeIsDirectory(this.oldStubsDir)) {
            FileUtils.whack(this.oldStubsDir);
        }
        if (FileUtils.safeIsDirectory(this.oldJSPDir)) {
            FileUtils.whack(this.oldJSPDir);
        }
    }

    protected final void prePopulateConfig() throws IASDeploymentException {
        this.redeployRegister();
    }

    protected final void postPopulateConfig() throws ConfigException, IASDeploymentException {
        if (this.locationChangeWasRegisteredCold) {
            this.saveHotConfig();
        }
        this.locationChangeWasRegisteredHot = true;
    }

    protected final void rollback() {
        try {
            this.DeleteOrKeepFailedStubs(this.getStubsDir());
            if (FileUtils.safeIsDirectory(this.getJSPDir())) {
                FileUtils.whack(this.getJSPDir());
            }
            if (FileUtils.safeIsDirectory(this.oldStubsDir)) {
                this.oldStubsDir.renameTo(this.getStubsDir());
            }
            if (FileUtils.safeIsDirectory(this.oldJSPDir)) {
                this.oldJSPDir.renameTo(this.getJSPDir());
            }
            if (this.isArchive() && FileUtils.safeIsDirectory(this.getAppDir())) {
                FileUtils.whack(this.getAppDir());
            }
            this.rollbackRedeployRegister();
        }
        catch (Throwable throwable) {
            this.logger.log(Level.WARNING, "enterprise.deployment_rollback_error", throwable);
        }
    }

    protected String whatAreYou() {
        return "Redeployment";
    }

    private final void redeployRegister() throws IASDeploymentException {
        try {
            this.oldRegisteredLocation = this.getAppMgr().getLocation(this.getAppName());
            String string = this.getAppDir().getAbsolutePath();
            if (!this.oldRegisteredLocation.equals(string)) {
                this.getAppMgr().setLocation(this.getAppName(), string);
                this.saveColdConfig();
                this.locationChangeWasRegisteredCold = true;
            }
        }
        catch (Exception exception) {
            throw new IASDeploymentException(exception);
        }
    }

    private final void rollbackRedeployRegister() {
        block3: {
            try {
                if (!this.locationChangeWasRegisteredCold || this.oldRegisteredLocation == null) break block3;
                this.getAppMgr().setLocation(this.getAppName(), this.oldRegisteredLocation);
                if (this.locationChangeWasRegisteredHot) {
                    this.saveHotConfig();
                    break block3;
                }
                this.saveColdConfig();
            }
            catch (Throwable throwable) {
                this.logger.warning(throwable.toString());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$deployment$backend$AppReDeployer == null ? (class$com$iplanet$ias$deployment$backend$AppReDeployer = AppReDeployer.class$("com.iplanet.ias.deployment.backend.AppReDeployer")) : class$com$iplanet$ias$deployment$backend$AppReDeployer).desiredAssertionStatus();
        localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$AppReDeployer == null ? (class$com$iplanet$ias$deployment$backend$AppReDeployer = AppReDeployer.class$("com.iplanet.ias.deployment.backend.AppReDeployer")) : class$com$iplanet$ias$deployment$backend$AppReDeployer);
    }
}

