/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.deployment.backend;

import com.iplanet.ias.deployment.backend.DeploymentLogger;
import com.iplanet.ias.deployment.backend.IASDeploymentException;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.ParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

class AppDD {
    private File file = null;
    private Set ejbModules;
    private Set warModules;
    private Set rarModules;
    private Set clientModules;
    private Set contextRoots = null;
    private boolean useHomemade;
    private final Logger logger = DeploymentLogger.get();
    private static StringManager localStrings;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$iplanet$ias$deployment$backend$AppDD;

    AppDD(File file) throws IASDeploymentException, IOException, ParseException, ContentTransformationException {
        this(file, false);
    }

    AppDD(File file, boolean bl) throws IASDeploymentException, IOException, ParseException, ContentTransformationException {
        this.useHomemade = bl;
        if (file == null || !file.exists()) {
            String string = localStrings.getString("enterprise.deployment.backend.bad_file_parameter", file);
            throw new IllegalArgumentException(string);
        }
        if (file.isDirectory()) {
            file = new File(file, "META-INF");
            file = new File(file, "application.xml");
        }
        if (!file.exists() || file.isDirectory()) {
            String string = localStrings.getString("enterprise.deployment.backend.no_application_xml", file.getPath());
            throw new IASDeploymentException(string);
        }
        this.file = file;
        try {
            this.parse();
        }
        catch (Throwable throwable) {
            if (!bl) {
                throwable.printStackTrace();
                if (throwable instanceof IASDeploymentException) {
                    throw (IASDeploymentException)throwable;
                }
                String string = localStrings.getString("enterprise.deployment.backend.error_parsing_application_xml", this.file.getPath(), throwable);
                throw new IASDeploymentException(string, throwable);
            }
            this.logger.warning("Application.xml parsing failed.  Trying homemade parser");
            this.homemadeParse();
        }
    }

    String[] getEjbModules() {
        String[] stringArray = new String[this.ejbModules.size()];
        return this.ejbModules.toArray(stringArray);
    }

    String[] getWarModules() {
        String[] stringArray = new String[this.warModules.size()];
        return this.warModules.toArray(stringArray);
    }

    String[] getRarModules() {
        String[] stringArray = new String[this.rarModules.size()];
        return this.rarModules.toArray(stringArray);
    }

    String[] getClientModules() {
        String[] stringArray = new String[this.clientModules.size()];
        return this.clientModules.toArray(stringArray);
    }

    String[] getContextRoots() {
        String[] stringArray = new String[this.contextRoots.size()];
        return this.contextRoots.toArray(stringArray);
    }

    File getFile() {
        return this.file;
    }

    private void parse() throws IASDeploymentException, IOException, ParseException, ContentTransformationException {
        FileInputStream fileInputStream = new FileInputStream(this.file);
        ApplicationNode applicationNode = null;
        try {
            try {
                applicationNode = ApplicationNode.read(fileInputStream, false);
            }
            catch (Throwable throwable) {
                String string = localStrings.getString("enterprise.deployment.backend.error_parsing_application_xml", this.file.getPath(), throwable);
                throw new IASDeploymentException(string, throwable);
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        Application application = applicationNode.getApplication(null, null);
        this.ejbModules = applicationNode.getEjbBundleArchiveMap().keySet();
        this.warModules = applicationNode.getWebBundleArchiveMap().keySet();
        this.clientModules = applicationNode.getApplicationClientDescriptorArchiveMap().keySet();
        this.rarModules = applicationNode.getRarDescriptorArchiveMap().keySet();
        this.setContextRoots(applicationNode);
    }

    private void setContextRoots(ApplicationNode applicationNode) throws IASDeploymentException {
        if (!$assertionsDisabled && applicationNode == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.warModules == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.contextRoots != null) {
            throw new AssertionError();
        }
        this.contextRoots = new HashSet();
        Iterator iterator = this.warModules.iterator();
        while (iterator.hasNext()) {
            String string = applicationNode.getContextRootFor((String)iterator.next());
            if (this.contextRoots.add(string)) continue;
            String string2 = localStrings.getString("enterprise.deployment.backend.duplicate_context_root", string);
            throw new IASDeploymentException(string2);
        }
    }

    private void homemadeParse() throws ParseException {
        ArrayList arrayList = new ArrayList();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
            this.ejbModules = new HashSet();
            this.warModules = new HashSet();
            this.clientModules = new HashSet();
            this.rarModules = new HashSet();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf("<ejb>") >= 0) {
                    this.ejbModules.add(this.trim(string));
                    continue;
                }
                if (string.indexOf("<web-uri>") >= 0) {
                    this.warModules.add(this.trim(string));
                    continue;
                }
                if (string.indexOf("<java>") >= 0) {
                    this.clientModules.add(this.trim(string));
                    continue;
                }
                if (string.indexOf("<connector>") >= 0) {
                    this.rarModules.add(this.trim(string));
                    continue;
                }
                if (string.indexOf("<context-root>") < 0) continue;
                this.contextRoots.add(this.trim(string));
            }
        }
        catch (Exception exception) {
            String string = localStrings.getString("enterprise.deployment.backend.homemade_parser_error", exception);
            throw new ParseException(string);
        }
    }

    private String trim(String string) {
        int n = string.indexOf(">");
        String string2 = string.substring(n + 1);
        string2 = string2.substring(0, string2.indexOf("<"));
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$iplanet$ias$deployment$backend$AppDD == null ? (class$com$iplanet$ias$deployment$backend$AppDD = AppDD.class$("com.iplanet.ias.deployment.backend.AppDD")) : class$com$iplanet$ias$deployment$backend$AppDD).desiredAssertionStatus();
        localStrings = StringManager.getManager(class$com$iplanet$ias$deployment$backend$AppDD == null ? (class$com$iplanet$ias$deployment$backend$AppDD = AppDD.class$("com.iplanet.ias.deployment.backend.AppDD")) : class$com$iplanet$ias$deployment$backend$AppDD);
    }
}

