/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.connectors.deployment;

import com.iplanet.ias.admin.common.ResourceAdapterInfo;
import com.iplanet.ias.connectors.deployment.IASDeployedObjectsManager;
import com.iplanet.ias.connectors.deployment.IASDeploymentException;
import com.iplanet.ias.connectors.tools.security.PrincipalsTable;
import com.iplanet.ias.connectors.util.xml.ConfigProperty;
import com.iplanet.ias.connectors.util.xml.ConnectorDeploymentObject;
import com.iplanet.ias.connectors.util.xml.InstancePropertiesObject;
import com.iplanet.ias.util.i18n.StringManager;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.util.ConnectorClassLoader;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnectionFactory;

public class IASMCFFactory {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private static IASMCFFactory mcff = null;
    private static HashMap mcfCollection = new HashMap();
    private static HashMap configCollection = new HashMap();
    private static HashMap JNDINameCollection = new HashMap();
    private IASDeployedObjectsManager deployedObjMgr = null;
    private static StringManager localStrings = StringManager.getManager(class$com$iplanet$ias$connectors$deployment$IASMCFFactory == null ? (class$com$iplanet$ias$connectors$deployment$IASMCFFactory = IASMCFFactory.class$("com.iplanet.ias.connectors.deployment.IASMCFFactory")) : class$com$iplanet$ias$connectors$deployment$IASMCFFactory);
    static /* synthetic */ Class class$com$iplanet$ias$connectors$deployment$IASMCFFactory;

    private IASMCFFactory() throws IASDeploymentException {
        _logger.log(Level.FINE, "in IASMCFFactory");
        this.deployedObjMgr = new IASDeployedObjectsManager();
        this.loadAllMCF();
    }

    public static IASMCFFactory getMCFFactory() throws IASDeploymentException {
        if (mcff == null) {
            mcff = new IASMCFFactory();
        }
        return mcff;
    }

    private void loadAllMCF() throws IASDeploymentException {
        Set set = this.deployedObjMgr.getRAInstancesList();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ManagedConnectionFactory managedConnectionFactory = this.getManagedConnectionFactory(string, null);
            PrincipalsTable principalsTable = this.getSecurityTableByJndiName(string);
            principalsTable.setManagedConnectionFactory(managedConnectionFactory);
        }
    }

    public ConnectorDeploymentObject getDescriptorByJndiName(String string) throws IASDeploymentException {
        String string2 = this.getInstanceByJndiName(string).getRaName();
        return this.deployedObjMgr.getRAProperties(string2);
    }

    public InstancePropertiesObject getInstanceByJndiName(String string) throws IASDeploymentException {
        return this.deployedObjMgr.getInstanceProperties(string);
    }

    public PrincipalsTable getSecurityTableByJndiName(String string) throws IASDeploymentException {
        _logger.log(Level.FINE, "in getSecurityTableByJndiName");
        return this.deployedObjMgr.getInstanceProperties(string).getOriginalSecurityTable();
    }

    public Set getJNDINameList() {
        return this.deployedObjMgr.getRAInstancesList();
    }

    public Set getRANameList() {
        return this.deployedObjMgr.getConnectorsList();
    }

    public String getJNDINameByMCF(ManagedConnectionFactory managedConnectionFactory) {
        return (String)JNDINameCollection.get(managedConnectionFactory);
    }

    public String getUserByMCF(ManagedConnectionFactory managedConnectionFactory) {
        InstancePropertiesObject instancePropertiesObject = (InstancePropertiesObject)configCollection.get(managedConnectionFactory);
        if (instancePropertiesObject.isPropertyExists("UserName")) {
            ResourceProperty resourceProperty = instancePropertiesObject.getProperty("UserName");
            return (String)resourceProperty.getValue();
        }
        return null;
    }

    public String getPasswordByMCF(ManagedConnectionFactory managedConnectionFactory) {
        InstancePropertiesObject instancePropertiesObject = (InstancePropertiesObject)configCollection.get(managedConnectionFactory);
        if (instancePropertiesObject.isPropertyExists("Password")) {
            ResourceProperty resourceProperty = instancePropertiesObject.getProperty("Password");
            return (String)resourceProperty.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnectionFactory getManagedConnectionFactory(String string) throws IASDeploymentException {
        _logger.log(Level.FINE, "in start of  getManagedConnectionFactory");
        ManagedConnectionFactory managedConnectionFactory = null;
        HashMap hashMap = mcfCollection;
        synchronized (hashMap) {
            managedConnectionFactory = (ManagedConnectionFactory)mcfCollection.get(string);
            if (managedConnectionFactory == null) {
                _logger.log(Level.FINE, "Failed to get ManagedConnectionFactory instancename: " + string);
                String string2 = localStrings.getString("connectors.deployment.SHOULD_NOT_HAPPEN");
                throw new IASDeploymentException(string2);
            }
        }
        return managedConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnectionFactory getManagedConnectionFactory(String string, ClassLoader classLoader) throws IASDeploymentException {
        _logger.log(Level.FINE, "in start of  getManagedConnectionFactory");
        HashMap hashMap = mcfCollection;
        synchronized (hashMap) {
            if (mcfCollection.containsKey(string)) {
                return (ManagedConnectionFactory)mcfCollection.get(string);
            }
            _logger.log(Level.FINE, "before get properties");
            InstancePropertiesObject instancePropertiesObject = this.deployedObjMgr.getInstanceProperties(string);
            ConnectorDeploymentObject connectorDeploymentObject = this.deployedObjMgr.getRAProperties(instancePropertiesObject.getRaName());
            _logger.log(Level.FINE, "after get properties");
            Class<?> clazz = null;
            Vector vector = connectorDeploymentObject.jarList();
            Iterator iterator = vector.iterator();
            _logger.log(Level.FINE, "before  createLoader");
            try {
                _logger.log(Level.FINE, "after set Loader");
                if (classLoader == null) {
                    classLoader = ConnectorClassLoader.getInstance();
                }
                clazz = Class.forName(connectorDeploymentObject.getManagedConnectionFactoryClass(), true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                _logger.log(Level.FINE, "Failed to create Class for ManagedConnectionFactory:" + connectorDeploymentObject.getManagedConnectionFactoryClass(), classNotFoundException);
                String string2 = localStrings.getString("connectors.deployment.INVALID_CLASS", connectorDeploymentObject.getManagedConnectionFactoryClass());
                throw new IASDeploymentException(string2);
            }
            _logger.log(Level.FINE, "after create Class");
            ManagedConnectionFactory managedConnectionFactory = null;
            try {
                managedConnectionFactory = (ManagedConnectionFactory)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                _logger.log(Level.FINE, "Failed to create ManagedConnectionFactory instance:" + connectorDeploymentObject.getManagedConnectionFactoryClass(), illegalAccessException);
                String string3 = localStrings.getString("connectors.deployment.INVALID_CLASS", connectorDeploymentObject.getManagedConnectionFactoryClass());
                throw new IASDeploymentException(string3);
            }
            catch (InstantiationException instantiationException) {
                _logger.log(Level.FINE, "Failed to create ManagedConnectionFactory instance:" + connectorDeploymentObject.getManagedConnectionFactoryClass(), instantiationException);
                String string4 = localStrings.getString("connectors.deployment.INVALID_CLASS", connectorDeploymentObject.getManagedConnectionFactoryClass());
                throw new IASDeploymentException(string4);
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "Failed to create ManagedConnectionFactory instance:" + connectorDeploymentObject.getManagedConnectionFactoryClass(), exception);
                String string5 = localStrings.getString("connectors.deployment.INVALID_CLASS", connectorDeploymentObject.getManagedConnectionFactoryClass());
                throw new IASDeploymentException(string5);
            }
            _logger.log(Level.FINE, "after create mcf instance");
            ConfigProperty configProperty = null;
            Method method = null;
            Class[] classArray = new Class[1];
            Object[] objectArray = new Object[1];
            _logger.log(Level.FINE, "before get properties");
            iterator = instancePropertiesObject.getProperties().iterator();
            while (iterator.hasNext()) {
                configProperty = (ConfigProperty)iterator.next();
                _logger.log(Level.FINE, configProperty.getName());
                try {
                    classArray[0] = Class.forName(configProperty.getType());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    _logger.log(Level.FINE, "Property " + configProperty.getName() + " has invalid type " + configProperty.getType(), classNotFoundException);
                    String string6 = localStrings.getString("connectors.deployment.INVALID_PROPERTY_TYPE", configProperty.getName(), configProperty.getType());
                    throw new IASDeploymentException(string6);
                }
                try {
                    method = clazz.getMethod("set" + configProperty.getName(), classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    _logger.log(Level.FINE, "Method set" + configProperty.getName() + " was not found in class " + connectorDeploymentObject.getManagedConnectionFactoryClass(), noSuchMethodException);
                    String string7 = localStrings.getString("connectors.deployment.MISSING_METHOD", "set" + configProperty.getName(), connectorDeploymentObject.getManagedConnectionFactoryClass());
                    throw new IASDeploymentException(string7);
                }
                _logger.log(Level.FINE, "after get method set" + configProperty.getName());
                objectArray[0] = this.castPropertyValue((String)configProperty.getValue(), configProperty.getType());
                try {
                    method.invoke((Object)managedConnectionFactory, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    _logger.log(Level.FINE, "Failed to invoke method set" + configProperty.getName() + " in class " + connectorDeploymentObject.getManagedConnectionFactoryClass(), invocationTargetException);
                    String string8 = localStrings.getString("connectors.deployment.FAILED_TO_INVOKE_METHOD", "set" + configProperty.getName(), connectorDeploymentObject.getManagedConnectionFactoryClass());
                    throw new IASDeploymentException(string8);
                }
                catch (IllegalAccessException illegalAccessException) {
                    _logger.log(Level.FINE, "Failed to invoke method set" + configProperty.getName() + " in class " + connectorDeploymentObject.getManagedConnectionFactoryClass(), illegalAccessException);
                    String string9 = localStrings.getString("connectors.deployment.FAILED_TO_INVOKE_METHOD", "set" + configProperty.getName(), connectorDeploymentObject.getManagedConnectionFactoryClass());
                    throw new IASDeploymentException(string9);
                }
                _logger.log(Level.FINE, "after invoke method set" + configProperty.getName());
            }
            _logger.log(Level.FINE, "after set values to  mcf instance");
            mcfCollection.put(string, managedConnectionFactory);
            configCollection.put(managedConnectionFactory, instancePropertiesObject);
            JNDINameCollection.put(managedConnectionFactory, string);
            return managedConnectionFactory;
        }
    }

    public InstancePropertiesObject getInstanceProperties(ManagedConnectionFactory managedConnectionFactory) {
        return (InstancePropertiesObject)configCollection.get(managedConnectionFactory);
    }

    private Object castPropertyValue(String string, String string2) throws IASDeploymentException {
        if (string2.equals("java.lang.String")) {
            return string;
        }
        if (string2.equals("java.lang.Integer")) {
            return new Integer(string);
        }
        if (string2.equals("java.lang.Float")) {
            return new Float(string);
        }
        if (string2.equals("java.lang.Double")) {
            return new Double(string);
        }
        if (string2.equals("java.lang.Long")) {
            return new Long(string);
        }
        if (string2.equals("java.lang.Short")) {
            return new Short(string);
        }
        if (string2.equals("java.lang.Boolean")) {
            return new Boolean(string);
        }
        _logger.log(Level.FINE, "Property " + string + " has illegal type: " + string2);
        String string3 = localStrings.getString("connectors.deployment.INVALID_PROPERTY_TYPE", string, string2);
        throw new IASDeploymentException(string3);
    }

    public ResourceAdapterInfo getResourceAdapterProperties(String string) throws IASDeploymentException {
        ResourceAdapterInfo resourceAdapterInfo = null;
        ManagedConnectionFactory managedConnectionFactory = this.getManagedConnectionFactory(string, null);
        ConnectorDeploymentObject connectorDeploymentObject = this.deployedObjMgr.getRAProperties(string);
        Set set = connectorDeploymentObject.getProperties();
        resourceAdapterInfo = new ResourceAdapterInfo(string, this.getInstanceProperties(managedConnectionFactory), set);
        return resourceAdapterInfo;
    }

    public ResourceAdapterInfo[] getListOfResourceAdapters() throws IASDeploymentException {
        Set set = this.getJNDINameList();
        ResourceAdapterInfo[] resourceAdapterInfoArray = new ResourceAdapterInfo[set.size()];
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ManagedConnectionFactory managedConnectionFactory = this.getManagedConnectionFactory(string, null);
            ConnectorDeploymentObject connectorDeploymentObject = this.deployedObjMgr.getRAProperties(string);
            Set set2 = connectorDeploymentObject.getProperties();
            resourceAdapterInfoArray[n++] = new ResourceAdapterInfo(string, this.getInstanceProperties(managedConnectionFactory), set2);
        }
        return resourceAdapterInfoArray;
    }

    public void loadOneMCF(String string, String string2, ClassLoader classLoader) throws IASDeploymentException {
        _logger.log(Level.FINE, "in loadOneMCF");
        this.deployedObjMgr.loadOneConnector(string, string2, classLoader);
        String string3 = this.deployedObjMgr.getJndiName(string2);
        this.getManagedConnectionFactory(string3, classLoader);
    }

    public void unloadOneMCF(String string, String string2) throws IASDeploymentException {
        _logger.log(Level.FINE, "in unloadOneMCF");
        String string3 = this.deployedObjMgr.getJndiName(string2);
        this.deployedObjMgr.unloadOneConnector(string, string2);
        this.removeManagedConnectionFactory(string3);
    }

    private void removeManagedConnectionFactory(String string) {
        ManagedConnectionFactory managedConnectionFactory = (ManagedConnectionFactory)mcfCollection.get(string);
        configCollection.remove(managedConnectionFactory);
        JNDINameCollection.remove(managedConnectionFactory);
        mcfCollection.remove(string);
    }

    public String getJndiName(String string) throws IASDeploymentException {
        return this.deployedObjMgr.getJndiName(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

