/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.cis.channel.ssl;

import com.iplanet.ias.cis.LogWrap;
import com.iplanet.ias.cis.connection.SSLSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.net.ssl.SSLPeerUnverifiedException;

public class CISSSLSession
implements SSLSession {
    private static CertificateFactory certFactory;
    private int status;
    private String cipher;
    private int keySize;
    private int secretKeySize;
    private String issuer;
    private String subject;
    private X509Certificate[] cert;
    private String toString;
    private ByteArrayInputStream derInputStream;

    public CISSSLSession(int n, String string, int n2, int n3, String string2, String string3) {
        this(n, string, n2, n3, string2, string3, null);
    }

    public CISSSLSession(int n, String string, int n2, int n3, String string2, String string3, byte[] byArray) {
        this.status = n;
        this.cipher = string;
        this.keySize = n2;
        this.secretKeySize = n3;
        this.issuer = string2;
        this.subject = string3;
        if (byArray != null) {
            this.derInputStream = new ByteArrayInputStream(byArray);
            try {
                X509Certificate x509Certificate = (X509Certificate)certFactory.generateCertificate(this.derInputStream);
                this.cert = new X509Certificate[1];
                this.cert[0] = x509Certificate;
            }
            catch (CertificateException certificateException) {
                this.cert = null;
            }
            try {
                this.derInputStream.close();
            }
            catch (IOException iOException) {
                LogWrap.logger.log(Level.SEVERE, "cis.13", iOException);
            }
        } else {
            this.cert = null;
        }
        this.toString = "Status: " + n + "\n" + " Cipher: " + string + "\n" + " KeySize: " + n2 + "\n" + " SecretKeySize: " + n3 + "\n" + " Issuer: " + string2 + "\n" + " Subject: " + string3;
    }

    public int getStatus() {
        return this.status;
    }

    public String getCipher() {
        return this.cipher;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getSecretKeySize() {
        return this.secretKeySize;
    }

    public String getRemoteIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public X509Certificate[] getPeerCertificate() throws SSLPeerUnverifiedException {
        if (this.cert == null) {
            throw new SSLPeerUnverifiedException("Peer not authenticated");
        }
        return this.cert;
    }

    public String toString() {
        return this.toString;
    }

    static {
        System.loadLibrary("cis");
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            LogWrap.logger.log(Level.SEVERE, "cis.14", certificateException);
        }
    }
}

