/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.IiopService;
import com.iplanet.ias.config.serverbeans.Orb;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OrbTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    public static final String ERROR_MSG = "Message Fragment Size can be only 1024, 2048, 4096, 8192, 16284 or 32568";

    public Result check(ConfigContext configContext) {
        Result result;
        block18: {
            String string = null;
            result = super.getInitializedResult();
            try {
                Server server = (Server)configContext.getRootConfigBean();
                IiopService iiopService = server.getIiopService();
                Orb orb = iiopService.getOrb();
                string = orb.getMessageFragmentSize();
                int n = Integer.parseInt(string);
                int n2 = n / 1024;
                int n3 = n % 1024;
                if (n3 != 0) {
                    result.failed(ERROR_MSG);
                } else if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8 && n2 != 16 && n2 != 32) {
                    result.failed(ERROR_MSG);
                } else {
                    result.passed("Valid Message Fragment Size");
                }
                String string2 = orb.getSteadyThreadPoolSize();
                try {
                    if (Integer.parseInt(string2) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyThreadNegative", "Steady Thread Pool Size cannot be negative number"));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyThreadInvalid", "Steady Thread Pool Size : invalid number"));
                }
                String string3 = orb.getMaxThreadPoolSize();
                try {
                    if (Integer.parseInt(string3) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolNegative", "Max Thread Pool Size cannot be negative number"));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolInvalid", "Max Thread Pool Size : invalid number"));
                }
                String string4 = orb.getIdleThreadTimeoutInSeconds();
                try {
                    if (Integer.parseInt(string4) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutNegative", "Idle Thread Timeout cannot be negative number"));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutInvalid", "Idle Thread Timeout : invalid number"));
                }
                String string5 = orb.getMaxConnections();
                try {
                    if (Integer.parseInt(string5) >= 0) break block18;
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxConnNegative", "Max Connections cannot be negative number"));
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxConnInvalid", "Max Connections : invalid number"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidFragment", "Message Fragment Size - " + string + " : Invalid", new Object[]{string}));
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
                result.failed("Exception : " + exception.getMessage());
            }
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Result result = new Result();
        result.passed("Passed **");
        Object object = configContextEvent.getObject();
        String string = configContextEvent.getChoice();
        ConfigContext configContext = configContextEvent.getConfigContext();
        String string2 = configContextEvent.getBeanName();
        Object var7_7 = null;
        if (string2 != null) {
            return this.validateAttribute(configContextEvent.getName(), configContextEvent.getObject());
        }
        return result;
    }

    public Result validateAttribute(String string, Object object) {
        Result result;
        block28: {
            result = new Result();
            result.passed("Passed **");
            String string2 = null;
            if (string.equals(ServerTags.MESSAGE_FRAGMENT_SIZE)) {
                try {
                    string2 = (String)object;
                    int n = Integer.parseInt(string2);
                    int n2 = n / 1024;
                    int n3 = n % 1024;
                    if (n3 != 0) {
                        result.failed(ERROR_MSG);
                    } else if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8 && n2 != 16 && n2 != 32) {
                        result.failed(ERROR_MSG);
                    } else {
                        result.passed("Vaild Message Fragment Size");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidFragment", "Message Fragment Size - " + string2 + " : Invalid", new Object[]{string2}));
                }
            }
            if (string.equals(ServerTags.STEADY_THREAD_POOL_SIZE)) {
                try {
                    if (object != null) {
                        String string3 = (String)object;
                        if (Integer.parseInt(string3) < 0) {
                            result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyThreadNegative", "Steady Thread Pool Size cannot be negative number"));
                        } else {
                            result.passed("Passed ***");
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".steadyThreadInvalid", "Steady Thread Pool Size : invalid number"));
                }
            }
            if (string.equals(ServerTags.MAX_THREAD_POOL_SIZE)) {
                try {
                    if (object != null) {
                        String string4 = (String)object;
                        if (Integer.parseInt(string4) < 0) {
                            result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolNegative", "Max Thread Pool Size cannot be negative number"));
                        } else {
                            result.passed("Passed ***");
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxPoolInvalid", "Max Thread Pool Size : invalid number"));
                }
            }
            if (string.equals(ServerTags.IDLE_THREAD_TIMEOUT_IN_SECONDS)) {
                try {
                    if (object != null) {
                        String string5 = (String)object;
                        if (Integer.parseInt(string5) < 0) {
                            result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutNegative", "Idle Thread Timeout cannot be negative number"));
                        } else {
                            result.passed("Passed ***");
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".idleTimeoutInvalid", "Idle Thread Timeout : invalid number"));
                }
            }
            if (!string.equals(ServerTags.MAX_CONNECTIONS)) break block28;
            try {
                if (object == null) break block28;
                String string6 = (String)object;
                if (Integer.parseInt(string6) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxConnNegative", "Max Connections cannot be negative number"));
                    break block28;
                }
                result.passed("Passed ***");
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxConnInvalid", "Max Connections : invalid number"));
            }
        }
        return result;
    }
}

