/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.admin.verifier.tests.StaticTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.JdbcConnectionPool;
import com.iplanet.ias.config.serverbeans.JdbcResource;
import com.iplanet.ias.config.serverbeans.Resources;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public class JdbcConnectionPoolTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    static int minPool = 0;
    static String connValReqd = null;
    static String connValMethod = null;

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            Resources resources = server.getResources();
            JdbcConnectionPool[] jdbcConnectionPoolArray = resources.getJdbcConnectionPool();
            int n = 0;
            while (n < jdbcConnectionPoolArray.length) {
                int n2 = 0;
                int n3 = 0;
                try {
                    n2 = Integer.parseInt(jdbcConnectionPoolArray[n].getSteadyPoolSize());
                    n3 = Integer.parseInt(jdbcConnectionPoolArray[n].getMaxPoolSize());
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".badNumber", "Bad Number"));
                }
                if (n3 < n2) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".sizeLTMax", "Steady Pool size should be less than or equal to Maximum Pool size"));
                }
                if (jdbcConnectionPoolArray[n].isIsConnectionValidationRequired() && jdbcConnectionPoolArray[n].getConnectionValidationMethod().equals("table")) {
                    if (jdbcConnectionPoolArray[n].getValidationTableName() == null || jdbcConnectionPoolArray[n].getValidationTableName().equals("")) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".tblNameRequired", "Required Table Name if Connection validation method is Table for " + jdbcConnectionPoolArray[n].getName(), new Object[]{jdbcConnectionPoolArray[n].getName()}));
                    } else {
                        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validTblName", "Validation Table Name for " + jdbcConnectionPoolArray[n].getName(), new Object[]{jdbcConnectionPoolArray[n].getName()}));
                    }
                } else {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".validPool", "Validation Passed for Connection Pool" + jdbcConnectionPoolArray[n].getName(), new Object[]{jdbcConnectionPoolArray[n].getName()}));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Result result = new Result();
        result.passed("Passed **");
        ConfigContext configContext = configContextEvent.getConfigContext();
        Object object = configContextEvent.getObject();
        String string = configContextEvent.getChoice();
        String string2 = configContextEvent.getBeanName();
        if (string2 != null) {
            String string3 = configContextEvent.getName();
            return this.testSave(string3, (String)object);
        }
        JdbcConnectionPool jdbcConnectionPool = (JdbcConnectionPool)object;
        String string4 = jdbcConnectionPool.getName();
        if (!StaticTest.checkObjectName(string4, result)) {
            result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidPoolName", "Connection Pool Name Invalid "));
            return result;
        }
        result.passed(this.smh.getLocalString(this.getClass().getName() + ".validOject", "Valid Object Name"));
        String string5 = jdbcConnectionPool.getDatasourceClassname();
        if (string != null && string.equals("DELETE")) {
            try {
                Server server = (Server)configContext.getRootConfigBean();
                Resources resources = server.getResources();
                JdbcResource[] jdbcResourceArray = resources.getJdbcResource();
                if (jdbcResourceArray.length == 0) {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".poolNotUsed", "Connection Pool not used by data source"));
                }
                int n = 0;
                while (n < jdbcResourceArray.length) {
                    if (jdbcResourceArray[n].getPoolName().equals(string4)) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".poolUsed", "Connection Pool Used by Existing data source, cannot delete pool"));
                        break;
                    }
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".poolNotUsed", "Connection Pool not used by data source"));
                    ++n;
                }
            }
            catch (Exception exception) {}
        } else if (jdbcConnectionPool.isIsConnectionValidationRequired() && jdbcConnectionPool.getConnectionValidationMethod().equals("table")) {
            if (jdbcConnectionPool.getValidationTableName() == null || jdbcConnectionPool.getValidationTableName().equals("")) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".requiredTblName", "Required Table Name if Connection validation method is Table"));
            } else {
                result.passed(this.smh.getLocalString(this.getClass().getName() + ".tblName", "Validation Table Name"));
            }
        } else {
            result.passed("****** Passed Validation Table Name");
        }
        return result;
    }

    public Result testSave(String string, String string2) {
        Result result;
        block24: {
            result = new Result();
            result.passed("Passed **");
            if (string.equals(ServerTags.STEADY_POOL_SIZE)) {
                try {
                    minPool = Integer.parseInt(string2);
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".passed", "Passed "));
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".badPoolSize", "Bad Number : Steady pool size"));
                }
            }
            if (string.equals(ServerTags.MAX_POOL_SIZE)) {
                try {
                    int n = Integer.parseInt(string2);
                    if (n < minPool) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".sizeLTMax", "Steady Pool size should be less than or equal to Maximum Pool size"));
                    } else {
                        result.passed(this.smh.getLocalString(this.getClass().getName() + ".passed", "Passed "));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".badMaxSize", "Bad Number : Max pool size"));
                }
            }
            if (string.equals(ServerTags.IS_CONNECTION_VALIDATION_REQUIRED)) {
                connValReqd = string2;
            }
            if (string.equals(ServerTags.CONNECTION_VALIDATION_METHOD)) {
                connValMethod = string2;
            }
            if (string.equals(ServerTags.VALIDATION_TABLE_NAME)) {
                if (connValReqd.equals("true")) {
                    if (connValMethod.equals("table")) {
                        if (string2 == null || string2.equals("")) {
                            result.failed(this.smh.getLocalString(this.getClass().getName() + ".requiredTbl", "Required table name"));
                        } else {
                            result.passed("Passed ***");
                        }
                    } else {
                        result.passed("Passed ***");
                    }
                } else {
                    result.passed("Passed ***");
                }
            }
            if (string.equals(ServerTags.TRANSACTION_ISOLATION_LEVEL) && string2 != null) {
                String string3 = string2;
                if (string3.equals("")) {
                    result.failed("Transaction Isolation Level not specified");
                } else if (string3.equals("read-uncommitted") || string3.equals("read-committed") || string3.equals("repeatable-read") || string3.equals("serializable")) {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".validLevel", "Valid Transaction Isolation Level" + string3));
                } else {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidLevel", "Invalid Transaction Isolation Level: " + string3, new Object[]{string3}));
                }
            }
            if (!string.equals(ServerTags.IDLE_TIMEOUT_IN_SECONDS) || string2 == null) break block24;
            try {
                Integer.parseInt(string2);
                result.passed("Passed ***");
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidIdle", "Idle Timeout : invalid number"));
            }
        }
        return result;
    }

    public boolean isInValidDataSource(Result result, String string) {
        boolean bl;
        block4: {
            bl = true;
            try {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                if (obj instanceof DataSource) {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".validSource", "Valid Data Source"));
                    bl = false;
                    break block4;
                }
                if (obj instanceof XADataSource) {
                    result.passed(this.smh.getLocalString(this.getClass().getName() + ".validXA", "Valid XA DataSource"));
                    bl = false;
                    break block4;
                }
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidClass", "Invalid  Data Source Class not implementing, javax.sql.DataSource or javax.sql.XADataSource"));
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "serverxmlverifier.error_instantiation", exception.getMessage());
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".invalidDSClass", "Invalid DataSource class"));
            }
        }
        return bl;
    }
}

