/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.verifier.tests;

import com.iplanet.ias.admin.verifier.ServerCheck;
import com.iplanet.ias.admin.verifier.ServerXmlTest;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigContextEvent;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerTags;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationsTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");

    public Result check(ConfigContext configContext) {
        Result result = super.getInitializedResult();
        try {
            Server server = (Server)configContext.getRootConfigBean();
            Applications applications = server.getApplications();
            String string = applications.getDynamicReloadPollIntervalInSeconds();
            try {
                if (Integer.parseInt(string) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".reloadNegative", "Reload Poll Interval cannot be negative number"));
                } else {
                    result.passed("Passed *** ");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".reloadInvalid", "Reload Poll Interval : invalid number"));
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "serverxmlverifier.exception", exception);
            result.failed("Exception : " + exception.getMessage());
        }
        return result;
    }

    public Result check(ConfigContextEvent configContextEvent) {
        Object object = configContextEvent.getObject();
        ConfigContext configContext = configContextEvent.getConfigContext();
        Result result = new Result();
        result.passed("Passed ** ");
        String string = configContextEvent.getBeanName();
        if (string != null) {
            String string2 = configContextEvent.getName();
            if (string2 != null && object != null) {
                result = this.validateAttribute(string2, (String)object);
            }
            return result;
        }
        return result;
    }

    public Result validateAttribute(String string, String string2) {
        boolean bl = false;
        Result result = new Result();
        result.passed("Passed **");
        if (string.equals(ServerTags.DYNAMIC_RELOAD_POLL_INTERVAL_IN_SECONDS)) {
            try {
                if (Integer.parseInt(string2) < 0) {
                    result.failed(this.smh.getLocalString(this.getClass().getName() + ".reloadNegative", "Reload Poll Interval cannot be negative number"));
                    bl = true;
                } else {
                    result.passed("passed ***");
                }
            }
            catch (NumberFormatException numberFormatException) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".reloadInvalid", "Reload Poll Interval : invalid number"));
                bl = true;
            }
        }
        if (bl) {
            result.setStatus(1);
        }
        return result;
    }
}

