/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sql.generator;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.database.DBVendorType;
import com.sun.jdo.spi.persistence.support.sqlstore.model.LocalFieldDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintNode;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.constraint.ConstraintValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.ColumnRef;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.DBStatement;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.InputValue;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryPlan;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.QueryTable;
import com.sun.jdo.spi.persistence.support.sqlstore.sql.generator.Statement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UpdateStatement
extends Statement
implements Cloneable {
    public static int PROP_CONSTRAINT_ADDED = 1;
    private Map dbStatementCache = new HashMap();
    private List columnRefsForWhereClause = new ArrayList();
    private boolean batch = false;

    public UpdateStatement(DBVendorType dBVendorType, QueryPlan queryPlan, boolean bl) {
        super(dBVendorType, queryPlan);
        this.batch = bl;
    }

    public void addColumn(ColumnElement columnElement, Object object) {
        this.addColumnRef(new ColumnRef(columnElement, object));
    }

    protected void addConstraint(ColumnElement columnElement, LocalFieldDesc localFieldDesc, Object object) {
        this.columnRefsForWhereClause.add(new ColumnRef(columnElement, object));
        this.addConstraint(localFieldDesc, object);
    }

    public List getColumnRefsForWhereClause() {
        return this.columnRefsForWhereClause;
    }

    private void calculateWhereClauseColumnRefIndexes() {
        int n = this.columns.size() + this.columnRefsForWhereClause.size();
        Iterator iterator = this.columnRefsForWhereClause.iterator();
        while (iterator.hasNext()) {
            ColumnRef columnRef = (ColumnRef)iterator.next();
            columnRef.setIndex(n--);
        }
    }

    public boolean constraintAdded() {
        return (this.properties & PROP_CONSTRAINT_ADDED) > 0;
    }

    public String getText() {
        Object object;
        StringBuffer stringBuffer;
        if (this.statementText != null) {
            return this.statementText.toString();
        }
        this.statementText = stringBuffer = new StringBuffer();
        if (this.columns.size() < 1 && this.action != 3) {
            return stringBuffer.toString();
        }
        String string = this.processConstraints();
        if (string == null) {
            string = new String();
        }
        int n = -1;
        StringBuffer stringBuffer2 = null;
        StringBuffer stringBuffer3 = new StringBuffer();
        int n2 = 0;
        while (n2 < this.columns.size()) {
            object = (ColumnRef)this.columns.get(n2);
            if (stringBuffer3.length() > 0) {
                stringBuffer3.append(", ");
            }
            switch (this.action) {
                case 1: {
                    stringBuffer3.append(this.quoteCharStart);
                    stringBuffer3.append(((ColumnRef)object).getName());
                    stringBuffer3.append(this.quoteCharEnd);
                    stringBuffer3.append("=?");
                    break;
                }
                case 2: {
                    stringBuffer3.append(this.quoteCharStart);
                    stringBuffer3.append(((ColumnRef)object).getName());
                    stringBuffer3.append(this.quoteCharEnd);
                    if (n2 == 0) {
                        stringBuffer2 = new StringBuffer().append("?");
                        break;
                    }
                    stringBuffer2.append(",?");
                }
            }
            if (!(this.batch || this.action != 1 && this.action != 2)) {
                InputValue inputValue = new InputValue();
                inputValue.value = ((ColumnRef)object).getValue();
                inputValue.sqlType = ((ColumnRef)object).getColumnElement().getType();
                this.inputDesc.values.add(++n, inputValue);
            }
            ++n2;
        }
        object = ((QueryTable)this.tableList.get(0)).getTableDesc().getName();
        switch (this.action) {
            case 1: {
                stringBuffer.append("update ").append(this.quoteCharStart).append((String)object).append(this.quoteCharEnd).append(" set ").append(stringBuffer3).append(string);
                break;
            }
            case 3: {
                stringBuffer.append("delete from ").append(this.quoteCharStart).append((String)object).append(this.quoteCharEnd).append(string);
                break;
            }
            case 2: {
                stringBuffer.append("insert into ").append(this.quoteCharStart).append((String)object).append(this.quoteCharEnd).append("(").append(stringBuffer3).append(") values").append("(").append(stringBuffer2).append(")");
            }
        }
        this.calculateWhereClauseColumnRefIndexes();
        return stringBuffer.toString();
    }

    public String processConstraints() {
        StringBuffer stringBuffer = null;
        ArrayList arrayList = (ArrayList)this.constraint.stack.clone();
        while (arrayList.size() > 0) {
            ConstraintNode constraintNode = (ConstraintNode)arrayList.get(arrayList.size() - 1);
            int n = 0;
            if (!(constraintNode instanceof ConstraintOperation)) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(Statement.messages, "core.generic.notinstanceof", constraintNode.getClass().getName(), "ConstraintOperation"));
            }
            n = ((ConstraintOperation)constraintNode).operation;
            int n2 = this.operationFormat(n);
            if ((n2 & 0x20) > 0) {
                StringBuffer stringBuffer2 = stringBuffer;
                stringBuffer = new StringBuffer().append(this.getWhereText(arrayList));
                if (stringBuffer2 == null || stringBuffer2.length() <= 0) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer2.append(" and ");
                }
                stringBuffer2.append(stringBuffer);
                stringBuffer = stringBuffer2;
                continue;
            }
            arrayList.remove(arrayList.size() - 1);
            while (arrayList.size() > 0 && arrayList.get(arrayList.size() - 1) instanceof ConstraintOperation) {
                arrayList.remove(arrayList.size() - 1);
            }
        }
        StringBuffer stringBuffer3 = new StringBuffer();
        if (stringBuffer != null && stringBuffer.length() > 0) {
            stringBuffer3.append(" where ");
            stringBuffer3.append(stringBuffer);
        }
        return stringBuffer3.toString();
    }

    protected void processConstraintValue(ConstraintValue constraintValue, StringBuffer stringBuffer) {
        stringBuffer.append("?");
        if (!this.batch) {
            this.inputDesc.values.add(new InputValue(null, constraintValue.value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBStatement getDBStatement(Transaction transaction, Connection connection) throws SQLException {
        DBStatement dBStatement = null;
        Map map = this.dbStatementCache;
        synchronized (map) {
            dBStatement = (DBStatement)this.dbStatementCache.get(transaction);
            if (dBStatement == null) {
                dBStatement = new DBStatement(connection, this.getText(), transaction.getUpdateTimeout());
                this.dbStatementCache.put(transaction, dBStatement);
            }
        }
        return dBStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exceedsBatchThreshold(Transaction transaction) {
        Map map = this.dbStatementCache;
        synchronized (map) {
            DBStatement dBStatement = (DBStatement)this.dbStatementCache.get(transaction);
            return dBStatement != null && dBStatement.exceedsBatchThreshold();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBStatement removeDBStatement(Transaction transaction) {
        Map map = this.dbStatementCache;
        synchronized (map) {
            DBStatement dBStatement = (DBStatement)this.dbStatementCache.remove(transaction);
            return dBStatement;
        }
    }
}

