/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.mapping.impl;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.util.NameUtil;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.ModelVetoException;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingReferenceKeyElement;
import com.sun.jdo.api.persistence.model.mapping.MappingTableElement;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingClassElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingMemberElementImpl;
import com.sun.jdo.api.persistence.model.mapping.impl.MappingReferenceKeyElementImpl;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;

public class MappingTableElementImpl
extends MappingMemberElementImpl
implements MappingTableElement {
    private ArrayList _key;
    private transient ArrayList _keyObjects;
    private ArrayList _referencingKeys;
    private String _table;
    private transient TableElement _tableObject;

    public MappingTableElementImpl() {
        this((String)null, null);
    }

    public MappingTableElementImpl(String string, MappingClassElement mappingClassElement) {
        super(string, mappingClassElement);
    }

    public MappingTableElementImpl(TableElement tableElement, MappingClassElement mappingClassElement) throws ModelException {
        this(tableElement.toString(), mappingClassElement);
        this._table = this.getName();
        this._tableObject = tableElement;
    }

    public String getTable() {
        return this._table;
    }

    public void setTable(TableElement tableElement) throws ModelException {
        String string = this.getTable();
        String string2 = tableElement.toString();
        try {
            this.fireVetoableChange("table", string, string2);
            this._table = string2;
            this.firePropertyChange("table", string, string2);
            this.setName(this._table);
            this._tableObject = tableElement;
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    public void setName(String string) throws ModelException {
        super.setName(string);
        if (this.getTable() == null) {
            this._table = string;
        }
    }

    public boolean isEqual(TableElement tableElement) {
        return tableElement != null ? this.getTable().equals(tableElement.toString()) : false;
    }

    public ArrayList getKey() {
        if (this._key == null) {
            this._key = new ArrayList();
        }
        return this._key;
    }

    public void addKeyColumn(ColumnElement columnElement) throws ModelException {
        if (columnElement != null) {
            String string = NameUtil.getRelativeMemberName(columnElement.getName().getFullName());
            if (!this.getKey().contains(string)) {
                this.addKeyColumnInternal(columnElement);
            }
        } else {
            throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.element.null_argument"));
        }
    }

    protected void addKeyColumnInternal(ColumnElement columnElement) throws ModelException {
        ArrayList arrayList = this.getKey();
        String string = NameUtil.getRelativeMemberName(columnElement.getName().getFullName());
        try {
            this.fireVetoableChange("keyColumns", null, null);
            arrayList.add(string);
            this.firePropertyChange("keyColumns", null, null);
            this._keyObjects = null;
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    public void removeKeyColumn(String string) throws ModelException {
        if (string != null) {
            try {
                this.fireVetoableChange("keyColumns", null, null);
                if (!this.getKey().remove(string)) {
                    throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.element.element_not_removed", string));
                }
                this.firePropertyChange("keyColumns", null, null);
                this._keyObjects = null;
            }
            catch (PropertyVetoException propertyVetoException) {
                throw new ModelVetoException(propertyVetoException);
            }
        }
    }

    public ArrayList getReferencingKeys() {
        if (this._referencingKeys == null) {
            this._referencingKeys = new ArrayList();
        }
        return this._referencingKeys;
    }

    public void addReferencingKey(MappingReferenceKeyElement mappingReferenceKeyElement) throws ModelException {
        try {
            this.fireVetoableChange("referencingKeys", null, null);
            this.getReferencingKeys().add(mappingReferenceKeyElement);
            this.firePropertyChange("referencingKeys", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new ModelVetoException(propertyVetoException);
        }
    }

    public void removeReference(MappingTableElement mappingTableElement) throws ModelException {
        if (mappingTableElement != null) {
            Iterator iterator = this.getReferencingKeys().iterator();
            while (iterator.hasNext()) {
                MappingReferenceKeyElement mappingReferenceKeyElement = (MappingReferenceKeyElement)iterator.next();
                if (!mappingReferenceKeyElement.getTable().equals(mappingTableElement)) continue;
                try {
                    this.fireVetoableChange("referencingKeys", null, null);
                    iterator.remove();
                    this.firePropertyChange("referencingKeys", null, null);
                }
                catch (PropertyVetoException propertyVetoException) {
                    throw new ModelVetoException(propertyVetoException);
                }
            }
        } else {
            throw new ModelException(I18NHelper.getMessage(MappingElementImpl.getMessages(), "mapping.element.null_argument"));
        }
    }

    public TableElement getTableObject() {
        if (this._tableObject == null) {
            String string = NameUtil.getAbsoluteTableName(this.getDeclaringClass().getDatabaseRoot(), this._table);
            this._tableObject = TableElement.forName(string);
        }
        return this._tableObject;
    }

    public ArrayList getKeyObjects() {
        if (this._keyObjects == null) {
            this._keyObjects = MappingClassElementImpl.toColumnObjects(this.getDeclaringClass().getDatabaseRoot(), this.getKey());
        }
        return this._keyObjects;
    }

    public void setTable(String string) {
        this._table = string;
    }

    public void setKey(ArrayList arrayList) {
        this._key = arrayList;
    }

    public void setReferencingKeys(ArrayList arrayList) {
        this._referencingKeys = arrayList;
    }

    protected void stripSchemaName() {
        Iterator<String> iterator;
        this._name = NameUtil.getRelativeTableName(this._name);
        this._table = NameUtil.getRelativeTableName(this._table);
        if (this._referencingKeys != null) {
            iterator = this._referencingKeys.iterator();
            while (iterator.hasNext()) {
                MappingReferenceKeyElementImpl mappingReferenceKeyElementImpl = (MappingReferenceKeyElementImpl)iterator.next();
                mappingReferenceKeyElementImpl.stripSchemaName();
            }
        }
        if (this._key != null) {
            iterator = this._key.listIterator();
            while (iterator.hasNext()) {
                iterator.set(NameUtil.getRelativeMemberName((String)iterator.next()));
            }
        }
    }
}

