/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.util;

import com.sun.jdo.api.persistence.enhancer.util.ClassFileSource;
import com.sun.jdo.api.persistence.enhancer.util.ClassPath;
import com.sun.jdo.api.persistence.enhancer.util.ClassPathElement;
import com.sun.jdo.api.persistence.enhancer.util.DirectoryClassPackageEnumerator;
import com.sun.jdo.api.persistence.enhancer.util.FilePath;
import java.io.File;
import java.util.Enumeration;

class DirectoryClassPathElement
extends ClassPathElement {
    private File directory;
    private boolean exists;

    public ClassFileSource sourceOf(String string) {
        File file = this.fileOf(string);
        if (file != null && file.exists()) {
            return new ClassFileSource(string, file);
        }
        return null;
    }

    public Enumeration classesInPackage(String string) {
        if (!this.exists) {
            return null;
        }
        return new DirectoryClassPackageEnumerator(this.directory, string);
    }

    boolean matches(File file) {
        String string = FilePath.canonicalize(this.directory);
        String string2 = FilePath.canonicalize(file);
        return FilePath.canonicalNamesEqual(string, string2);
    }

    DirectoryClassPathElement(File file) {
        this.directory = file;
        this.checkValid();
    }

    private File fileOf(String string) {
        if (this.exists && this.directory.isDirectory()) {
            StringBuffer stringBuffer = new StringBuffer(this.directory.getPath());
            if (stringBuffer.charAt(stringBuffer.length() - 1) != File.separatorChar) {
                stringBuffer.append(File.separatorChar);
            }
            stringBuffer.append(ClassPath.fileNameOf(string));
            File file = new File(stringBuffer.toString());
            if (file.isFile()) {
                return file;
            }
        }
        return null;
    }

    private boolean isValid() {
        return this.exists;
    }

    private void checkValid() {
        this.exists = this.directory.isDirectory();
    }
}

