/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.meta;

import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataFatalError;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataUserException;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import java.io.PrintWriter;

public class JDOMetaDataModelImpl
extends Support
implements JDOMetaData {
    protected final PrintWriter out;
    protected Model model;

    public JDOMetaDataModelImpl(Model model) {
        this(model, null);
    }

    public JDOMetaDataModelImpl(Model model, PrintWriter printWriter) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        if (model == null) {
            throw new JDOMetaDataFatalError("Initializing meta data: model == null");
        }
        this.model = model;
        this.out = printWriter;
    }

    public boolean isTransientClass(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        if (string.startsWith("java/")) {
            return true;
        }
        if (string.startsWith("javax/")) {
            return true;
        }
        return string.startsWith("com/sun/jdo/");
    }

    public boolean isPersistenceCapableClass(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        if (this.isTransientClass(string)) {
            return false;
        }
        String string2 = JDOMetaDataModelImpl.pathToName(string);
        return this.model.isPersistent(string2);
    }

    public boolean isPersistenceCapableRootClass(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String string2 = JDOMetaDataModelImpl.pathToName(string);
        return this.model.isPersistent(string2);
    }

    public String getPersistenceCapableRootClass(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return this.isPersistenceCapableClass(string) ? string : null;
    }

    public String getSuperClass(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return null;
    }

    public boolean isSecondClassObjectType(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String string2 = JDOMetaDataModelImpl.pathToName(string);
        return this.model.isSecondClassObject(string2);
    }

    public boolean isMutableSecondClassObjectType(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String string2 = JDOMetaDataModelImpl.pathToName(string);
        return this.model.isMutableSecondClassObject(string2);
    }

    public boolean isPersistentField(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String string3 = JDOMetaDataModelImpl.pathToName(string);
        return this.model.isPersistent(string3, string2);
    }

    public boolean isTransactionalField(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return false;
    }

    public boolean isPrimaryKeyField(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String string3 = JDOMetaDataModelImpl.pathToName(string);
        return this.model.isKey(string3, string2);
    }

    public boolean isDefaultFetchGroupField(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String string3 = JDOMetaDataModelImpl.pathToName(string);
        return this.model.isDefaultFetchGroup(string3, string2);
    }

    public int getFieldNo(String string, String string2) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String string3 = JDOMetaDataModelImpl.pathToName(string);
        PersistenceFieldElement persistenceFieldElement = this.model.getPersistenceField(string3, string2);
        if (persistenceFieldElement == null || persistenceFieldElement.getPersistenceType() != 0) {
            return -1;
        }
        return persistenceFieldElement.getFieldNumber();
    }

    private final String[] getPersistentFields(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String string2 = JDOMetaDataModelImpl.pathToName(string);
        PersistenceClassElement persistenceClassElement = this.model.getPersistenceClass(string2);
        if (persistenceClassElement == null) {
            return new String[0];
        }
        PersistenceFieldElement[] persistenceFieldElementArray = persistenceClassElement.getFields();
        int n = persistenceFieldElementArray != null ? persistenceFieldElementArray.length : 0;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            PersistenceFieldElement persistenceFieldElement = persistenceFieldElementArray[n2];
            stringArray[n2] = persistenceFieldElement.getName();
            ++n2;
        }
        return stringArray;
    }

    public String[] getManagedFields(String string) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return this.getPersistentFields(string);
    }

    protected static String pathToName(String string) {
        if (string != null) {
            return string.replace('/', '.');
        }
        return null;
    }

    protected static String nameToPath(String string) {
        if (string != null) {
            return string.replace('.', '/');
        }
        return null;
    }
}

