/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class LocalVariable {
    private InsnTarget varStartPC;
    private InsnTarget varEndPC;
    private ConstUtf8 varName;
    private ConstUtf8 varSig;
    private int varSlot;

    public LocalVariable(InsnTarget insnTarget, InsnTarget insnTarget2, ConstUtf8 constUtf8, ConstUtf8 constUtf82, int n) {
        this.varStartPC = insnTarget;
        this.varEndPC = insnTarget2;
        this.varName = constUtf8;
        this.varSig = constUtf82;
        this.varSlot = n;
    }

    static LocalVariable read(DataInputStream dataInputStream, CodeEnv codeEnv) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        InsnTarget insnTarget = codeEnv.getTarget(n);
        int n2 = dataInputStream.readUnsignedShort();
        InsnTarget insnTarget2 = codeEnv.getTarget(n + n2);
        ConstUtf8 constUtf8 = (ConstUtf8)codeEnv.pool().constantAt(dataInputStream.readUnsignedShort());
        ConstUtf8 constUtf82 = (ConstUtf8)codeEnv.pool().constantAt(dataInputStream.readUnsignedShort());
        int n3 = dataInputStream.readUnsignedShort();
        return new LocalVariable(insnTarget, insnTarget2, constUtf8, constUtf82, n3);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.varStartPC.offset());
        dataOutputStream.writeShort(this.varEndPC.offset() - this.varStartPC.offset());
        dataOutputStream.writeShort(this.varName == null ? 0 : this.varName.getIndex());
        dataOutputStream.writeShort(this.varSig == null ? 0 : this.varSig.getIndex());
        dataOutputStream.writeShort(this.varSlot);
    }

    public void print(PrintStream printStream, int n) {
        ClassPrint.spaces(printStream, n);
        printStream.print("'" + (this.varName == null ? "(null)" : this.varName.asString()) + "'");
        printStream.print(" sig = " + (this.varSig == null ? "(null)" : this.varSig.asString()));
        printStream.print(" start_pc = " + Integer.toString(this.varStartPC.offset()));
        printStream.print(" length = " + Integer.toString(this.varEndPC.offset() - this.varStartPC.offset()));
        printStream.println(" slot = " + Integer.toString(this.varSlot));
    }
}

