/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.AnnotatedClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.AnnotatedMethodAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantValueAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ExceptionsAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.GenericAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.LineNumberTableAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.LocalVariableTableAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.SourceFileAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.SyntheticAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public abstract class ClassAttribute
implements VMConstants {
    private ConstUtf8 attributeName;

    public ConstUtf8 attrName() {
        return this.attributeName;
    }

    ClassAttribute(ConstUtf8 constUtf8) {
        this.attributeName = constUtf8;
    }

    static ClassAttribute read(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        ClassAttribute classAttribute = null;
        int n = dataInputStream.readUnsignedShort();
        ConstUtf8 constUtf8 = (ConstUtf8)constantPool.constantAt(n);
        String string = constUtf8.asString();
        int n2 = dataInputStream.readInt();
        if (string.equals("Code")) {
            classAttribute = CodeAttribute.read(constUtf8, n2, dataInputStream, constantPool);
        } else if (string.equals("SourceFile")) {
            classAttribute = SourceFileAttribute.read(constUtf8, dataInputStream, constantPool);
        } else if (string.equals("ConstantValue")) {
            classAttribute = ConstantValueAttribute.read(constUtf8, dataInputStream, constantPool);
        } else if (string.equals("Exceptions")) {
            classAttribute = ExceptionsAttribute.read(constUtf8, dataInputStream, constantPool);
        } else if (string.equals("filter.annotatedClass")) {
            classAttribute = AnnotatedClassAttribute.read(constUtf8, dataInputStream, constantPool);
        } else {
            byte[] byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            classAttribute = new GenericAttribute(constUtf8, byArray);
        }
        return classAttribute;
    }

    static ClassAttribute read(DataInputStream dataInputStream, CodeEnv codeEnv) throws IOException {
        ClassAttribute classAttribute = null;
        int n = dataInputStream.readUnsignedShort();
        ConstUtf8 constUtf8 = (ConstUtf8)codeEnv.pool().constantAt(n);
        String string = constUtf8.asString();
        int n2 = dataInputStream.readInt();
        if (string.equals("LineNumberTable")) {
            classAttribute = LineNumberTableAttribute.read(constUtf8, dataInputStream, codeEnv);
        } else if (string.equals("LocalVariableTable")) {
            classAttribute = LocalVariableTableAttribute.read(constUtf8, dataInputStream, codeEnv);
        } else if (string.equals("filter.annotatedMethod")) {
            classAttribute = AnnotatedMethodAttribute.read(constUtf8, dataInputStream, codeEnv);
        } else if (string.equals("Synthetic")) {
            classAttribute = SyntheticAttribute.read(constUtf8, dataInputStream, codeEnv.pool());
        } else {
            byte[] byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            classAttribute = new GenericAttribute(constUtf8, byArray);
        }
        return classAttribute;
    }

    abstract void write(DataOutputStream var1) throws IOException;

    abstract void print(PrintStream var1, int var2);
}

