/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.beans;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.servermodel.beans.AuthRealm;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.SecurityServiceComponentController;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.Serializable;
import javax.management.ObjectName;

public class SecurityServiceComponentBean
extends ServerComponent
implements Serializable {
    private transient SecurityServiceComponentController controller = new SecurityServiceComponentController(this);

    public SecurityServiceComponentBean(String identifier) {
        super(identifier);
    }

    public Controller getController() {
        return this.controller;
    }

    public void createAuthRealm(String name, String className) throws AFException {
        this.controller.createAuthRealm(name, className);
    }

    public void deleteAuthRealm(String name) throws AFException {
        this.controller.deleteAuthRealm(name);
    }

    public ServerModelIterator getAuthRealms() throws AFException {
        return this.controller.getAuthRealms();
    }

    public AuthRealm getAuthRealm(String realmName) {
        ArgChecker.checkValid(realmName, "realmName", StringValidator.getInstance());
        String instanceName = this.getInstanceName();
        ObjectName mbeanName = ObjectNames.getAuthRealmObjectName(instanceName, realmName);
        Assert.assertit(mbeanName != null, "null value returned");
        AuthRealm authRealm = new AuthRealm(mbeanName.toString(), realmName);
        authRealm.setContextHolder(this.getContextHolder());
        return authRealm;
    }

    public String getInstanceName() {
        String instanceName = null;
        try {
            String identifier = this.getIdentifier();
            ObjectName mbeanName = new ObjectName(identifier);
            instanceName = mbeanName.getKeyProperty("instance-name");
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return instanceName;
    }
}

