/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.ByteChunk;
import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.ParamInfo;
import com.iplanet.ias.admin.common.ServerInstanceStatus;
import com.iplanet.ias.admin.common.Status;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFResourceException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.ControlException;
import com.iplanet.ias.admin.common.exception.DeploymentException;
import com.iplanet.ias.admin.common.exception.InstanceAlreadyRunningException;
import com.iplanet.ias.admin.common.exception.InstanceNotRunningException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.beans.CustomResource;
import com.iplanet.ias.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedConnectorComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedEJBModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.JDBCConnectionPool;
import com.iplanet.ias.admin.servermodel.beans.JDBCResource;
import com.iplanet.ias.admin.servermodel.beans.JMSResource;
import com.iplanet.ias.admin.servermodel.beans.JNDIResource;
import com.iplanet.ias.admin.servermodel.beans.JavaMailResource;
import com.iplanet.ias.admin.servermodel.beans.LifeCycleModule;
import com.iplanet.ias.admin.servermodel.beans.PersistenceManagerFactoryResource;
import com.iplanet.ias.admin.servermodel.beans.ServiceComponentBean;
import com.iplanet.ias.admin.servermodel.context.AdminContext;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.ConfigurationController;
import com.iplanet.ias.admin.servermodel.controllers.DeploymentController;
import com.iplanet.ias.admin.servermodel.controllers.J2EEResourceController;
import com.iplanet.ias.admin.servermodel.controllers.LifeCycleController;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.SOMLocalStringsManager;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.Vector;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class AppServerInstanceController
implements LifeCycleController,
DeploymentController,
ConfigurationController,
J2EEResourceController {
    private static final String START_INSTANCE = "start";
    private static final String START_INSTANCE_DEBUG = "startInDebugMode";
    private static final String GET_SECURITY_PASSWORD_TOKENS = "getSecurityPasswordTokens";
    private static final String STOP_INSTANCE = "stop";
    private static final String RESTART_INSTANCE = "restart";
    private static final String GET_STATUS = "getStatus";
    private static final String UPLOAD_OPERATION = "uploadToServer";
    private static final String GET_STUB_FILE_LOCATION = "getClientStubJarLocation";
    private static final String PREPARE_DOWNLOAD = "prepareDownload";
    private static final String DOWNLOAD_FILE = "downloadFile";
    private static final String DEPLOY_APPLICATION = "deployJ2EEApplication";
    private static final String DEPLOY_APPLICATION_DIR = "deployJ2EEApplicationDirectory";
    private static final String UNDEPLOY_APPLICATION = "undeployJ2EEApplication";
    private static final String GET_DEPLOYED_APPS = "getDeployedJ2EEApplications";
    private static final String DEPLOY_EJB_MODULE = "deployEJBJarModule";
    private static final String DEPLOY_EJB_MODULE_DIR = "deployEJBJarModuleDirectory";
    private static final String DEPLOY_WAR_MODULE = "deployWarModule";
    private static final String DEPLOY_WAR_MODULE_DIR = "deployWarModuleDirectory";
    private static final String DEPLOY_RAR_MODULE = "deployConnectorModule";
    private static final String DEPLOY_RAR_MODULE_DIR = "deployConnectorModuleDirectory";
    private static final String UNDEPLOY_MODULE = "undeployModule";
    private static final String LIST_EJB_MODULES = "getDeployedEJBModules";
    private static final String LIST_WEB_MODULES = "getDeployedWebModules";
    private static final String LIST_CONNECTORS = "getDeployedConnectors";
    private static final String CREATE_RESOURCE = "createResource";
    private static final String CREATE_JDBC_RESOURCE = "createJDBCResource";
    private static final String DELETE_JDBC_RESOURCE = "deleteJDBCResource";
    private static final String LIST_JDBC_RESOURCES = "listJDBCResources";
    private static final String CREATE_MAIL_RESOURCE = "createJavaMailResource";
    private static final String DELETE_MAIL_RESOURCE = "deleteJavaMailResource";
    private static final String LIST_MAIL_RESOURCES = "listJavaMailResources";
    private static final String CREATE_JMS_RESOURCE = "createJMSResource";
    private static final String DELETE_JMS_RESOURCE = "deleteJMSResource";
    private static final String LIST_JMS_RESOURCES = "listJMSResources";
    private static final String CREATE_JNDI_RESOURCE = "createJNDIResource";
    private static final String DELETE_JNDI_RESOURCE = "deleteJNDIResource";
    private static final String LIST_JNDI_RESOURCES = "listJNDIResources";
    private static final String CREATE_CUSTOM_RESOURCE = "createCustomResource";
    private static final String DELETE_CUSTOM_RESOURCE = "deleteCustomResource";
    private static final String LIST_CUSTOM_RESOURCES = "listCustomResources";
    private static final String CREATE_PM_FACTORY_RESOURCE = "createPersistenceManagerFactoryResource";
    private static final String DELETE_PM_FACTORY_RESOURCE = "deletePersistenceManagerFactoryResource";
    private static final String LIST_PM_FACTORY_RESOURCES = "listPersistenceManagerFactoryResources";
    private static final String CREATE_JDBC_CONNECTION_POOL = "createJDBCConnectionPool";
    private static final String DELETE_JDBC_CONNECTION_POOL = "deleteJDBCConnectionPool";
    private static final String LIST_JDBC_CONNECTION_POOLS = "listJDBCConnectionPools";
    private static final String APPLY_XML_CHANGES = "applyConfigChanges";
    private static final String OVERWRITE_XML_CHANGES = "overwriteConfigChanges";
    private static final String USE_MANUAL_XML_CHANGES = "useManualConfigChanges";
    private static final String IS_APPLY_NEEDED = "isApplyNeeded";
    private static final String IS_RESTART_NEEDED = "isRestartNeeded";
    private static final String CREATE_LIFE_CYCLE_MODULE = "createLifeCycleModule";
    private static final String DELETE_LIFE_CYCLE_MODULE = "deleteLifeCycleModule";
    private static final String LIST_LIFE_CYCLE_MODULES = "listLifeCycleModules";
    private static final String GET_DEFAULT_ATTRIBUTE_VALUE = "getDefaultAttributeValue";
    private static final String LIST_CERT_NICKNAMES = "getCertNicknames";
    private static final String GET_INSTANCE_ROOT = "getInstanceRoot";
    private static final String GET_USERNAMES = "getUserNames";
    private static final String GET_GROUPNAMES = "getGroupNames";
    private static final String GET_USERGROUPNAMES = "getUserGroupNames";
    private static final String ADD_USER = "addUser";
    private static final String REMOVE_USER = "removeUser";
    private static final String UPDATE_USER = "updateUser";
    private AppServerInstance serverInstance;
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(class$com$iplanet$ias$admin$servermodel$controllers$AppServerInstanceController == null ? (class$com$iplanet$ias$admin$servermodel$controllers$AppServerInstanceController = AppServerInstanceController.class$("com.iplanet.ias.admin.servermodel.controllers.AppServerInstanceController")) : class$com$iplanet$ias$admin$servermodel$controllers$AppServerInstanceController);
    static /* synthetic */ Class class$com$iplanet$ias$admin$servermodel$controllers$AppServerInstanceController;

    public AppServerInstanceController(AppServerInstance appServerInstance) {
        this.serverInstance = appServerInstance;
    }

    public boolean start(Map map, int n) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean start() throws InstanceAlreadyRunningException, AFTargetNotFoundException, ControlException {
        try {
            this.invoke(START_INSTANCE, null, null);
        }
        catch (AFException aFException) {
            if (aFException instanceof ControlException) {
                throw (ControlException)aFException;
            }
            if (aFException instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)aFException;
            }
            throw new ControlException(aFException.toString());
        }
        return true;
    }

    public String[] getSecurityPasswordTokens() throws AFException {
        return (String[])this.invoke(GET_SECURITY_PASSWORD_TOKENS, null, null);
    }

    public boolean startSecure(String[] stringArray) throws InstanceAlreadyRunningException, AFTargetNotFoundException, ControlException {
        String[] stringArray2 = new String[]{"[Ljava.lang.String;"};
        Object[] objectArray = new Object[]{stringArray};
        try {
            this.invoke(START_INSTANCE, objectArray, stringArray2);
        }
        catch (AFException aFException) {
            if (aFException instanceof ControlException) {
                throw (ControlException)aFException;
            }
            if (aFException instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)aFException;
            }
            throw new ControlException(aFException.toString());
        }
        return true;
    }

    public int startSecureInDebugMode(String[] stringArray) throws AFTargetNotFoundException, ControlException {
        String[] stringArray2 = new String[]{"[Ljava.lang.String;"};
        Object[] objectArray = new Object[]{stringArray};
        int n = 0;
        try {
            Object object = this.invoke(START_INSTANCE_DEBUG, objectArray, stringArray2);
            n = (Integer)object;
        }
        catch (AFException aFException) {
            if (aFException instanceof ControlException) {
                throw (ControlException)aFException;
            }
            if (aFException instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)aFException;
            }
            throw new ControlException(aFException.toString());
        }
        return n;
    }

    public boolean startInDebugMode(Map map, int n) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public int startInDebugMode() throws AFTargetNotFoundException, ControlException {
        int n = 0;
        try {
            Object object = this.invoke(START_INSTANCE_DEBUG, null, null);
            n = (Integer)object;
        }
        catch (AFException aFException) {
            if (aFException instanceof ControlException) {
                throw (ControlException)aFException;
            }
            if (aFException instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)aFException;
            }
            throw new ControlException(aFException.toString());
        }
        return n;
    }

    public boolean restart(Map map, int n) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean restart() throws AFTargetNotFoundException, ControlException {
        try {
            ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
            ContextHolder contextHolder = this.serverInstance.getContextHolder();
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            sOMRequestDispatcher.invoke(objectName, RESTART_INSTANCE, null, null);
        }
        catch (AFException aFException) {
            if (aFException instanceof ControlException) {
                throw (ControlException)aFException;
            }
            if (aFException instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)aFException;
            }
            throw new ControlException(aFException.toString());
        }
        return true;
    }

    public boolean stop(Map map, int n) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean stop() throws AFTargetNotFoundException, InstanceNotRunningException, ControlException {
        try {
            ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
            String[] stringArray = new String[]{"int"};
            Object[] objectArray = new Object[]{new Integer(Integer.MAX_VALUE)};
            ContextHolder contextHolder = this.serverInstance.getContextHolder();
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            sOMRequestDispatcher.invoke(objectName, STOP_INSTANCE, objectArray, stringArray);
        }
        catch (AFException aFException) {
            if (aFException instanceof ControlException) {
                throw (ControlException)aFException;
            }
            if (aFException instanceof AFTargetNotFoundException) {
                throw (AFTargetNotFoundException)aFException;
            }
            Debug.printStackTrace(aFException);
            ExceptionUtil.ignoreException(aFException);
        }
        return true;
    }

    public boolean isRunning() throws AFException {
        boolean bl = false;
        Status status = this.getServerStatus();
        if (status.getStatusCode() == 0) {
            bl = true;
        }
        return bl;
    }

    public String getStatus() throws AFException {
        String string = null;
        Status status = this.getServerStatus();
        if (status != null) {
            string = status.getStatusString();
        }
        return string;
    }

    public String getDefaultModuleGroup() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public String getDefaultApplicationRoot() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getDeployedApplications() throws AFException {
        Vector<DeployedApplicationComponentBean> vector = new Vector<DeployedApplicationComponentBean>();
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        String[] stringArray = (String[])sOMRequestDispatcher.invoke(objectName, GET_DEPLOYED_APPS, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName2 = ObjectNames.getApplicationObjectName(this.serverInstance.getName(), stringArray[n]);
                DeployedApplicationComponentBean deployedApplicationComponentBean = new DeployedApplicationComponentBean(objectName2.toString(), stringArray[n]);
                deployedApplicationComponentBean.setContextHolder(contextHolder);
                vector.add(deployedApplicationComponentBean);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public ServerModelIterator getEnabledApplications() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getEnabledModules() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getDeployedModules() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getDeployedEJBModules() throws AFException {
        Vector<DeployedEJBModuleComponentBean> vector = new Vector<DeployedEJBModuleComponentBean>();
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        String[] stringArray = (String[])sOMRequestDispatcher.invoke(objectName, LIST_EJB_MODULES, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName2 = ObjectNames.getEjbModuleObjectName(this.serverInstance.getName(), stringArray[n]);
                DeployedEJBModuleComponentBean deployedEJBModuleComponentBean = new DeployedEJBModuleComponentBean(objectName2.toString(), stringArray[n], true);
                deployedEJBModuleComponentBean.setContextHolder(contextHolder);
                vector.add(deployedEJBModuleComponentBean);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public ServerModelIterator getDeployedWebModules() throws AFException {
        Vector<DeployedWebModuleComponentBean> vector = new Vector<DeployedWebModuleComponentBean>();
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        String[] stringArray = (String[])sOMRequestDispatcher.invoke(objectName, LIST_WEB_MODULES, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName2 = ObjectNames.getWebModuleObjectName(this.serverInstance.getName(), stringArray[n]);
                DeployedWebModuleComponentBean deployedWebModuleComponentBean = new DeployedWebModuleComponentBean(objectName2.toString(), stringArray[n], true);
                deployedWebModuleComponentBean.setContextHolder(contextHolder);
                vector.add(deployedWebModuleComponentBean);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public ServerModelIterator getDeployedConnectors() throws AFException {
        Vector<DeployedConnectorComponentBean> vector = new Vector<DeployedConnectorComponentBean>();
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        String[] stringArray = (String[])sOMRequestDispatcher.invoke(objectName, LIST_CONNECTORS, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName2 = ObjectNames.getConnectorModuleObjectName(this.serverInstance.getName(), stringArray[n]);
                Assert.assertit(objectName2 != null, "null value returned");
                DeployedConnectorComponentBean deployedConnectorComponentBean = new DeployedConnectorComponentBean(objectName2.toString(), stringArray[n], true);
                deployedConnectorComponentBean.setContextHolder(contextHolder);
                vector.add(deployedConnectorComponentBean);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public boolean deployModule(String string) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean deployModule(String string, String string2) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean deployEJBJarModule(String string, String string2) throws DeploymentException {
        boolean bl = true;
        return this.deployEJBJarModule(string, string2, true, false, bl);
    }

    public boolean redeployEJBJarModule(String string, String string2) throws DeploymentException {
        ArgChecker.checkValid(string, "filePath", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "moduleName", StringValidator.getInstance());
        boolean bl = true;
        return this.deployEJBJarModule(string, string2, true, false, bl);
    }

    public boolean deployEJBJarModule(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws DeploymentException {
        ArgChecker.checkValid(string, "filePath", StringValidator.getInstance());
        try {
            String string3 = bl3 ? this.doUpload(string, string2) : string;
            Assert.assertit(string3 != null, "null value returned");
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "boolean", "boolean"};
            Object[] objectArray = new Object[]{string3, string2, new Boolean(bl), new Boolean(bl2)};
            return this.doDeploy(DEPLOY_EJB_MODULE, stringArray, objectArray);
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            if (aFException instanceof DeploymentException) {
                throw (DeploymentException)aFException;
            }
            throw new DeploymentException(aFException.getLocalizedMessage());
        }
    }

    public boolean deployEJBJarModuleDirectory(String string, String string2, boolean bl, boolean bl2) throws DeploymentException {
        ArgChecker.checkValid(string, "moduleDir", StringValidator.getInstance());
        try {
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "boolean", "boolean"};
            Object[] objectArray = new Object[]{string, string2, new Boolean(bl), new Boolean(bl2)};
            return this.doDeploy(DEPLOY_EJB_MODULE_DIR, stringArray, objectArray);
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            if (aFException instanceof DeploymentException) {
                throw (DeploymentException)aFException;
            }
            throw new DeploymentException(aFException.getLocalizedMessage());
        }
    }

    public boolean deployWarModuleDirectory(String string, String string2, String string3, boolean bl, String string4, boolean bl2, boolean bl3, boolean bl4) throws DeploymentException {
        ArgChecker.checkValid(string, "moduleDir", StringValidator.getInstance());
        ArgChecker.checkValid(string3, "contextRoot");
        try {
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "boolean", "java.lang.String", "boolean", "boolean", "boolean"};
            Object[] objectArray = new Object[]{string, string2, string3, new Boolean(bl), string4, new Boolean(bl2), new Boolean(bl3), new Boolean(bl4)};
            return this.doDeploy(DEPLOY_WAR_MODULE_DIR, stringArray, objectArray);
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            if (aFException instanceof DeploymentException) {
                throw (DeploymentException)aFException;
            }
            throw new DeploymentException(aFException.getLocalizedMessage());
        }
    }

    public boolean redeployWarModule(String string, String string2, String string3) throws DeploymentException {
        ArgChecker.checkValid(string2, "webAppName", StringValidator.getInstance());
        boolean bl = true;
        return this.deployWarModule(string, string2, string3, true, null, true, false, false, bl);
    }

    public boolean deployWarModule(String string, String string2, String string3, boolean bl, String string4, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws DeploymentException {
        ArgChecker.checkValid(string, "filePath", StringValidator.getInstance());
        ArgChecker.checkValid(string3, "contextRoot");
        try {
            String string5 = bl5 ? this.doUpload(string, string2) : string;
            Assert.assertit(string5 != null, "null value returned");
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "boolean", "java.lang.String", "boolean", "boolean", "boolean"};
            Object[] objectArray = new Object[]{string5, string2, string3, new Boolean(bl), string4, new Boolean(bl2), new Boolean(bl3), new Boolean(bl4)};
            return this.doDeploy(DEPLOY_WAR_MODULE, stringArray, objectArray);
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            if (aFException instanceof DeploymentException) {
                throw (DeploymentException)aFException;
            }
            throw new DeploymentException(aFException.getLocalizedMessage());
        }
    }

    public boolean deployConnectorModule(String string, String string2) throws DeploymentException {
        boolean bl = true;
        return this.deployConnectorModule(string, string2, true, false, bl);
    }

    public boolean redeployConnectorModule(String string, String string2) throws DeploymentException {
        ArgChecker.checkValid(string2, "moduleName", StringValidator.getInstance());
        boolean bl = true;
        return this.deployConnectorModule(string, string2, true, false, bl);
    }

    public boolean deployConnectorModule(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws DeploymentException {
        ArgChecker.checkValid(string, "filePath", StringValidator.getInstance());
        try {
            String string3 = bl3 ? this.doUpload(string, string2) : string;
            Assert.assertit(string3 != null, "null value returned");
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "boolean", "boolean"};
            Object[] objectArray = new Object[]{string3, string2, new Boolean(bl), new Boolean(bl2)};
            return this.doDeploy(DEPLOY_RAR_MODULE, stringArray, objectArray);
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            if (aFException instanceof DeploymentException) {
                throw (DeploymentException)aFException;
            }
            throw new DeploymentException(aFException.getLocalizedMessage());
        }
    }

    public boolean deployConnectorModuleDirectory(String string, String string2, boolean bl, boolean bl2) throws DeploymentException {
        ArgChecker.checkValid(string, "moduleDir", StringValidator.getInstance());
        try {
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "boolean", "boolean"};
            Object[] objectArray = new Object[]{string, string2, new Boolean(bl), new Boolean(bl2)};
            return this.doDeploy(DEPLOY_RAR_MODULE_DIR, stringArray, objectArray);
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            if (aFException instanceof DeploymentException) {
                throw (DeploymentException)aFException;
            }
            throw new DeploymentException(aFException.getLocalizedMessage());
        }
    }

    public boolean deployModuleInApplication(File file, String string) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean deployModuleInApplication(File file, String string, String string2) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean deployModuleDirectory(String string, boolean bl) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean deployModuleDirectory(String string, String string2, boolean bl) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean deployApplication(String string, String string2, boolean bl, String string3, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws DeploymentException {
        ArgChecker.checkValid(string, "path", StringValidator.getInstance());
        try {
            String string4 = bl5 ? this.doUpload(string, string2) : string;
            Assert.assertit(string4 != null, "null value returned");
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "boolean", "java.lang.String", "boolean", "boolean", "boolean"};
            Object[] objectArray = new Object[]{string4, string2, new Boolean(bl), string3, new Boolean(bl2), new Boolean(bl3), new Boolean(bl4)};
            return this.doDeploy(DEPLOY_APPLICATION, stringArray, objectArray);
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            if (aFException instanceof DeploymentException) {
                throw (DeploymentException)aFException;
            }
            throw new DeploymentException(aFException.getLocalizedMessage());
        }
    }

    public boolean deployApplicationDirectory(String string, String string2, boolean bl, String string3, boolean bl2, boolean bl3, boolean bl4) throws DeploymentException {
        ArgChecker.checkValid(string, "applicationDir", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "boolean", "java.lang.String", "boolean", "boolean", "boolean"};
        Object[] objectArray = new Object[]{string, string2, new Boolean(bl), string3, new Boolean(bl2), new Boolean(bl3), new Boolean(bl4)};
        return this.doDeploy(DEPLOY_APPLICATION_DIR, stringArray, objectArray);
    }

    public boolean undeployModule(String string, int n) throws DeploymentException {
        ArgChecker.checkValid(string, "moduleName", StringValidator.getInstance());
        if (n != 1003 && n != 1002 && n != 1004) {
            throw new DeploymentException("Invalid module type");
        }
        try {
            String[] stringArray = new String[]{"java.lang.String", "int"};
            Object[] objectArray = new Object[]{string, new Integer(n)};
            boolean bl = this.doDeploy(UNDEPLOY_MODULE, stringArray, objectArray);
            Debug.println("undeployModule : undeployment successful");
            return bl;
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            if (aFException instanceof DeploymentException) {
                throw (DeploymentException)aFException;
            }
            throw new DeploymentException(aFException.getLocalizedMessage());
        }
    }

    public boolean undeployModule(String string, String string2) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean undeployModuleInApplication(String string, String string2) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean undeployApplication(String string) throws DeploymentException {
        try {
            ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
            ContextHolder contextHolder = this.serverInstance.getContextHolder();
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            String[] stringArray = new String[]{"java.lang.String"};
            Object[] objectArray = new Object[]{string};
            Object object = sOMRequestDispatcher.invoke(objectName, UNDEPLOY_APPLICATION, objectArray, stringArray);
            Assert.assertit(object != null, "null value returned");
            Debug.println("undeployApplication : undeployment successful");
            return (Boolean)object;
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            if (aFException instanceof DeploymentException) {
                throw (DeploymentException)aFException;
            }
            throw new DeploymentException(aFException.getLocalizedMessage());
        }
    }

    public boolean undeployApplication(String string, String string2) throws DeploymentException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean redeployApplication(String string, String string2) throws DeploymentException {
        ArgChecker.checkValid(string2, "applicationName", StringValidator.getInstance());
        boolean bl = true;
        return this.deployApplication(string, string2, true, null, true, false, false, bl);
    }

    public int getModuleType(String string) {
        int n = -1;
        try {
            ObjectName objectName = ObjectNames.getModuleObjectName(this.serverInstance.getName(), string);
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(this.serverInstance.getContextHolder());
            ParamInfo paramInfo = new ParamInfo("getModuleType", string);
            Object object = sOMRequestDispatcher.invoke(objectName, paramInfo.getOperationName(), paramInfo.getParams(), paramInfo.getSignature());
            n = (Integer)object;
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            ExceptionUtil.ignoreException(aFException);
        }
        return n;
    }

    public boolean reconfig() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, AccessViolationException, AFTargetNotFoundException {
        Object object = null;
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        Assert.assertit(objectName != null, "null value returned");
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        object = sOMRequestDispatcher.getAttribute(objectName, string);
        return object;
    }

    public AttributeList getAttributes(String[] stringArray) throws AFException {
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        Assert.assertit(objectName != null, "null value returned");
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        AttributeList attributeList = sOMRequestDispatcher.getAttributes(objectName, stringArray);
        return attributeList;
    }

    public void setAttribute(String string, Object object) throws AttributeNotFoundException, AccessViolationException, InvalidAttributeValueException, AFTargetNotFoundException {
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        Assert.assertit(objectName != null, "null value returned");
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        sOMRequestDispatcher.setAttribute(objectName, string, object);
    }

    public AttributeList setAttributes(AttributeList attributeList) throws AFException {
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        Assert.assertit(objectName != null, "null value returned");
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        AttributeList attributeList2 = sOMRequestDispatcher.setAttributes(objectName, attributeList);
        return attributeList2;
    }

    public Object getDefaultAttributeValue(String string) throws AFException {
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        Assert.assertit(objectName != null, "null value returned");
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        Object object = sOMRequestDispatcher.invoke(objectName, GET_DEFAULT_ATTRIBUTE_VALUE, objectArray, stringArray);
        return object;
    }

    public void retrieveApplication(String string, File file) throws IOException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void retrieveModule(String string, File file) throws IOException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public boolean isApplyNeeded() throws AFException {
        return this.isApplyNeeded(true);
    }

    public boolean isApplyNeeded(boolean bl) throws AFException {
        boolean bl2 = false;
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        String[] stringArray = new String[]{"boolean"};
        Object[] objectArray = new Object[]{new Boolean(bl)};
        Object object = sOMRequestDispatcher.invoke(objectName, IS_APPLY_NEEDED, objectArray, stringArray);
        bl2 = (Boolean)object;
        return bl2;
    }

    public boolean isRestartNeeded() throws AFException {
        boolean bl = false;
        Object object = this.invoke(IS_RESTART_NEEDED, null, null);
        Assert.assertit(object != null, "null value returned");
        bl = (Boolean)object;
        return bl;
    }

    public boolean applyChanges() throws AFException {
        boolean bl = false;
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        Object object = sOMRequestDispatcher.invoke(objectName, APPLY_XML_CHANGES, null, null);
        bl = (Boolean)object;
        Debug.println("AppServerInstanceController.applyChanges : requires restart = " + bl);
        return bl;
    }

    public boolean overwriteChanges() throws AFException {
        boolean bl = false;
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        Object object = sOMRequestDispatcher.invoke(objectName, OVERWRITE_XML_CHANGES, null, null);
        bl = (Boolean)object;
        Debug.println("AppServerInstanceController.useManualchanges : requires restart = " + bl);
        return bl;
    }

    public boolean useManualChanges() throws AFException {
        boolean bl = false;
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        Object object = sOMRequestDispatcher.invoke(objectName, USE_MANUAL_XML_CHANGES, null, null);
        bl = (Boolean)object;
        Debug.println("AppServerInstanceController.useManualchanges : requires restart = " + bl);
        return bl;
    }

    public void restoreConfig() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void backupConfig() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServiceComponentBean getWebContainer() {
        throw new UnsupportedOperationException("To be implemented");
    }

    public void createResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "xmlFile", StringValidator.getInstance());
        String string2 = null;
        try {
            string2 = this.doUpload(string, null);
        }
        catch (AFException aFException) {
            throw new AFResourceException(aFException.getLocalizedMessage());
        }
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string2};
        this.invokeResourceOperation(CREATE_RESOURCE, objectArray, stringArray);
    }

    public void createJDBCConnectionPool(String string, String string2) throws AFResourceException {
        ArgChecker.checkValid(string, "id", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "datasourceClassName", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2};
        this.invokeResourceOperation(CREATE_JDBC_CONNECTION_POOL, objectArray, stringArray);
    }

    public void deleteJDBCConnectionPool(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "poolName", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invokeResourceOperation(DELETE_JDBC_CONNECTION_POOL, objectArray, stringArray);
    }

    public JDBCConnectionPool getJDBCConnectionPool(String string) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getJDBCConnectionPools() throws AFException {
        Vector<JDBCConnectionPool> vector = new Vector<JDBCConnectionPool>();
        String[] stringArray = (String[])this.invokeResourceOperation(LIST_JDBC_CONNECTION_POOLS, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getJDBCConnectionPoolObjectName(this.serverInstance.getName(), stringArray[n]);
                JDBCConnectionPool jDBCConnectionPool = new JDBCConnectionPool(objectName.toString(), stringArray[n]);
                jDBCConnectionPool.setContextHolder(this.serverInstance.getContextHolder());
                vector.add(jDBCConnectionPool);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public void createJDBCResource(String string, String string2) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "poolName", StringValidator.getInstance());
        Debug.println("AppServerInstanceController.createJDBCResource: jndiName = " + string + "poolName = " + string2);
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2};
        this.invokeResourceOperation(CREATE_JDBC_RESOURCE, objectArray, stringArray);
    }

    public void deleteJDBCResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        Debug.println("AppServerInstanceController.deleteJDBCResource: jndiName = " + string);
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invokeResourceOperation(DELETE_JDBC_RESOURCE, objectArray, stringArray);
    }

    public JDBCResource getJDBCResource(String string) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getJDBCResources() throws AFException {
        Debug.println("AppServerInstanceController.listJDBCResources");
        Vector<JDBCResource> vector = new Vector<JDBCResource>();
        String[] stringArray = (String[])this.invokeResourceOperation(LIST_JDBC_RESOURCES, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getJDBCResourceObjectName(this.serverInstance.getName(), stringArray[n]);
                JDBCResource jDBCResource = new JDBCResource(objectName.toString(), stringArray[n]);
                jDBCResource.setContextHolder(this.serverInstance.getContextHolder());
                vector.add(jDBCResource);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public void createJMSResource(String string, String string2) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "resourceType", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2};
        this.invokeResourceOperation(CREATE_JMS_RESOURCE, objectArray, stringArray);
    }

    public void deleteJMSResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invokeResourceOperation(DELETE_JMS_RESOURCE, objectArray, stringArray);
    }

    public JMSResource getJMSResource(String string) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getJMSResources() throws AFException {
        Vector<JMSResource> vector = new Vector<JMSResource>();
        String[] stringArray = (String[])this.invokeResourceOperation(LIST_JMS_RESOURCES, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getJMSResourceObjectName(this.serverInstance.getName(), stringArray[n]);
                JMSResource jMSResource = new JMSResource(objectName.toString(), stringArray[n]);
                jMSResource.setContextHolder(this.serverInstance.getContextHolder());
                vector.add(jMSResource);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public ServerModelIterator getJMSDestResources() throws AFException {
        Vector<JMSResource> vector = new Vector<JMSResource>();
        String[] stringArray = (String[])this.invokeResourceOperation(LIST_JMS_RESOURCES, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getJMSResourceObjectName(this.serverInstance.getName(), stringArray[n]);
                JMSResource jMSResource = new JMSResource(objectName.toString(), stringArray[n]);
                jMSResource.setContextHolder(this.serverInstance.getContextHolder());
                String string = (String)jMSResource.getAttribute("resType");
                if (string.equals("javax.jms.Topic") || string.equals("javax.jms.Queue")) {
                    vector.add(jMSResource);
                }
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public ServerModelIterator getJMSConnResources() throws AFException {
        Vector<JMSResource> vector = new Vector<JMSResource>();
        String[] stringArray = (String[])this.invokeResourceOperation(LIST_JMS_RESOURCES, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getJMSResourceObjectName(this.serverInstance.getName(), stringArray[n]);
                JMSResource jMSResource = new JMSResource(objectName.toString(), stringArray[n]);
                jMSResource.setContextHolder(this.serverInstance.getContextHolder());
                String string = (String)jMSResource.getAttribute("resType");
                if (string.equals("javax.jms.TopicConnectionFactory") || string.equals("javax.jms.QueueConnectionFactory")) {
                    vector.add(jMSResource);
                }
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public void createJNDIResource(String string, String string2, String string3, String string4) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "jndiLookupName", StringValidator.getInstance());
        ArgChecker.checkValid(string3, "resourceType", StringValidator.getInstance());
        ArgChecker.checkValid(string4, "factoryClass", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        this.invokeResourceOperation(CREATE_JNDI_RESOURCE, objectArray, stringArray);
    }

    public void deleteJNDIResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invokeResourceOperation(DELETE_JNDI_RESOURCE, objectArray, stringArray);
    }

    public JNDIResource getJNDIResource(String string) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getJNDIResources() throws AFException {
        Vector<JNDIResource> vector = new Vector<JNDIResource>();
        String[] stringArray = (String[])this.invokeResourceOperation(LIST_JNDI_RESOURCES, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getJNDIResourceObjectName(this.serverInstance.getName(), stringArray[n]);
                JNDIResource jNDIResource = new JNDIResource(objectName.toString(), stringArray[n]);
                jNDIResource.setContextHolder(this.serverInstance.getContextHolder());
                vector.add(jNDIResource);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public void createJavaMailResource(String string, String string2, String string3, String string4) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "host", StringValidator.getInstance());
        ArgChecker.checkValid(string3, "user", StringValidator.getInstance());
        ArgChecker.checkValid(string4, "fromAddress", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2, string3, string4};
        this.invokeResourceOperation(CREATE_MAIL_RESOURCE, objectArray, stringArray);
    }

    public void deleteJavaMailResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invokeResourceOperation(DELETE_MAIL_RESOURCE, objectArray, stringArray);
    }

    public JavaMailResource getJavaMailResource(String string) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getJavaMailResources() throws AFException {
        Vector<JavaMailResource> vector = new Vector<JavaMailResource>();
        String[] stringArray = (String[])this.invokeResourceOperation(LIST_MAIL_RESOURCES, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getMailResourceObjectName(this.serverInstance.getName(), stringArray[n]);
                JavaMailResource javaMailResource = new JavaMailResource(objectName.toString(), stringArray[n]);
                javaMailResource.setContextHolder(this.serverInstance.getContextHolder());
                vector.add(javaMailResource);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public void createPersistenceManagerFactoryResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invokeResourceOperation(CREATE_PM_FACTORY_RESOURCE, objectArray, stringArray);
    }

    public void deletePersistenceManagerFactoryResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invokeResourceOperation(DELETE_PM_FACTORY_RESOURCE, objectArray, stringArray);
    }

    public PersistenceManagerFactoryResource getPersistenceManagerFactoryResource(String string) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getPersistenceManagerFactoryResources() throws AFException {
        Vector<PersistenceManagerFactoryResource> vector = new Vector<PersistenceManagerFactoryResource>();
        String[] stringArray = (String[])this.invokeResourceOperation(LIST_PM_FACTORY_RESOURCES, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getPersistenceManagerFactoryResourceObjectName(this.serverInstance.getName(), stringArray[n]);
                PersistenceManagerFactoryResource persistenceManagerFactoryResource = new PersistenceManagerFactoryResource(objectName.toString(), stringArray[n]);
                persistenceManagerFactoryResource.setContextHolder(this.serverInstance.getContextHolder());
                vector.add(persistenceManagerFactoryResource);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public void createCustomResource(String string, String string2, String string3) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "resourceType", StringValidator.getInstance());
        ArgChecker.checkValid(string3, "factoryClass", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2, string3};
        this.invokeResourceOperation(CREATE_CUSTOM_RESOURCE, objectArray, stringArray);
    }

    public void deleteCustomResource(String string) throws AFResourceException {
        ArgChecker.checkValid(string, "jndiName", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invokeResourceOperation(DELETE_CUSTOM_RESOURCE, objectArray, stringArray);
    }

    public CustomResource getCustomResource(String string) throws AFResourceException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerModelIterator getCustomResources() throws AFException {
        Vector<CustomResource> vector = new Vector<CustomResource>();
        String[] stringArray = (String[])this.invokeResourceOperation(LIST_CUSTOM_RESOURCES, null, null);
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getCustomResourceObjectName(this.serverInstance.getName(), stringArray[n]);
                CustomResource customResource = new CustomResource(objectName.toString(), stringArray[n]);
                customResource.setContextHolder(this.serverInstance.getContextHolder());
                vector.add(customResource);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    private String doUpload(String string, String string2) throws AFException {
        String string3 = null;
        string3 = this.isUploadRequired() ? this.uploadFile(string, string2) : string;
        return string3;
    }

    private String uploadFile(String string, String string2) throws AFException {
        String string3 = null;
        try {
            ObjectName objectName = ObjectNames.getControllerObjectName();
            ContextHolder contextHolder = this.serverInstance.getContextHolder();
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            File file = new File(string);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            String string4 = null;
            if (string2 != null && string2.length() > 0) {
                int n = string.lastIndexOf(".");
                if (n != -1) {
                    String string5 = string.substring(n);
                    string4 = string2 + string5;
                }
            } else {
                string4 = file.getName();
            }
            Debug.println("UploadFile : fileName = " + string4);
            byte[] byArray = new byte[65536];
            int n = 0;
            long l = 0L;
            boolean bl = true;
            boolean bl2 = false;
            long l2 = randomAccessFile.length();
            int n2 = 0;
            long l3 = System.currentTimeMillis();
            while ((n = randomAccessFile.read(byArray)) != -1) {
                Object object;
                l += (long)n;
                if (n < byArray.length) {
                    object = new byte[n];
                    int n3 = 0;
                    while (n3 < n) {
                        object[n3] = byArray[n3];
                        ++n3;
                    }
                    byArray = object;
                }
                if (l == l2) {
                    bl2 = true;
                }
                object = new ByteChunk(byArray, string4, bl, bl2);
                ((ByteChunk)object).setTargetDir(this.serverInstance.getName());
                ParamInfo paramInfo = new ParamInfo(UPLOAD_OPERATION, object);
                Object object2 = sOMRequestDispatcher.invoke(objectName, paramInfo.getOperationName(), paramInfo.getParams(), paramInfo.getSignature());
                string3 = (String)object2;
                Debug.println("DEBUG : Chunk[" + n2 + "] sent");
                ++n2;
                bl = false;
            }
            long l4 = System.currentTimeMillis();
            Debug.println("Time to transfer : " + (l4 - l3) + " ms");
            Debug.println("File transferred to " + string3);
        }
        catch (IOException iOException) {
            throw new AFException(iOException.getLocalizedMessage());
        }
        return string3;
    }

    private boolean doDeploy(String string, String[] stringArray, Object[] objectArray) throws DeploymentException {
        boolean bl = true;
        try {
            ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
            Debug.println("doDeploy : instance object name = " + objectName.toString());
            ContextHolder contextHolder = this.serverInstance.getContextHolder();
            SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
            Object object = sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
            Assert.assertit(object != null, "null value returned");
            Debug.println("doDeploy : deployment operation successful");
            bl = (Boolean)object;
        }
        catch (AFException aFException) {
            Debug.printStackTrace(aFException);
            if (aFException instanceof DeploymentException) {
                throw (DeploymentException)aFException;
            }
            throw new DeploymentException(aFException.getLocalizedMessage());
        }
        return bl;
    }

    public Status getServerStatus() throws AFException {
        ObjectName objectName = null;
        ServerInstanceStatus serverInstanceStatus = null;
        objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        Object object = sOMRequestDispatcher.invoke(objectName, GET_STATUS, null, null);
        serverInstanceStatus = (ServerInstanceStatus)object;
        Assert.assertit(serverInstanceStatus != null, "null value returned");
        return serverInstanceStatus;
    }

    private boolean isUploadRequired() {
        AdminContext adminContext = this.serverInstance.getContextHolder().getAdminContext();
        return !adminContext.isLocal();
    }

    private Object invokeResourceOperation(String string, Object[] objectArray, String[] stringArray) throws AFResourceException {
        Object object = null;
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        Assert.assertit(objectName != null, "null value returned");
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(this.serverInstance.getContextHolder());
        try {
            object = sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
        }
        catch (AFException aFException) {
            if (aFException instanceof AFResourceException) {
                throw (AFResourceException)aFException;
            }
            throw new AFResourceException(aFException.getLocalizedMessage());
        }
        return object;
    }

    public void createLifeCycleModule(String string, String string2) throws AFException {
        ArgChecker.checkValid(string, "name", StringValidator.getInstance());
        ArgChecker.checkValid(string2, "className", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
        Object[] objectArray = new Object[]{string, string2};
        this.invoke(CREATE_LIFE_CYCLE_MODULE, objectArray, stringArray);
    }

    public void removeLifeCycleModule(String string) throws AFException {
        ArgChecker.checkValid(string, "name", StringValidator.getInstance());
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        this.invoke(DELETE_LIFE_CYCLE_MODULE, objectArray, stringArray);
    }

    public ServerModelIterator getLifeCycleModules() throws AFException {
        String[] stringArray = (String[])this.invoke(LIST_LIFE_CYCLE_MODULES, null, null);
        Vector<LifeCycleModule> vector = new Vector<LifeCycleModule>();
        if (stringArray != null && stringArray.length > 0) {
            String string = this.serverInstance.getName();
            int n = 0;
            while (n < stringArray.length) {
                ObjectName objectName = ObjectNames.getLifeCycleModuleObjectName(string, stringArray[n]);
                Assert.assertit(objectName != null, "null value returned");
                Debug.println("AppServerInstanceController.getLifeCycleModules: mbeanName = " + objectName);
                LifeCycleModule lifeCycleModule = new LifeCycleModule(objectName.toString(), stringArray[n]);
                lifeCycleModule.setContextHolder(this.serverInstance.getContextHolder());
                vector.add(lifeCycleModule);
                ++n;
            }
        }
        return new ServerModelIterator(vector);
    }

    public String exportClientStubs(String string, int n, String string2) throws AFException {
        ArgChecker.checkValid(string, "appName", StringValidator.getInstance());
        if (n != 1001 && n != 1003) {
            String string3 = localizedStrMgr.getString("admin.servermodel.controller.invalid_app_type");
            throw new AFException(string3);
        }
        File file = new File(string2);
        if (!file.exists()) {
            String string4 = localizedStrMgr.getString("admin.servermodel.controller.desstdir_does_not_exist", string2);
            throw new AFException(string4);
        }
        if (!file.isDirectory()) {
            String string5 = localizedStrMgr.getString("admin.servermodel.controller.desstdir_is_not_directory", string2);
            throw new AFException(string5);
        }
        if (!file.canWrite()) {
            String string6 = localizedStrMgr.getString("admin.servermodel.controller.cannot_write_to_destdir", string2);
            throw new AFException(string6);
        }
        Object[] objectArray = new Object[]{string, new Integer(n)};
        String[] stringArray = new String[]{"java.lang.String", "int"};
        String string7 = (String)this.invoke(GET_STUB_FILE_LOCATION, objectArray, stringArray);
        String string8 = string + "Client.jar";
        this.downloadFile(string7, string2, string8);
        String string9 = new File(string2, string8).getAbsolutePath();
        return string9;
    }

    public String[] getCertNickNames() throws AFException {
        String[] stringArray = (String[])this.invoke(LIST_CERT_NICKNAMES, null, null);
        return stringArray;
    }

    public String getInstanceRoot() throws AFException {
        return (String)this.invoke(GET_INSTANCE_ROOT, null, null);
    }

    public String[] getUserNames() throws AFException {
        return (String[])this.invoke(GET_USERNAMES, null, null);
    }

    public String[] getGroupNames() throws AFException {
        return (String[])this.invoke(GET_GROUPNAMES, null, null);
    }

    public String[] getUserGroupNames(String string) throws AFException {
        Object[] objectArray = new Object[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        return (String[])this.invoke(GET_USERGROUPNAMES, objectArray, stringArray);
    }

    public void addUser(String string, String string2, String[] stringArray) throws AFException {
        Object[] objectArray = new Object[]{string, string2, stringArray};
        String[] stringArray2 = new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.String;"};
        this.invoke(ADD_USER, objectArray, stringArray2);
    }

    public void removeUser(String string) throws AFException {
        Object[] objectArray = new Object[]{string};
        String[] stringArray = new String[]{"java.lang.String"};
        this.invoke(REMOVE_USER, objectArray, stringArray);
    }

    public void updateUser(String string, String string2, String[] stringArray) throws AFException {
        Object[] objectArray = new Object[]{string, string2, stringArray};
        String[] stringArray2 = new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.String;"};
        this.invoke(UPDATE_USER, objectArray, stringArray2);
    }

    private Object invoke(String string, Object[] objectArray, String[] stringArray) throws AFException {
        ContextHolder contextHolder = this.serverInstance.getContextHolder();
        ObjectName objectName = ObjectNames.getServerInstanceObjectName(this.serverInstance.getName());
        SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(contextHolder);
        return sOMRequestDispatcher.invoke(objectName, string, objectArray, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void downloadFile(String string, String string2, String string3) throws AFException {
        File file = new File(string2);
        if (!file.exists()) {
            String string4 = localizedStrMgr.getString("admin.servermodel.controller.destinationdirpath_does_not_exist", string2);
            throw new AFException(string4);
        }
        FileOutputStream fileOutputStream = null;
        try {
            try {
                ObjectName objectName = ObjectNames.getControllerObjectName();
                SOMRequestDispatcher sOMRequestDispatcher = SOMRequestDispatcher.getDispatcher(this.serverInstance.getContextHolder());
                sOMRequestDispatcher.invoke(objectName, PREPARE_DOWNLOAD, new Object[]{string}, new String[]{"java.lang.String"});
                fileOutputStream = new FileOutputStream(new File(string2, string3));
                boolean bl = false;
                int n = 0;
                while (!bl) {
                    Object[] objectArray = new Object[]{new Integer(n)};
                    String[] stringArray = new String[]{"int"};
                    ByteChunk byteChunk = (ByteChunk)sOMRequestDispatcher.invoke(objectName, DOWNLOAD_FILE, objectArray, stringArray);
                    ++n;
                    bl = byteChunk.isLast();
                    byte[] byArray = byteChunk.getBytes();
                    fileOutputStream.write(byArray, 0, byArray.length);
                }
            }
            catch (IOException iOException) {
                throw new AFException(iOException.toString());
            }
            Object var15_16 = null;
            if (fileOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        fileOutputStream.close();
        return;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

