/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.forte.ejb.ejbRefs;

import com.iplanet.ias.tools.common.dd.EjbRef;
import com.iplanet.ias.tools.common.dd.ejb.Ejb;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.forte.LinkedPropertyManager;
import com.iplanet.ias.tools.forte.ejb.ejbRefs.ejbRefMap;
import com.iplanet.ias.tools.forte.util.BundleHelper;
import com.iplanet.ias.tools.forte.util.ui.JNDINameMappingModel;
import org.netbeans.modules.j2ee.server.datamodel.EjbStandardData;
import org.netbeans.modules.j2ee.server.datamodel.StandardData;

public class ejbRefMapModel
extends JNDINameMappingModel {
    public static final int JNDI_COLUMN = 1;
    public static final int REF_COLUMN = 0;
    private EjbStandardData.Ejb ejbJ2EE = null;
    private Ejb ejbNode = null;
    private String[] j2eeRefNames = null;
    private ejbRefMap[] maps = null;
    private int numRefs = 0;
    private String[] columnNames = new String[2];
    private LinkedPropertyManager refNameManager = new LinkedPropertyManager("EjbRefName");
    static /* synthetic */ Class class$java$lang$String;

    public ejbRefMapModel(Ejb n, EjbStandardData.Ejb e) {
        Reporter.assertIt((Object)n);
        Reporter.assertIt(e);
        this.ejbJ2EE = e;
        this.ejbNode = n;
        Reporter.info("EjbNode(" + ((Object)((Object)n)).hashCode() + ")  and EjbStandardData.Ejb(" + e.hashCode());
        this.columnNames[0] = BundleHelper.getString(this, "TTL_J2EEColumn");
        this.columnNames[1] = BundleHelper.getString(this, "TTL_JNDIColumn");
        this.load();
    }

    public String getColumnName(int c) {
        return this.columnNames[c];
    }

    public Class getColumnClass(int c) {
        return class$java$lang$String == null ? (class$java$lang$String = ejbRefMapModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.numRefs;
    }

    public Object getValueAt(int r, int c) {
        if (r > this.numRefs) {
            Reporter.crit("Internal Error: getValueAt() asked for row# " + r + " but only " + this.numRefs + " rows exist.");
            return null;
        }
        if (c != 0 && c != 1) {
            Reporter.crit("Internal Error: getValueAt() asked for column# " + c + " but only 2 exist.");
            return null;
        }
        if (c == 0) {
            return this.maps[r].getJ2EE();
        }
        return this.maps[r].getJNDI();
    }

    public void setValueAt(Object obj, int r, int c) {
        Reporter.info("Setting row# " + r + "'s JNDI Name to: " + obj);
        Reporter.assertIt(obj instanceof String);
        String s = (String)obj;
        if (r > this.numRefs) {
            Reporter.crit("Internal Error: setValueAt() asked for row# " + r + " but only " + this.numRefs + " rows exist.");
            return;
        }
        if (c != 0 && c != 1) {
            Reporter.crit("Internal Error: setValueAt() asked for column# " + c + " but only 2 exist.");
            return;
        }
        if (c == 0) {
            this.maps[r].setJ2EE(s);
        } else {
            this.maps[r].setJNDI(s);
        }
        Reporter.verbose("setValueAt(" + r + ", " + c + "): " + s);
    }

    public boolean isCellEditable(int r, int c) {
        return c == 1;
    }

    public Object saveData() {
        int num = this.howManyMaps();
        Reporter.info("Saving Ejb Reference Maps --- numMaps: " + num + ",  numRefs: " + this.numRefs);
        this.ejbNode.setEjbRef(null);
        EjbRef[] rrs = new EjbRef[num];
        int currentMap = 0;
        int i = 0;
        while (i < this.numRefs) {
            String jndi = this.maps[i].getJNDI();
            String j2ee = this.maps[i].getJ2EE();
            if (jndi.length() > 0) {
                EjbRef rr = new EjbRef();
                rr.setJndiName(jndi);
                rr.setEjbRefName(j2ee);
                rrs[currentMap++] = rr;
                this.refNameManager.joinWithSource(j2ee, (Object)rr, "EjbRefName");
            }
            ++i;
        }
        Reporter.assertIt(currentMap == num);
        Reporter.info("EjbNode(" + ((Object)((Object)this.ejbNode)).hashCode() + ")");
        this.ejbNode.setEjbRef(rrs);
        return this.ejbNode;
    }

    int howManyMaps() {
        int count = 0;
        int i = 0;
        while (i < this.numRefs) {
            if (this.maps[i].getJNDI().length() > 0) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private void load() {
        this.loadJ2EERefs();
        this.maps = new ejbRefMap[this.numRefs];
        int i = 0;
        while (i < this.numRefs) {
            this.maps[i] = new ejbRefMap(this.j2eeRefNames[i]);
            ++i;
        }
        this.loadExistingMaps();
    }

    private void loadJ2EERefs() {
        Reporter.assertIt(this.ejbJ2EE);
        this.numRefs = 0;
        EjbStandardData.EjbRefCategory rrc = this.ejbJ2EE.getEjbRefCategory();
        if (rrc == null) {
            Reporter.warn("No EjbStandardData.EjbRefCategory returned from ejbJ2EE");
            this.j2eeRefNames = new String[0];
            return;
        }
        EjbStandardData.EjbRef[] rr = rrc.getEjbRef();
        if (rr == null || rr.length <= 0) {
            this.j2eeRefNames = new String[0];
            return;
        }
        this.numRefs = rr.length;
        this.j2eeRefNames = new String[this.numRefs];
        int i = 0;
        while (i < this.numRefs) {
            this.j2eeRefNames[i] = rr[i].getEjbRefName();
            this.refNameManager.addNewSource(this.j2eeRefNames[i], (StandardData)rr[i]);
            ++i;
        }
    }

    private void loadExistingMaps() {
        EjbRef[] iasRefs = this.ejbNode.getEjbRef();
        int i = 0;
        while (i < iasRefs.length) {
            String jndi = iasRefs[i].getJndiName();
            String j2ee = iasRefs[i].getEjbRefName();
            Reporter.info(((Object)((Object)iasRefs[i])).hashCode() + " has name " + j2ee + " and " + jndi);
            this.refNameManager.joinWithSource(j2ee, (Object)iasRefs[i], "EjbRefName");
            int j = 0;
            while (j < this.numRefs) {
                if (j2ee.equals(this.maps[j].getJ2EE())) {
                    this.maps[j].setJNDI(jndi);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

