/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.common.EntityStatus;
import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFOtherException;
import com.iplanet.ias.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedEJBModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.servermodel.controllers.ComponentController;
import com.iplanet.ias.admin.servermodel.controllers.SOMRequestDispatcher;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import java.util.Vector;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DeployedApplicationComponentController
implements ComponentController {
    private static final String IS_ENABLED = "isEnabled";
    private static final String ENABLE_APPLICATION = "enable";
    private static final String DISABLE_APPLICATION = "disable";
    private static final String GET_STATUS = "getStatus";
    private static final String GET_ALL_MODULES = "getModules";
    private static final String GET_EJB_MODULES = "getEjbModules";
    private static final String GET_WEB_MODULES = "getWebModules";
    private DeployedApplicationComponentBean deployedApp;

    public DeployedApplicationComponentController(DeployedApplicationComponentBean appComponent) {
        this.deployedApp = appComponent;
    }

    public boolean isEnabled() throws AFException {
        EntityStatus status = this.getEntityStatus();
        return status.getStatusCode() == 4;
    }

    public boolean enable() throws AFException {
        this.invoke(ENABLE_APPLICATION, null, null);
        return true;
    }

    public boolean disable() throws AFException {
        this.invoke(DISABLE_APPLICATION, null, null);
        return true;
    }

    public String getStatus() throws AFException {
        EntityStatus status = this.getEntityStatus();
        String statusStr = status.getStatusString();
        return statusStr;
    }

    public ServerModelIterator getEJBModules() throws AFException {
        Vector<DeployedEJBModuleComponentBean> list = new Vector<DeployedEJBModuleComponentBean>();
        String[] modules = (String[])this.invoke(GET_EJB_MODULES, null, null);
        if (modules != null && modules.length > 0) {
            int i = 0;
            while (i < modules.length) {
                String appName;
                String instanceName = this.deployedApp.getInstanceName();
                ObjectName mbeanName = ObjectNames.getEjbModuleObjectName(instanceName, modules[i], appName = this.deployedApp.getAppName());
                Assert.assertit(mbeanName != null, "null value returned");
                Debug.println("DeployedApplicationComponentBean.getEjbModules: mbeanName = " + mbeanName);
                DeployedEJBModuleComponentBean module = new DeployedEJBModuleComponentBean(mbeanName.toString(), modules[i], false);
                module.setContextHolder(this.deployedApp.getContextHolder());
                list.add(module);
                ++i;
            }
        }
        return new ServerModelIterator(list);
    }

    public ServerModelIterator getWebModules() throws AFException {
        Vector<DeployedWebModuleComponentBean> list = new Vector<DeployedWebModuleComponentBean>();
        String[] modules = (String[])this.invoke(GET_WEB_MODULES, null, null);
        if (modules != null && modules.length > 0) {
            int i = 0;
            while (i < modules.length) {
                String appName;
                String instanceName = this.deployedApp.getInstanceName();
                ObjectName mbeanName = ObjectNames.getWebModuleObjectName(instanceName, modules[i], appName = this.deployedApp.getAppName());
                Assert.assertit(mbeanName != null, "null value returned");
                Debug.println("DeployedApplicationComponentBean.getWebModules: mbeanName = " + mbeanName);
                DeployedWebModuleComponentBean module = new DeployedWebModuleComponentBean(mbeanName.toString(), modules[i], false);
                module.setContextHolder(this.deployedApp.getContextHolder());
                list.add(module);
                ++i;
            }
        }
        return new ServerModelIterator(list);
    }

    public String[] getAllModules() throws AFException {
        String[] modules = (String[])this.invoke(GET_ALL_MODULES, null, null);
        return modules;
    }

    public ServerModelIterator getConnectorModules() throws AFException {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ServerComponent[] getSubComponents() {
        throw new UnsupportedOperationException("To be implemented");
    }

    private EntityStatus getEntityStatus() throws AFException {
        Object value = this.invoke(GET_STATUS, null, null);
        EntityStatus status = (EntityStatus)value;
        Assert.assertit(status != null, "null value returned");
        return status;
    }

    private Object invoke(String operationName, Object[] params, String[] signature) throws AFException {
        Object retValue = null;
        try {
            ObjectName mbeanName = new ObjectName(this.deployedApp.getIdentifier());
            ContextHolder ctxHolder = this.deployedApp.getContextHolder();
            SOMRequestDispatcher dispatcher = SOMRequestDispatcher.getDispatcher(ctxHolder);
            retValue = dispatcher.invoke(mbeanName, operationName, params, signature);
        }
        catch (MalformedObjectNameException mone) {
            throw new AFOtherException(mone);
        }
        return retValue;
    }
}

