/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.beans;

import com.iplanet.ias.admin.common.ObjectNames;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.beans.AuthDb;
import com.iplanet.ias.admin.servermodel.beans.DeployedApplicationComponentBean;
import com.iplanet.ias.admin.servermodel.beans.DeployedWebModuleComponentBean;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.servermodel.controllers.Controller;
import com.iplanet.ias.admin.servermodel.controllers.VirtualServerController;
import com.iplanet.ias.admin.servermodel.util.ServerModelIterator;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Assert;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.StringValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class VirtualServer
extends ServerComponent
implements Serializable {
    private transient VirtualServerController controller = new VirtualServerController(this);
    private static final String DELIMITER = ",";

    public VirtualServer(String identifier, String displayName) {
        super(identifier, displayName);
    }

    public Controller getController() {
        return this.controller;
    }

    public boolean isHttpQosCreated() throws AFException {
        return this.controller.isHttpQosCreated();
    }

    public void createHttpQos() throws AFException {
        this.controller.createHttpQos();
    }

    public void removeHttpQos() throws AFException {
        this.controller.removeHttpQos();
    }

    public void createAuthDb(String id, String database) throws AFException {
        this.controller.createAuthDb(id, database);
    }

    public void removeAuthDb(String id) throws AFException {
        this.controller.removeAuthDb(id);
    }

    public ServerModelIterator getAuthDbs() throws AFException {
        return this.controller.getAuthDbs();
    }

    public AuthDb getAuthDb(String id) {
        ArgChecker.checkValid(id, "id", StringValidator.getInstance());
        String instanceName = this.getInstanceName();
        String vsClassId = this.getVirtualServerClassId();
        String vsId = this.getVirtualServerId();
        ObjectName mbeanName = ObjectNames.getVirtualServerAuthDBObjectName(instanceName, vsClassId, vsId, id);
        Assert.assertit(mbeanName != null, "null value returned");
        Debug.println("VirtualServer.getAuthDb: mbeanName = " + mbeanName);
        AuthDb authDb = new AuthDb(mbeanName.toString(), id);
        authDb.setContextHolder(this.getContextHolder());
        return authDb;
    }

    public String getInstanceName() {
        String instanceName = null;
        try {
            String identifier = this.getIdentifier();
            ObjectName mbeanName = new ObjectName(identifier);
            instanceName = mbeanName.getKeyProperty("instance-name");
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return instanceName;
    }

    public String getVirtualServerClassId() {
        String classId = null;
        try {
            String identifier = this.getIdentifier();
            ObjectName mbeanName = new ObjectName(identifier);
            classId = mbeanName.getKeyProperty("virtual-server-class-id");
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return classId;
    }

    public String getVirtualServerId() {
        String virtualServerId = null;
        try {
            String identifier = this.getIdentifier();
            ObjectName mbeanName = new ObjectName(identifier);
            virtualServerId = mbeanName.getKeyProperty("name");
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            ExceptionUtil.ignoreException(e);
        }
        return virtualServerId;
    }

    public AttributeList setAttributes(AttributeList al) throws AttributeNotFoundException, AFException {
        AttributeList attrList = super.setAttributes(al);
        String defWM = (String)this.getAttribute("defaultWebModule");
        int idx = defWM.indexOf(":");
        if (idx == -1) {
            this.updateWebModule(defWM);
        } else if (idx > 0) {
            String appName = defWM.substring(0, idx);
            this.updateJ2EEApplication(appName);
        }
        return attrList;
    }

    public void setAttribute(String attributeName, Object value) throws AttributeNotFoundException, InvalidAttributeValueException, AccessViolationException, AFTargetNotFoundException {
        if (attributeName.equals("defaultWebModule") && !((String)value).equals(this.getAttribute("defaultWebModule"))) {
            this.updateWebModule((String)value);
        }
        super.setAttribute(attributeName, value);
    }

    private void updateWebModule(String defaultWebModule) throws AttributeNotFoundException, InvalidAttributeValueException, AccessViolationException, AFTargetNotFoundException {
        String vsStr;
        String[] vsArr;
        DeployedWebModuleComponentBean webModule;
        boolean isVSIncluded = false;
        String vsId = this.getVirtualServerId();
        if (defaultWebModule != null && !defaultWebModule.equals("") && (webModule = this.getWebModule(defaultWebModule)) != null && (vsArr = this.getArrayFromCommaSeparatedList(vsStr = (String)webModule.getAttribute("virtualServers"))) != null && vsArr.length > 0) {
            int i = 0;
            while (i < vsArr.length) {
                if (vsArr[i].equals(vsId)) {
                    isVSIncluded = true;
                }
                ++i;
            }
            if (!isVSIncluded) {
                String newVSStr = this.getVirtualServerId() + DELIMITER + vsStr;
                webModule.setAttribute("virtualServers", newVSStr);
            }
        }
    }

    private DeployedWebModuleComponentBean getWebModule(String moduleName) {
        ArgChecker.checkValid(moduleName, "moduleName", StringValidator.getInstance());
        ObjectName identifier = ObjectNames.getWebModuleObjectName(this.getInstanceName(), moduleName);
        Assert.assertit(identifier != null, "null value returned");
        DeployedWebModuleComponentBean module = new DeployedWebModuleComponentBean(identifier.toString(), moduleName, true);
        module.setContextHolder(this.getContextHolder());
        return module;
    }

    private void updateJ2EEApplication(String defaultApp) throws AttributeNotFoundException, InvalidAttributeValueException, AccessViolationException, AFTargetNotFoundException {
        String vsStr;
        String[] vsArr;
        DeployedApplicationComponentBean j2eeApp;
        boolean isVSIncluded = false;
        String vsId = this.getVirtualServerId();
        if (defaultApp != null && !defaultApp.equals("") && (j2eeApp = this.getJ2EEApplication(defaultApp)) != null && (vsArr = this.getArrayFromCommaSeparatedList(vsStr = (String)j2eeApp.getAttribute("virtualServers"))) != null && vsArr.length > 0) {
            int i = 0;
            while (i < vsArr.length) {
                if (vsArr[i].equals(vsId)) {
                    isVSIncluded = true;
                }
                ++i;
            }
            if (!isVSIncluded) {
                String newVSStr = this.getVirtualServerId() + DELIMITER + vsStr;
                j2eeApp.setAttribute("virtualServers", newVSStr);
            }
        }
    }

    private DeployedApplicationComponentBean getJ2EEApplication(String appName) {
        ArgChecker.checkValid(appName, "moduleName", StringValidator.getInstance());
        ObjectName identifier = ObjectNames.getApplicationObjectName(this.getInstanceName(), appName);
        Assert.assertit(identifier != null, "null value returned");
        DeployedApplicationComponentBean deplApp = new DeployedApplicationComponentBean(identifier.toString(), appName);
        deplApp.setContextHolder(this.getContextHolder());
        return deplApp;
    }

    private String[] getArrayFromCommaSeparatedList(String listStr) {
        ArrayList<String> lst = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(listStr, DELIMITER);
        while (st.hasMoreTokens()) {
            lst.add(st.nextToken());
        }
        String[] resultArr = lst.toArray(new String[lst.size()]);
        return resultArr;
    }
}

