/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.impl;

import com.sun.jdo.api.persistence.support.ConnectionFactory;
import com.sun.jdo.api.persistence.support.JDOException;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.JDOUnsupportedOptionException;
import com.sun.jdo.api.persistence.support.JDOUserException;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperPersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceStore;
import com.sun.jdo.spi.persistence.support.sqlstore.SQLStoreManager;
import com.sun.jdo.spi.persistence.support.sqlstore.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerImpl;
import com.sun.jdo.spi.persistence.support.sqlstore.impl.PersistenceManagerWrapper;
import com.sun.jdo.spi.persistence.utility.BucketizedHashtable;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.sql.DataSource;

public class SQLPersistenceManagerFactory
implements PersistenceManagerFactory {
    private PersistenceStore _store = null;
    private ConnectionFactory _connectionFactory = null;
    private Object _dataSource = null;
    private com.sun.jdo.api.persistence.support.PersistenceManagerFactory _persistenceManagerFactory = null;
    private Properties _properties = null;
    private boolean optimistic = true;
    private boolean retainValues = true;
    private boolean nontransactionalRead = true;
    private boolean ignoreCache = true;
    private int queryTimeout = 0;
    private int updateTimeout = 0;
    private int minPool = 0;
    private int maxPool = 0;
    private static Logger logger = LogHelperPersistenceManager.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle("com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (class$com$sun$jdo$spi$persistence$support$sqlstore$impl$SQLPersistenceManagerFactory == null ? (class$com$sun$jdo$spi$persistence$support$sqlstore$impl$SQLPersistenceManagerFactory = SQLPersistenceManagerFactory.class$("com.sun.jdo.spi.persistence.support.sqlstore.impl.SQLPersistenceManagerFactory")) : class$com$sun$jdo$spi$persistence$support$sqlstore$impl$SQLPersistenceManagerFactory).getClassLoader());
    private static int pmCacheBucketSize = Integer.getInteger("com.sun.jdo.spi.persistence.support.sqlstore.impl.SQLPersistenceManagerFactory.pmCacheBucketSize", 11);
    private static int pmCacheInitialCapacity = Integer.getInteger("com.sun.jdo.spi.persistence.support.sqlstore.impl.SQLPersistenceManagerFactory.pmCacheInitialCapacity", 11 * pmCacheBucketSize);
    private Map pmCache = new BucketizedHashtable(pmCacheBucketSize, pmCacheInitialCapacity);
    static /* synthetic */ Class class$com$sun$jdo$spi$persistence$support$sqlstore$impl$SQLPersistenceManagerFactory;

    public SQLPersistenceManagerFactory() {
    }

    public SQLPersistenceManagerFactory(Object object) {
        if (object instanceof ConnectionFactory) {
            this._connectionFactory = (ConnectionFactory)object;
        } else {
            this._dataSource = object;
        }
        if (this instanceof com.sun.jdo.api.persistence.support.PersistenceManagerFactory) {
            this._persistenceManagerFactory = this;
        }
        this.initialize();
    }

    public SQLPersistenceManagerFactory(com.sun.jdo.api.persistence.support.PersistenceManagerFactory persistenceManagerFactory) {
        this._persistenceManagerFactory = persistenceManagerFactory;
        Object object = this._persistenceManagerFactory.getConnectionFactory();
        if (object instanceof ConnectionFactory) {
            this._connectionFactory = (ConnectionFactory)object;
        } else {
            this._dataSource = object;
        }
        this.initialize();
    }

    public void setConnectionUserName(String string) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public String getConnectionUserName() {
        return this._persistenceManagerFactory.getConnectionUserName();
    }

    public void setConnectionPassword(String string) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public void setConnectionURL(String string) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public String getConnectionURL() {
        return this._persistenceManagerFactory.getConnectionURL();
    }

    public void setConnectionDriverName(String string) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public String getConnectionDriverName() {
        return this._persistenceManagerFactory.getConnectionDriverName();
    }

    public void setConnectionFactory(Object object) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public Object getConnectionFactory() {
        if (this._dataSource != null) {
            return this._dataSource;
        }
        return this._connectionFactory;
    }

    public void setOptimistic(boolean bl) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public boolean getOptimistic() {
        return this._persistenceManagerFactory.getOptimistic();
    }

    public void setRetainValues(boolean bl) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public boolean getRetainValues() {
        return this._persistenceManagerFactory.getRetainValues();
    }

    public void setNontransactionalRead(boolean bl) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public boolean getNontransactionalRead() {
        return this._persistenceManagerFactory.getNontransactionalRead();
    }

    public void setIgnoreCache(boolean bl) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public boolean getIgnoreCache() {
        return this._persistenceManagerFactory.getIgnoreCache();
    }

    public void setQueryTimeout(int n) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getQueryTimeout() {
        return this._persistenceManagerFactory.getQueryTimeout();
    }

    public void setConnectionMaxPool(int n) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getConnectionMaxPool() {
        return this._persistenceManagerFactory.getConnectionMaxPool();
    }

    public void setConnectionMinPool(int n) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getConnectionMinPool() {
        return this._persistenceManagerFactory.getConnectionMinPool();
    }

    public void setConnectionMsWait(int n) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getConnectionMsWait() {
        return this._persistenceManagerFactory.getConnectionMsWait();
    }

    public void setConnectionMsInterval(int n) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getConnectionMsInterval() {
        return this._persistenceManagerFactory.getConnectionMsInterval();
    }

    public void setConnectionLoginTimeout(int n) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getConnectionLoginTimeout() {
        return this._persistenceManagerFactory.getConnectionLoginTimeout();
    }

    public void setConnectionLogWriter(PrintWriter printWriter) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public PrintWriter getConnectionLogWriter() {
        return this._persistenceManagerFactory.getConnectionLogWriter();
    }

    public void setConnectionTransactionIsolation(int n) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getConnectionTransactionIsolation() {
        return this._persistenceManagerFactory.getConnectionTransactionIsolation();
    }

    public void setConnectionFactoryName(String string) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public String getConnectionFactoryName() {
        return this._persistenceManagerFactory.getConnectionFactoryName();
    }

    public int getMaxPool() {
        return this.maxPool;
    }

    public void setMaxPool(int n) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getMinPool() {
        return this.minPool;
    }

    public void setMinPool(int n) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public void setUpdateTimeout(int n) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public int getUpdateTimeout() {
        return this._persistenceManagerFactory.getUpdateTimeout();
    }

    public boolean getSupersedeDeletedInstance() {
        return this._persistenceManagerFactory.getSupersedeDeletedInstance();
    }

    public void setSupersedeDeletedInstance(boolean bl) {
        throw new JDOUnsupportedOptionException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.notsupported"));
    }

    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(null, null);
    }

    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManager(String string, String string2) {
        Object object;
        boolean bl = logger.isLoggable(300);
        if (this._connectionFactory == null && this._dataSource == null) {
            throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.getpersistencemanager.notconfigured"));
        }
        if (bl) {
            logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr", Thread.currentThread());
        }
        PersistenceManagerImpl persistenceManagerImpl = null;
        javax.transaction.Transaction transaction = EJBHelper.getTransaction();
        if (transaction != null) {
            if (bl) {
                object = new Object[]{Thread.currentThread(), transaction};
                logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.found", (Object[])object);
            }
            if ((persistenceManagerImpl = (PersistenceManagerImpl)this.pmCache.get(transaction)) == null) {
                persistenceManagerImpl = this.getFromPool(transaction, string, string2);
                this.pmCache.put(transaction, persistenceManagerImpl);
            } else if (persistenceManagerImpl.isClosed()) {
                if (bl) {
                    object = new Object[]{Thread.currentThread(), transaction};
                    logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.pmclosedfor", (Object[])object);
                }
                throw new JDOFatalInternalException("PersistenceManager for this javax.transaction.Transaction " + transaction + " is already closed or committing");
            }
            object = (Transaction)persistenceManagerImpl.currentTransaction();
            if (bl) {
                logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.jdotx", object);
            }
            if (!object.isActive()) {
                object.begin(transaction);
            }
            if (!persistenceManagerImpl.verify(string, string2)) {
                throw new JDOUserException(I18NHelper.getMessage(messages, "jdo.persistencemanagerfactoryimpl.getpersistencemanager.error"));
            }
        } else {
            if (bl) {
                logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.jdotx.notfound");
            }
            persistenceManagerImpl = this.getFromPool(null, string, string2);
        }
        if (bl) {
            object = new Object[]{Thread.currentThread(), persistenceManagerImpl, transaction};
            logger.finest("sqlstore.sqlpersistencemgrfactory.getpersistencemgr.pmt", (Object[])object);
        }
        return new PersistenceManagerWrapper(persistenceManagerImpl);
    }

    public Properties getProperties() {
        return this._persistenceManagerFactory.getProperties();
    }

    public com.sun.jdo.api.persistence.support.PersistenceManagerFactory getPersistenceManagerFactory() {
        return this._persistenceManagerFactory;
    }

    public void registerPersistenceManager(PersistenceManager persistenceManager, javax.transaction.Transaction transaction) {
        Object[] objectArray;
        boolean bl = logger.isLoggable(300);
        if (bl) {
            objectArray = new Object[]{persistenceManager, transaction};
            logger.finest("sqlstore.sqlpersistencemgrfactory.registerpersistencemgr.pmt", objectArray);
        }
        if ((objectArray = (Object[])this.pmCache.get(transaction)) == null) {
            this.pmCache.put(transaction, persistenceManager);
            ((PersistenceManagerImpl)persistenceManager).setJTATransaction(transaction);
            return;
        }
        if (objectArray != persistenceManager) {
            throw new JDOFatalInternalException("This instance of javax.transaction.Transaction is already registered with another PersistenceManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceManagerImpl getFromPool(javax.transaction.Transaction transaction, String string, String string2) {
        boolean bl = logger.isLoggable(300);
        if (bl) {
            logger.finest("sqlstore.sqlpersistencemgrfactory.getfrompool");
        }
        SQLPersistenceManagerFactory sQLPersistenceManagerFactory = this;
        synchronized (sQLPersistenceManagerFactory) {
            if (this._store == null) {
                this._store = new SQLStoreManager(this.getDBName(string, string2));
            }
        }
        PersistenceManagerImpl persistenceManagerImpl = new PersistenceManagerImpl(this, transaction, string, string2);
        persistenceManagerImpl.setStore(this._store);
        if (bl) {
            Object[] objectArray = new Object[]{persistenceManagerImpl, transaction};
            logger.finest("sqlstore.sqlpersistencemgrfactory.getfrompool.pmt", objectArray);
        }
        return persistenceManagerImpl;
    }

    private void returnToPool(com.sun.jdo.api.persistence.support.PersistenceManager persistenceManager) {
        logger.finest("sqlstore.sqlpersistencemgrfactory.returnToPool");
    }

    public void releasePersistenceManager(PersistenceManager persistenceManager, javax.transaction.Transaction transaction) {
        Object[] objectArray;
        boolean bl = logger.isLoggable(300);
        if (bl) {
            objectArray = new Object[]{persistenceManager, transaction};
            logger.finest("sqlstore.sqlpersistencemgrfactory.releasepm.pmt", objectArray);
        }
        if (transaction != null) {
            objectArray = (Object[])this.pmCache.get(transaction);
            if (objectArray == null || objectArray != persistenceManager) {
                throw new JDOFatalInternalException("This instance of javax.transaction.Transaction is registered with another PersistenceManager");
            }
            this.pmCache.remove(transaction);
        } else {
            this.returnToPool(persistenceManager);
        }
    }

    private void initialize() {
        logger.finest("sqlstore.sqlpersistencemgrfactory.init");
        this.optimistic = this._persistenceManagerFactory.getOptimistic();
        this.retainValues = this._persistenceManagerFactory.getRetainValues();
        this.nontransactionalRead = this._persistenceManagerFactory.getNontransactionalRead();
        this.ignoreCache = this._persistenceManagerFactory.getIgnoreCache();
        this.queryTimeout = this._persistenceManagerFactory.getQueryTimeout();
        this.updateTimeout = this._persistenceManagerFactory.getUpdateTimeout();
        this.minPool = this._persistenceManagerFactory.getMinPool();
        this.maxPool = this._persistenceManagerFactory.getMaxPool();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDBName(String string, String string2) {
        String string3;
        block9: {
            string3 = null;
            Connection connection = null;
            try {
                try {
                    connection = this._connectionFactory != null ? this._connectionFactory.getConnection() : (EJBHelper.isManaged() ? EJBHelper.getConnection(this._dataSource, string, string2) : (string == null ? ((DataSource)this._dataSource).getConnection() : ((DataSource)this._dataSource).getConnection(string, string2)));
                    string3 = connection.getMetaData().getDatabaseProductName();
                    if (!EJBHelper.isManaged()) {
                        connection.commit();
                    }
                }
                catch (Exception exception) {
                    if (logger.isLoggable(900)) {
                        logger.log(900, "jdo.sqlpersistencemanagerfactory.getdbname.error", exception);
                    }
                    if (!(exception instanceof JDOException)) throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "core.configuration.getvendortypefailed"), exception);
                    throw (JDOException)exception;
                }
                Object var7_5 = null;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (connection == null) throw throwable;
                try {
                    connection.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            connection.close();
        }
        if (!logger.isLoggable()) return string3;
        logger.fine("sqlstore.sqlpersistencemgrfactory.dbname", string3);
        return string3;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SQLPersistenceManagerFactory) {
            SQLPersistenceManagerFactory sQLPersistenceManagerFactory = (SQLPersistenceManagerFactory)object;
            return sQLPersistenceManagerFactory._persistenceManagerFactory.equals(this._persistenceManagerFactory);
        }
        return false;
    }

    public int hashCode() {
        return this._persistenceManagerFactory.hashCode();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (logger.isLoggable(300)) {
            logger.finest("sqlstore.sqlpersistencemgrfactory.pmCacheBucketSize", String.valueOf(pmCacheBucketSize));
            logger.finest("sqlstore.sqlpersistencemgrfactory.pmCacheInitialCapacity", String.valueOf(pmCacheInitialCapacity));
        }
    }
}

