/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.ConcurrencyGroupElement;
import com.sun.jdo.api.persistence.model.jdo.FieldElementHolder;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import java.util.ArrayList;

public class PersistenceClassElement
extends PersistenceElement
implements FieldElementHolder {
    public static final int APPLICATION_IDENTITY = 0;
    public static final int DATABASE_IDENTITY = 1;
    public static final int UNMANAGED_IDENTITY = 2;

    public PersistenceClassElement() {
        this(null);
    }

    public PersistenceClassElement(Impl impl) {
        super(impl);
    }

    public static PersistenceClassElement forName(String string, Model model) {
        return model.getPersistenceClass(string);
    }

    final Impl getClassImpl() {
        return (Impl)this.getImpl();
    }

    public String getPackage() {
        String string = this.getName();
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(0, n) : "";
    }

    public boolean isModified() {
        return this.getClassImpl().isModified();
    }

    public void setModified(boolean bl) {
        this.getClassImpl().setModified(bl);
    }

    public int getObjectIdentityType() {
        return this.getClassImpl().getObjectIdentityType();
    }

    public void setObjectIdentityType(int n) throws ModelException {
        this.getClassImpl().setObjectIdentityType(n);
    }

    public String getKeyClass() {
        return this.getClassImpl().getKeyClass();
    }

    public void setKeyClass(String string) throws ModelException {
        boolean bl;
        boolean bl2 = bl = string != null;
        if (bl) {
            string = string.trim();
        }
        if (bl && string.length() > 0) {
            String string2;
            String string3 = this.getName();
            boolean bl3 = string.startsWith(string3);
            String string4 = string2 = bl3 ? string.substring(string3.length()) : string;
            if (!bl3 || !string2.equalsIgnoreCase("Key") && !string2.equalsIgnoreCase(".OID") && !string2.equalsIgnoreCase("$OID")) {
                throw new ModelException(I18NHelper.getMessage(PersistenceElement.getMessages(), "jdo.class.key_class_invalid", new Object[]{string, string3}));
            }
        }
        this.getClassImpl().setKeyClass(string);
    }

    public void setName(String string) throws ModelException {
        String string2;
        String string3 = this.getName();
        super.setName(string);
        if (!StringHelper.isEmpty(string) && (string2 = this.getKeyClass()) != null && string2.startsWith(string3)) {
            this.setKeyClass(string + string2.substring(string3.length()));
        }
    }

    public void addField(PersistenceFieldElement persistenceFieldElement) throws ModelException {
        this.addFields(new PersistenceFieldElement[]{persistenceFieldElement});
    }

    public void addFields(PersistenceFieldElement[] persistenceFieldElementArray) throws ModelException {
        this.getClassImpl().changeFields(persistenceFieldElementArray, 1);
    }

    public void removeField(PersistenceFieldElement persistenceFieldElement) throws ModelException {
        this.removeFields(new PersistenceFieldElement[]{persistenceFieldElement});
    }

    public void removeFields(PersistenceFieldElement[] persistenceFieldElementArray) throws ModelException {
        int n = persistenceFieldElementArray != null ? persistenceFieldElementArray.length : 0;
        this.getClassImpl().changeFields(persistenceFieldElementArray, -1);
        int n2 = 0;
        while (n2 < n) {
            PersistenceFieldElement persistenceFieldElement = persistenceFieldElementArray[n2];
            ConcurrencyGroupElement[] concurrencyGroupElementArray = persistenceFieldElement.getConcurrencyGroups();
            int n3 = concurrencyGroupElementArray != null ? concurrencyGroupElementArray.length : 0;
            int n4 = 0;
            while (n4 < n3) {
                concurrencyGroupElementArray[n4].removeField(persistenceFieldElement);
                ++n4;
            }
            ++n2;
        }
    }

    public PersistenceFieldElement[] getFields() {
        return this.getClassImpl().getFields();
    }

    public void setFields(PersistenceFieldElement[] persistenceFieldElementArray) throws ModelException {
        this.getClassImpl().changeFields(persistenceFieldElementArray, 0);
    }

    public PersistenceFieldElement getField(String string) {
        return this.getClassImpl().getField(string);
    }

    public boolean containsField(PersistenceFieldElement persistenceFieldElement) {
        return this.getClassImpl().getField(persistenceFieldElement.getName()) != null;
    }

    public RelationshipElement[] getRelationships() {
        PersistenceFieldElement[] persistenceFieldElementArray = this.getFields();
        int n = persistenceFieldElementArray != null ? persistenceFieldElementArray.length : 0;
        ArrayList<PersistenceFieldElement> arrayList = new ArrayList<PersistenceFieldElement>(n);
        int n2 = 0;
        while (n2 < n) {
            PersistenceFieldElement persistenceFieldElement = persistenceFieldElementArray[n2];
            if (persistenceFieldElement instanceof RelationshipElement) {
                arrayList.add(persistenceFieldElement);
            }
            ++n2;
        }
        n = arrayList.size();
        return arrayList.toArray(new RelationshipElement[n]);
    }

    public RelationshipElement getRelationship(String string) {
        RelationshipElement[] relationshipElementArray = this.getRelationships();
        int n = relationshipElementArray != null ? relationshipElementArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            RelationshipElement relationshipElement = relationshipElementArray[n2];
            if (string.equals(relationshipElement.getName())) {
                return relationshipElement;
            }
            ++n2;
        }
        return null;
    }

    public void addConcurrencyGroup(ConcurrencyGroupElement concurrencyGroupElement) throws ModelException {
        this.addConcurrencyGroups(new ConcurrencyGroupElement[]{concurrencyGroupElement});
    }

    public void addConcurrencyGroups(ConcurrencyGroupElement[] concurrencyGroupElementArray) throws ModelException {
        this.getClassImpl().changeConcurrencyGroups(concurrencyGroupElementArray, 1);
    }

    public void removeConcurrencyGroup(ConcurrencyGroupElement concurrencyGroupElement) throws ModelException {
        this.removeConcurrencyGroups(new ConcurrencyGroupElement[]{concurrencyGroupElement});
    }

    public void removeConcurrencyGroups(ConcurrencyGroupElement[] concurrencyGroupElementArray) throws ModelException {
        this.getClassImpl().changeConcurrencyGroups(concurrencyGroupElementArray, -1);
    }

    public ConcurrencyGroupElement[] getConcurrencyGroups() {
        return this.getClassImpl().getConcurrencyGroups();
    }

    public void setConcurrencyGroups(ConcurrencyGroupElement[] concurrencyGroupElementArray) throws ModelException {
        this.getClassImpl().changeConcurrencyGroups(concurrencyGroupElementArray, 0);
    }

    public ConcurrencyGroupElement getConcurrencyGroup(String string) {
        return this.getClassImpl().getConcurrencyGroup(string);
    }

    public boolean containsConcurrencyGroup(ConcurrencyGroupElement concurrencyGroupElement) {
        return this.getClassImpl().getConcurrencyGroup(concurrencyGroupElement.getName()) != null;
    }

    public static interface Impl
    extends PersistenceElement.Impl {
        public boolean isModified();

        public void setModified(boolean var1);

        public int getObjectIdentityType();

        public void setObjectIdentityType(int var1) throws ModelException;

        public String getKeyClass();

        public void setKeyClass(String var1) throws ModelException;

        public void changeFields(PersistenceFieldElement[] var1, int var2) throws ModelException;

        public PersistenceFieldElement[] getFields();

        public PersistenceFieldElement getField(String var1);

        public void changeConcurrencyGroups(ConcurrencyGroupElement[] var1, int var2) throws ModelException;

        public ConcurrencyGroupElement[] getConcurrencyGroups();

        public ConcurrencyGroupElement getConcurrencyGroup(String var1);
    }
}

