/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.util;

import com.sun.jdo.api.persistence.enhancer.util.ClassPath;
import com.sun.jdo.api.persistence.enhancer.util.ClassPathElement;
import com.sun.jdo.api.persistence.enhancer.util.FilePath;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import com.sun.jdo.api.persistence.enhancer.util.UserException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassFileSource
extends Support {
    private String theOriginalExpectedClassName = null;
    private String theExpectedClassName = null;
    private File classFile = null;
    private ZipFile zipFile = null;
    private InputStream byteCodeStream = null;
    private ClassPathElement sourceElement;
    private long cachedModDate;

    public boolean sameAs(ClassFileSource classFileSource) {
        if (this.isZipped()) {
            return classFileSource.isZipped() && classFileSource.zipFile.getName().equals(this.zipFile.getName());
        }
        if (classFileSource.isZipped()) {
            return false;
        }
        if (classFileSource.classFile != null && this.classFile != null) {
            return classFileSource.classFile.getPath().equals(this.classFile.getPath());
        }
        if (this.byteCodeStream != null) {
            return this.byteCodeStream.equals(classFileSource.byteCodeStream);
        }
        return false;
    }

    public boolean isZipped() {
        return this.zipFile != null;
    }

    public boolean isStreamed() {
        return this.byteCodeStream != null;
    }

    public String expectedClassName() {
        return this.theExpectedClassName;
    }

    public void setExpectedClassName(String string) {
        this.theExpectedClassName = string;
    }

    public String containingFilePath() {
        if (this.isZipped()) {
            return this.zipFile.getName();
        }
        if (this.classFile != null) {
            return this.classFile.getPath();
        }
        return null;
    }

    public ClassFileSource(String string, File file) {
        this.theExpectedClassName = string;
        this.theOriginalExpectedClassName = string;
        this.classFile = file;
    }

    public ClassFileSource(String string, ZipFile zipFile) {
        this.theExpectedClassName = string;
        this.theOriginalExpectedClassName = string;
        this.zipFile = zipFile;
    }

    public ClassFileSource(String string, InputStream inputStream) {
        this.theExpectedClassName = string;
        this.theOriginalExpectedClassName = string;
        this.byteCodeStream = inputStream;
    }

    public ClassFileSource nextSource(String string) {
        if (this.sourceElement != null && this.sourceElement.next() != null) {
            return ClassPath.findClass(string, this.sourceElement.next());
        }
        return null;
    }

    public ClassFileSource friendSource(String string) {
        if (this.isZipped()) {
            return new ClassFileSource(string, this.zipFile);
        }
        String string2 = FilePath.getAbsolutePath(this.classFile);
        File file = new File(string2.substring(0, string2.lastIndexOf(File.separatorChar) + 1));
        File file2 = new File(file, this.unpackagedName(string) + ".class");
        return new ClassFileSource(string, file2);
    }

    public DataInputStream classFileContents() throws IOException, FileNotFoundException {
        if (this.isZipped()) {
            ZipEntry zipEntry = this.zipFile.getEntry(ClassPath.zipFileNameOf(this.theExpectedClassName));
            if (zipEntry == null) {
                throw new FileNotFoundException("The zip file member " + this.theExpectedClassName + " was not found.");
            }
            return new DataInputStream(this.zipFile.getInputStream(zipEntry));
        }
        if (this.isStreamed()) {
            return new DataInputStream(this.byteCodeStream);
        }
        return new DataInputStream(new BufferedInputStream(new FileInputStream(this.classFile)));
    }

    public long modificationDate() throws FileNotFoundException {
        if (this.cachedModDate == 0L) {
            if (this.isZipped()) {
                ZipEntry zipEntry = this.zipFile.getEntry(ClassPath.zipFileNameOf(this.theOriginalExpectedClassName));
                if (zipEntry == null) {
                    throw new FileNotFoundException("The zip file member was not found.");
                }
                this.cachedModDate = zipEntry.getTime();
            } else if (this.classFile != null) {
                this.cachedModDate = this.classFile.lastModified();
            }
        }
        return this.cachedModDate;
    }

    public void setModificationDate(long l) {
        this.cachedModDate = l;
    }

    void setSourceElement(ClassPathElement classPathElement) {
        this.sourceElement = classPathElement;
    }

    private File computeDestinationDir(File file) throws IOException, FileNotFoundException {
        StringBuffer stringBuffer = new StringBuffer(file.getPath());
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.theExpectedClassName, "/", false);
        while (stringTokenizer.hasMoreTokens()) {
            if (string != null) {
                stringBuffer.append(File.separatorChar);
                stringBuffer.append(string);
                File file2 = new File(stringBuffer.toString());
                if (!file2.isDirectory() && !file2.mkdir()) {
                    throw new UserException(Support.getI18N("enhancer.unable_to_create_dir", file2.getPath()));
                }
            }
            string = stringTokenizer.nextToken();
        }
        return new File(stringBuffer.toString());
    }

    public File computeDestination(File file) throws IOException, FileNotFoundException {
        if (file != null) {
            File file2 = this.computeDestinationDir(file);
            String string = "";
            StringTokenizer stringTokenizer = new StringTokenizer(this.theExpectedClassName, "/", false);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
            return new File(file2, string + ".class");
        }
        return this.classFile;
    }

    public DataOutputStream getOutputStream(File file) throws IOException, FileNotFoundException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    private String unpackagedName(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }
}

