/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel.jdbcimpl.wizard;

import com.sun.forte4j.modules.dbmodel.jdbcimpl.wizard.DBSchemaPanel;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.wizard.DBSchemaWizardData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.netbeans.modules.db.explorer.nodes.ConnectionNode;
import org.netbeans.modules.db.explorer.nodes.DriverNode;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class DBSchemaConnectionPanel
extends DBSchemaPanel
implements ChangeListener,
DocumentListener,
ListDataListener {
    static final long serialVersionUID = 5364628520334696421L;
    private ArrayList connInfos;
    private ArrayList drvInfos;
    private boolean schemas;
    private JPasswordField passwordField;
    private JLabel nameLabel;
    private JTextField urlTextField;
    private JTextField driverTextField;
    private JTabbedPane newConnTabbedPane;
    private JLabel driverLabel;
    private JTextField usernameTextField;
    private JRadioButton newConnRadioButton;
    private JTextPane schemaTextPane;
    private JPanel advancedPanel;
    private JLabel usernameLabel;
    private JComboBox existingConnComboBox;
    private JComboBox schemaComboBox;
    private JComboBox nameComboBox;
    private JLabel urlLabel;
    private JPanel connectionPanel;
    private JRadioButton existingConnRadioButton;
    private JLabel passwordLabel;
    private JTextArea descriptionTextArea;
    private static final ResourceBundle bundle = NbBundle.getBundle((String)"com.sun.forte4j.modules.dbmodel.jdbcimpl.resources.Bundle");
    private static final ResourceBundle bundleDB = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    static /* synthetic */ Class class$javax$swing$JToggleButton$ToggleButtonModel;
    static /* synthetic */ Class class$javax$swing$JTabbedPane;

    public DBSchemaConnectionPanel(DBSchemaWizardData dBSchemaWizardData) {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.connInfos = new ArrayList();
        this.drvInfos = new ArrayList();
        this.schemas = false;
        this.data = dBSchemaWizardData;
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(1));
        this.setName(bundle.getString("ConnectionChooser"));
        this.initComponents();
        this.initAccessibility();
        this.existingConnRadioButton.setMnemonic(bundle.getString("ExistingConnection_Mnemonic").charAt(0));
        this.newConnRadioButton.setMnemonic(bundle.getString("NewConnection_Mnemonic").charAt(0));
        this.nameLabel.setDisplayedMnemonic(bundle.getString("DriverName_Mnemonic").charAt(0));
        this.driverLabel.setDisplayedMnemonic(bundle.getString("Driver_Mnemonic").charAt(0));
        this.urlLabel.setDisplayedMnemonic(bundle.getString("DatabaseURL_Mnemonic").charAt(0));
        this.usernameLabel.setDisplayedMnemonic(bundle.getString("UserName_Mnemonic").charAt(0));
        this.passwordLabel.setDisplayedMnemonic(bundle.getString("Password_Mnemonic").charAt(0));
        this.nameComboBox.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaConnectionPanel.this.nameComboBox.requestFocus();
            }
        }, KeyStroke.getKeyStroke(78, 8), 2);
        this.driverTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaConnectionPanel.this.driverTextField.requestFocus();
            }
        }, KeyStroke.getKeyStroke(68, 8), 2);
        this.urlTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaConnectionPanel.this.urlTextField.requestFocus();
            }
        }, KeyStroke.getKeyStroke(82, 8), 2);
        this.usernameTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaConnectionPanel.this.usernameTextField.requestFocus();
            }
        }, KeyStroke.getKeyStroke(85, 8), 2);
        this.passwordField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaConnectionPanel.this.passwordField.requestFocus();
            }
        }, KeyStroke.getKeyStroke(80, 8), 2);
        this.newConnTabbedPane.addChangeListener(this);
        this.newConnTabbedPane.setTitleAt(0, bundle.getString("ConnectionTab"));
        this.newConnTabbedPane.setTitleAt(1, bundle.getString("AdvancedTab"));
        buttonGroup.add(this.existingConnRadioButton);
        buttonGroup.add(this.newConnRadioButton);
        buttonGroup.getSelection().addChangeListener(this);
        Node[] nodeArray = TopManager.getDefault().getPlaces().nodes().environment().getChildren().findChild("Databases").getChildren().getNodes();
        int n = 0;
        while (n < nodeArray.length) {
            block10: {
                if (nodeArray[n] instanceof ConnectionNode) {
                    try {
                        Class.forName(((ConnectionNode)nodeArray[n]).getInfo().getDriver());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        break block10;
                    }
                    this.existingConnComboBox.addItem(((ConnectionNode)nodeArray[n]).getDisplayName());
                    this.connInfos.add((ConnectionNodeInfo)((ConnectionNode)nodeArray[n]).getInfo());
                }
            }
            ++n;
        }
        if (this.existingConnComboBox.getItemCount() == 0) {
            this.existingConnComboBox.insertItemAt(bundle.getString("NoConnection"), 0);
            this.existingConnRadioButton.setEnabled(false);
            this.newConnRadioButton.setSelected(true);
            dBSchemaWizardData.setExistingConn(false);
        } else {
            this.existingConnComboBox.insertItemAt(bundle.getString("SelectFromTheList"), 0);
            this.existingConnRadioButton.setSelected(true);
            dBSchemaWizardData.setExistingConn(true);
        }
        this.existingConnComboBox.setSelectedIndex(0);
        nodeArray = TopManager.getDefault().getPlaces().nodes().environment().getChildren().findChild("Databases").getChildren().findChild("Drivers").getChildren().getNodes();
        int n2 = 0;
        while (n2 < nodeArray.length) {
            if (nodeArray[n2] instanceof DriverNode && !((DriverNode)nodeArray[n2]).getInfo().getIconBase().endsWith("NotInstalled")) {
                this.nameComboBox.addItem(((DriverNode)nodeArray[n2]).getDisplayName());
                this.drvInfos.add((DriverNodeInfo)((DriverNode)nodeArray[n2]).getInfo());
            }
            ++n2;
        }
        if (this.nameComboBox.getItemCount() == 0) {
            this.nameComboBox.insertItemAt(bundle.getString("NoTemplate"), 0);
        } else {
            this.nameComboBox.insertItemAt(bundle.getString("SelectFromTheList"), 0);
        }
        this.nameComboBox.setSelectedIndex(0);
        this.driverTextField.getDocument().addDocumentListener(this);
        this.urlTextField.getDocument().addDocumentListener(this);
        this.existingConnComboBox.getModel().addListDataListener(this);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("schemas")) {
                    DBSchemaConnectionPanel.this.switchToAdvanced();
                }
            }
        };
        dBSchemaWizardData.getPropertySupport().addPropertyChangeListener(propertyChangeListener);
    }

    private void initAccessibility() {
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(bundle.getString("ACS_DescriptionA11yName"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_DescriptionA11yDesc"));
        this.existingConnComboBox.getAccessibleContext().setAccessibleName(bundle.getString("ACS_ExistingConnectionA11yDesc"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_DriverNameA11yDesc"));
        this.nameComboBox.getAccessibleContext().setAccessibleName(bundle.getString("ACS_DriverNameComboBoxA11yName"));
        this.driverLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_DriverA11yDesc"));
        this.driverTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_DriverTextFieldA11yName"));
        this.urlLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_DatabaseURLA11yDesc"));
        this.urlTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_DatabaseURLTextFieldA11yName"));
        this.usernameLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_UserNameA11yDesc"));
        this.usernameTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_UserNameTextFieldA11yName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_PasswordA11yDesc"));
        this.passwordField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_PasswordTextFieldA11yName"));
        this.schemaTextPane.getAccessibleContext().setAccessibleName(bundle.getString("ACS_SchemaDescriptionA11yName"));
        this.schemaTextPane.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_SchemaDescriptionA11yDesc"));
        this.schemaComboBox.getAccessibleContext().setAccessibleName(bundle.getString("ACS_SchemaComboBoxA11yName"));
    }

    private void initComponents() {
        this.descriptionTextArea = new JTextArea();
        this.existingConnRadioButton = new JRadioButton();
        this.existingConnComboBox = new JComboBox();
        this.newConnRadioButton = new JRadioButton();
        this.newConnTabbedPane = new JTabbedPane(3);
        this.connectionPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameComboBox = new JComboBox();
        this.driverLabel = new JLabel();
        this.driverTextField = new JTextField();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.usernameLabel = new JLabel();
        this.usernameTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.advancedPanel = new JPanel();
        this.schemaTextPane = new JTextPane();
        this.schemaComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(600, 350));
        this.setMinimumSize(new Dimension(600, 350));
        this.setMaximumSize(new Dimension(600, 350));
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setFont(UIManager.getFont("Label.font"));
        this.descriptionTextArea.setText(bundle.getString("Description"));
        this.descriptionTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.descriptionTextArea.setEnabled(false);
        this.descriptionTextArea.setRequestFocusEnabled(false);
        this.descriptionTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.descriptionTextArea, gridBagConstraints);
        this.existingConnRadioButton.setToolTipText(bundle.getString("ACS_ExistingConnectionA11yDesc"));
        this.existingConnRadioButton.setSelected(true);
        this.existingConnRadioButton.setText(bundle.getString("ExistingConnection"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.existingConnRadioButton, gridBagConstraints);
        this.existingConnComboBox.setToolTipText(bundle.getString("ACS_ExistingConnectionComboBoxA11yDesc"));
        this.existingConnComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaConnectionPanel.this.existingConnComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 24, 0, 11);
        this.add((Component)this.existingConnComboBox, gridBagConstraints);
        this.newConnRadioButton.setToolTipText(bundle.getString("ACS_NewConnectionA11yDesc"));
        this.newConnRadioButton.setText(bundle.getString("NewConnection"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.newConnRadioButton, gridBagConstraints);
        this.newConnTabbedPane.setTabPlacement(3);
        this.connectionPanel.setLayout(new GridBagLayout());
        this.nameLabel.setText(bundle.getString("DriverName"));
        this.nameLabel.setLabelFor(this.nameComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.connectionPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameComboBox.setToolTipText(bundle.getString("ACS_DriverNameComboBoxA11yDesc"));
        this.nameComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaConnectionPanel.this.nameComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.connectionPanel.add((Component)this.nameComboBox, gridBagConstraints);
        this.driverLabel.setText(bundle.getString("Driver"));
        this.driverLabel.setLabelFor(this.driverTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.connectionPanel.add((Component)this.driverLabel, gridBagConstraints);
        this.driverTextField.setToolTipText(bundle.getString("ACS_DriverTextFieldA11yDesc"));
        this.driverTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                DBSchemaConnectionPanel.this.driverTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.connectionPanel.add((Component)this.driverTextField, gridBagConstraints);
        this.urlLabel.setText(bundle.getString("DatabaseURL"));
        this.urlLabel.setLabelFor(this.urlTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.connectionPanel.add((Component)this.urlLabel, gridBagConstraints);
        this.urlTextField.setToolTipText(bundle.getString("ACS_DatabaseURLTextFieldA11yDesc"));
        this.urlTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                DBSchemaConnectionPanel.this.urlTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.connectionPanel.add((Component)this.urlTextField, gridBagConstraints);
        this.usernameLabel.setText(bundle.getString("UserName"));
        this.usernameLabel.setLabelFor(this.usernameTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.connectionPanel.add((Component)this.usernameLabel, gridBagConstraints);
        this.usernameTextField.setToolTipText(bundle.getString("ACS_UserNameTextFieldA11yDesc"));
        this.usernameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                DBSchemaConnectionPanel.this.usernameTextFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.connectionPanel.add((Component)this.usernameTextField, gridBagConstraints);
        this.passwordLabel.setText(bundle.getString("Password"));
        this.passwordLabel.setLabelFor(this.passwordField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 11, 0);
        this.connectionPanel.add((Component)this.passwordLabel, gridBagConstraints);
        this.passwordField.setToolTipText(bundle.getString("ACS_PasswordTextFieldA11yDesc"));
        this.passwordField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                DBSchemaConnectionPanel.this.passwordFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 11);
        this.connectionPanel.add((Component)this.passwordField, gridBagConstraints);
        this.newConnTabbedPane.addTab("Conn.", null, this.connectionPanel, "");
        this.advancedPanel.setLayout(new GridBagLayout());
        this.schemaTextPane.setEditable(false);
        this.schemaTextPane.setFont(UIManager.getFont("Label.font"));
        this.schemaTextPane.setText(bundle.getString("SchemaDescription"));
        this.schemaTextPane.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.schemaTextPane.setEnabled(false);
        this.schemaTextPane.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.advancedPanel.add((Component)this.schemaTextPane, gridBagConstraints);
        this.schemaComboBox.setToolTipText(bundle.getString("ACS_SchemaComboBoxA11yDesc"));
        this.schemaComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBSchemaConnectionPanel.this.schemaComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.advancedPanel.add((Component)this.schemaComboBox, gridBagConstraints);
        this.newConnTabbedPane.addTab("Adv.", null, this.advancedPanel, "");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 24, 11, 11);
        this.add((Component)this.newConnTabbedPane, gridBagConstraints);
    }

    private void schemaComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.schemaComboBox.getItemCount() > 0) {
            this.data.setSchema(this.schemaComboBox.getSelectedItem().toString());
        } else {
            this.data.setSchema(null);
        }
    }

    private void nameComboBoxActionPerformed(ActionEvent actionEvent) {
        int n = this.nameComboBox.getSelectedIndex();
        if (n > 0) {
            this.driverTextField.setText(((DriverNodeInfo)this.drvInfos.get(n - 1)).getDatabaseDriver().getURL());
            this.urlTextField.setText(((DriverNodeInfo)this.drvInfos.get(n - 1)).getDatabaseDriver().getDatabasePrefix());
        } else {
            this.driverTextField.setText("");
            this.urlTextField.setText("");
        }
        this.usernameTextField.setText("");
        ((JTextComponent)this.passwordField).setText("");
        this.data.setDriver(this.driverTextField.getText());
        this.data.setSchema(null);
        this.schemas = false;
    }

    private void driverTextFieldFocusLost(FocusEvent focusEvent) {
        this.data.setDriver(this.driverTextField.getText());
        this.schemas = false;
    }

    private void urlTextFieldFocusLost(FocusEvent focusEvent) {
        this.data.setUrl(this.urlTextField.getText());
        this.schemas = false;
    }

    private void usernameTextFieldFocusLost(FocusEvent focusEvent) {
        this.data.setUsername(this.usernameTextField.getText());
        this.schemas = false;
    }

    private void passwordFieldFocusLost(FocusEvent focusEvent) {
        this.data.setPassword(new String(this.passwordField.getPassword()));
        this.schemas = false;
    }

    private void existingConnComboBoxActionPerformed(ActionEvent actionEvent) {
        if (this.existingConnComboBox.getSelectedIndex() > 0) {
            this.data.setConnectionNodeInfo((ConnectionNodeInfo)this.connInfos.get(this.existingConnComboBox.getSelectedIndex() - 1));
        }
    }

    public boolean isValid() {
        if (this.existingConnRadioButton.isSelected()) {
            if (this.existingConnComboBox.getSelectedIndex() > 0) {
                return true;
            }
        } else {
            if (this.driverTextField.getText().length() > 0 && this.urlTextField.getText().length() > 0) {
                this.newConnTabbedPane.setEnabledAt(1, true);
                return true;
            }
            this.newConnTabbedPane.setEnabledAt(1, false);
        }
        return false;
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireChange(this);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChange(this);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireChange(this);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.fireChange(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource().getClass() == (class$javax$swing$JToggleButton$ToggleButtonModel == null ? (class$javax$swing$JToggleButton$ToggleButtonModel = DBSchemaConnectionPanel.class$("javax.swing.JToggleButton$ToggleButtonModel")) : class$javax$swing$JToggleButton$ToggleButtonModel)) {
            if (this.existingConnRadioButton.isSelected()) {
                this.existingConnComboBox.setEnabled(true);
                this.newConnTabbedPane.setEnabled(false);
                this.nameComboBox.setEnabled(false);
                this.driverTextField.setEnabled(false);
                this.urlTextField.setEnabled(false);
                this.usernameTextField.setEnabled(false);
                this.passwordField.setEnabled(false);
                this.newConnTabbedPane.setEnabledAt(1, false);
                this.schemaComboBox.setEnabled(false);
            } else {
                this.existingConnComboBox.setEnabled(false);
                this.newConnTabbedPane.setEnabled(true);
                this.nameComboBox.setEnabled(true);
                this.driverTextField.setEnabled(true);
                this.urlTextField.setEnabled(true);
                this.usernameTextField.setEnabled(true);
                this.passwordField.setEnabled(true);
                this.newConnTabbedPane.setEnabledAt(1, false);
                this.schemaComboBox.setEnabled(false);
            }
        }
        if (changeEvent.getSource().getClass() == (class$javax$swing$JTabbedPane == null ? (class$javax$swing$JTabbedPane = DBSchemaConnectionPanel.class$("javax.swing.JTabbedPane")) : class$javax$swing$JTabbedPane) && this.newConnTabbedPane.getSelectedIndex() == 1 && !this.schemas) {
            this.schemaComboBox.removeAllItems();
            try {
                Class.forName(this.driverTextField.getText());
                Connection connection = DriverManager.getConnection(this.urlTextField.getText(), this.usernameTextField.getText(), new String(this.passwordField.getPassword()));
                ResultSet resultSet = connection.getMetaData().getSchemas();
                while (resultSet.next()) {
                    this.schemaComboBox.addItem(resultSet.getString(1).trim());
                }
                resultSet.close();
                connection.close();
                String string = this.data.getUsername();
                int n = 0;
                while (n < this.schemaComboBox.getItemCount()) {
                    if (this.schemaComboBox.getItemAt(n).toString().equalsIgnoreCase(string)) {
                        this.schemaComboBox.setSelectedIndex(n);
                        this.data.setSchema(this.schemaComboBox.getItemAt(n).toString());
                        break;
                    }
                    ++n;
                }
                this.schemaTextPane.setText(bundle.getString("SchemaDescription"));
                if (this.schemaComboBox.getItemCount() > 0) {
                    this.schemaComboBox.setEnabled(true);
                } else {
                    this.schemaComboBox.insertItemAt(bundle.getString("NoSchema"), 0);
                    this.schemaComboBox.setSelectedIndex(0);
                }
                this.schemas = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string = bundle.getString("SchemaDescription2") + "\n" + MessageFormat.format(bundleDB.getString("EXC_ClassNotFound"), classNotFoundException.getMessage());
                this.schemaTextPane.setText(string);
                this.schemaComboBox.removeAllItems();
                this.schemaComboBox.insertItemAt(bundle.getString("NoSchema"), 0);
                this.schemaComboBox.setSelectedIndex(0);
                this.schemaComboBox.setEnabled(false);
                this.schemas = false;
            }
            catch (SQLException sQLException) {
                String string = sQLException.getMessage();
                String string2 = bundle.getString("SchemaDescription2") + "\n";
                string2 = this.driverTextField.getText().equals("com.pointbase.jdbc.jdbcUniversalDriver") && sQLException.getErrorCode() == 86024 ? string2 + string + "\n\n" + MessageFormat.format(bundleDB.getString("EXC_PointbaseServerRejected"), "", this.urlTextField.getText()).substring(2) : (string == null ? string2 + bundle.getString("SchemaDescription3") : string2 + string + "\n\n" + bundle.getString("SchemaDescription3"));
                this.schemaTextPane.setText(string2);
                this.schemaComboBox.removeAllItems();
                this.schemaComboBox.insertItemAt(bundle.getString("NoSchema"), 0);
                this.schemaComboBox.setSelectedIndex(0);
                this.schemaComboBox.setEnabled(false);
                this.schemas = false;
            }
        }
        this.fireChange(this);
    }

    protected void switchToAdvanced() {
        Vector vector = this.data.getSchemas();
        this.schemaComboBox.removeAllItems();
        int n = 0;
        while (n < vector.size()) {
            this.schemaComboBox.addItem(vector.get(n).toString());
            ++n;
        }
        this.schemas = true;
        this.schemaComboBox.setEnabled(true);
        this.newConnTabbedPane.setSelectedIndex(1);
    }

    protected void initData() {
        if (this.existingConnRadioButton.isSelected()) {
            this.data.setExistingConn(true);
            if (this.existingConnComboBox.getSelectedIndex() > 0) {
                this.data.setConnectionNodeInfo((ConnectionNodeInfo)this.connInfos.get(this.existingConnComboBox.getSelectedIndex() - 1));
            }
            this.data.setDriver(null);
            this.data.setUrl(null);
            this.data.setUsername(null);
            this.data.setPassword(null);
        } else {
            this.data.setExistingConn(false);
            this.data.setDriver(this.driverTextField.getText());
            this.data.setUrl(this.urlTextField.getText());
            this.data.setUsername(this.usernameTextField.getText());
            this.data.setPassword(new String(this.passwordField.getPassword()));
            this.data.setConnectionNodeInfo(null);
        }
        this.data.setSchemas(null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

