/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.common.util.zip;

import com.iplanet.ias.tools.common.util.Assertion;
import com.iplanet.ias.tools.common.util.ContainerHelper;
import com.iplanet.ias.tools.common.util.diagnostics.Reporter;
import com.iplanet.ias.tools.common.util.diagnostics.StackTrace;
import com.iplanet.ias.tools.common.util.zip.ZipFileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipWriter {
    private String zipFilename = null;
    private String dirName = null;
    private ZipOutputStream zipStream = null;
    private String[] fileList = null;
    private byte[] buffer = new byte[16384];

    public ZipWriter(String zipFilename, String dirName, String[] fileList) throws ZipFileException {
        try {
            Reporter.assertIt(zipFilename);
            Reporter.assertIt(dirName);
            Reporter.assertIt(fileList);
            Reporter.assertIt(fileList.length > 0);
            File f = new File(dirName);
            Reporter.assertIt(f.exists(), "directory (" + dirName + ") doesn't exist");
            Reporter.assertIt(f.isDirectory());
            try {
                dirName = f.getCanonicalPath();
            }
            catch (IOException e) {
                Reporter.warn("Couldn't getCanonicalPath() for " + dirName);
            }
            dirName = dirName.replace('\\', '/');
            if (!dirName.endsWith("/")) {
                dirName = dirName + "/";
            }
            Reporter.assertIt(!(f = new File(zipFilename)).isDirectory(), "zipFile (" + zipFilename + ") is actually a directory!");
            int i = 0;
            while (i < fileList.length) {
                fileList[i] = fileList[i].replace('\\', '/');
                ++i;
            }
            this.zipFilename = zipFilename;
            this.dirName = dirName;
            this.fileList = fileList;
            this.zipStream = new ZipOutputStream(new FileOutputStream(zipFilename));
        }
        catch (Exception f) {
            Reporter.critical(new StackTrace(f));
            throw new ZipFileException(f);
        }
    }

    public ZipWriter(OutputStream outStream, String dirName, String[] fileList) throws ZipFileException {
        try {
            Reporter.assertIt(dirName);
            Reporter.assertIt(fileList);
            Reporter.assertIt(fileList.length > 0);
            File f = new File(dirName);
            Reporter.assertIt(f.exists(), "directory (" + dirName + ") doesn't exist");
            Reporter.assertIt(f.isDirectory());
            try {
                dirName = f.getCanonicalPath();
            }
            catch (IOException e) {
                Reporter.warn("Couldn't getCanonicalPath() for " + dirName);
            }
            dirName = dirName.replace('\\', '/');
            if (!dirName.endsWith("/")) {
                dirName = dirName + "/";
            }
            int i = 0;
            while (i < fileList.length) {
                fileList[i] = fileList[i].replace('\\', '/');
                ++i;
            }
            this.dirName = dirName;
            this.fileList = fileList;
            this.zipStream = new ZipOutputStream(outStream);
        }
        catch (Assertion.Failure f) {
            throw new ZipFileException(f);
        }
    }

    public void write() throws ZipFileException {
        try {
            int i = 0;
            while (i < this.fileList.length) {
                this.addEntry(this.fileList[i]);
                ++i;
            }
            this.zipStream.close();
        }
        catch (ZipFileException z) {
            Reporter.critical(new StackTrace(z));
            throw z;
        }
        catch (Exception e) {
            Reporter.critical(new StackTrace(e));
            throw new ZipFileException(e);
        }
    }

    public void addEntry(String entryName) throws ZipFileException, IOException {
        int totalBytes = 0;
        FileInputStream in = new FileInputStream(this.dirName + entryName);
        ZipEntry ze = new ZipEntry(entryName);
        this.zipStream.putNextEntry(ze);
        int numBytes = in.read(this.buffer);
        while (numBytes > 0) {
            this.zipStream.write(this.buffer, 0, numBytes);
            totalBytes += numBytes;
            numBytes = in.read(this.buffer);
        }
        this.zipStream.closeEntry();
        Reporter.verbose("Wrote " + entryName + " to Zip File.  Wrote " + totalBytes + " bytes.");
    }

    public String toString() {
        String s = "Zip File Name: " + this.zipFilename + "\n";
        s = s + "Directory Name: " + this.dirName + "\n";
        s = s + "***** File Contents *********\n";
        s = s + ContainerHelper.toOneString(this.fileList);
        return s;
    }

    public static void main(String[] notUsed) {
        Reporter.setSeverityLevel(0);
        try {
            String[] array = new String[]{"hello.txt", "a\\a.txt", "a\\b/b.txt"};
            ZipWriter zw = new ZipWriter("E:\\temp\\hello/ZipWriter.jar", "E:/Temp\\hello", array);
            zw.write();
            Reporter.verbose("" + zw);
        }
        catch (ZipFileException e) {
            Reporter.verbose("ZipFileException: " + e);
        }
    }
}

