/*
 * Decompiled with CFR 0.152.
 */
package antlr.preprocessor;

import antlr.Tool;
import antlr.collections.impl.IndexedVector;
import antlr.preprocessor.Grammar;
import antlr.preprocessor.Hierarchy;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class GrammarFile {
    protected String fileName;
    protected String headerAction = "";
    protected IndexedVector options;
    protected IndexedVector grammars;
    protected boolean expanded = false;

    public void addGrammar(Grammar grammar) {
        this.grammars.appendElement(grammar.getName(), grammar);
    }

    public void generateExpandedFile() throws IOException {
        if (!this.expanded) {
            return;
        }
        String string = this.nameForExpandedGrammarFile(this.getName());
        PrintWriter printWriter = Tool.openOutputFile(string);
        printWriter.println(this.toString());
        printWriter.close();
    }

    public IndexedVector getGrammars() {
        return this.grammars;
    }

    public String getName() {
        return this.fileName;
    }

    public String nameForExpandedGrammarFile(String string) {
        if (this.expanded) {
            return "expanded" + Tool.fileMinusPath(string);
        }
        return string;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
    }

    public void addHeaderAction(String string) {
        this.headerAction = this.headerAction + string + System.getProperty("line.separator");
    }

    public void setOptions(IndexedVector indexedVector) {
        this.options = indexedVector;
    }

    public String toString() {
        String string = this.headerAction == null ? "" : this.headerAction;
        String string2 = this.options == null ? "" : Hierarchy.optionsToString(this.options);
        String string3 = string + string2;
        Enumeration enumeration = this.grammars.elements();
        while (enumeration.hasMoreElements()) {
            Grammar grammar = (Grammar)enumeration.nextElement();
            string3 = string3 + grammar;
        }
        return string3;
    }

    public GrammarFile(String string) {
        this.fileName = string;
        this.grammars = new IndexedVector();
    }
}

