/*
 * Decompiled with CFR 0.152.
 */
package antlr.preprocessor;

import antlr.CodeGenerator;
import antlr.Tool;
import antlr.collections.impl.IndexedVector;
import antlr.preprocessor.GrammarFile;
import antlr.preprocessor.Hierarchy;
import antlr.preprocessor.Option;
import antlr.preprocessor.Rule;
import java.io.IOException;

class Grammar {
    protected String name;
    protected String fileName;
    protected String superGrammar;
    protected String type;
    protected IndexedVector rules;
    protected IndexedVector options;
    protected String tokenSection;
    protected String preambleAction;
    protected String memberAction;
    protected Hierarchy hier;
    protected boolean predefined = false;
    protected boolean alreadyExpanded = false;
    protected boolean specifiedVocabulary = false;
    protected String importVocab = null;
    protected String exportVocab = null;

    public void addOption(Option option) {
        if (this.options == null) {
            this.options = new IndexedVector();
        }
        this.options.appendElement(option.getName(), option);
    }

    public void addRule(Rule rule) {
        this.rules.appendElement(rule.getName(), rule);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void expandInPlace() {
        Object object;
        Object object2;
        if (this.alreadyExpanded) {
            return;
        }
        Grammar grammar = this.getSuperGrammar();
        if (grammar == null) {
            return;
        }
        if (this.exportVocab == null) {
            this.exportVocab = this.getName();
        }
        if (grammar.isPredefined()) {
            return;
        }
        grammar.expandInPlace();
        this.alreadyExpanded = true;
        GrammarFile grammarFile = this.hier.getFile(this.getFileName());
        grammarFile.setExpanded(true);
        IndexedVector indexedVector = grammar.getRules();
        Object object3 = indexedVector.elements();
        while (object3.hasMoreElements()) {
            object2 = (Rule)object3.nextElement();
            this.inherit((Rule)object2, grammar);
        }
        object3 = grammar.getOptions();
        if (object3 != null) {
            object2 = ((IndexedVector)object3).elements();
            while (object2.hasMoreElements()) {
                object = (Option)object2.nextElement();
                this.inherit((Option)object, grammar);
            }
        }
        if (this.options != null && this.options.getElement("importVocab") == null || this.options == null) {
            object2 = new Option("importVocab", grammar.exportVocab + ";", this);
            this.addOption((Option)object2);
            object = grammar.getFileName();
            String string = Tool.pathToFile((String)object);
            String string2 = string + grammar.exportVocab + CodeGenerator.TokenTypesFileSuffix + CodeGenerator.TokenTypesFileExt;
            String string3 = Tool.fileMinusPath(string2);
            if (!string.equals("." + System.getProperty("file.separator"))) {
                try {
                    Tool.copyFile(string2, string3);
                }
                catch (IOException iOException) {
                    Tool.toolError("cannot find/copy importVocab file " + string2);
                    return;
                }
            }
        }
        this.inherit(grammar.memberAction, grammar);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.name;
    }

    public IndexedVector getOptions() {
        return this.options;
    }

    public IndexedVector getRules() {
        return this.rules;
    }

    public Grammar getSuperGrammar() {
        if (this.superGrammar == null) {
            return null;
        }
        Grammar grammar = this.hier.getGrammar(this.superGrammar);
        return grammar;
    }

    public String getSuperGrammarName() {
        return this.superGrammar;
    }

    public String getType() {
        return this.type;
    }

    public void inherit(Option option, Grammar grammar) {
        if (option.getName().equals("importVocab") || option.getName().equals("exportVocab")) {
            return;
        }
        Option option2 = null;
        if (this.options != null) {
            option2 = (Option)this.options.getElement(option.getName());
        }
        if (option2 == null) {
            this.addOption(option);
        }
    }

    public void inherit(Rule rule, Grammar grammar) {
        Rule rule2 = (Rule)this.rules.getElement(rule.getName());
        if (rule2 != null) {
            if (!rule2.sameSignature(rule)) {
                Tool.warning("rule " + this.getName() + "." + rule2.getName() + " has different signature than " + grammar.getName() + "." + rule2.getName());
            }
        } else {
            this.addRule(rule);
        }
    }

    public void inherit(String string, Grammar grammar) {
        if (this.memberAction != null) {
            return;
        }
        if (string != null) {
            this.memberAction = string;
        }
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setHierarchy(Hierarchy hierarchy) {
        this.hier = hierarchy;
    }

    public void setMemberAction(String string) {
        this.memberAction = string;
    }

    public void setOptions(IndexedVector indexedVector) {
        this.options = indexedVector;
    }

    public void setPreambleAction(String string) {
        this.preambleAction = string;
    }

    public void setPredefined(boolean bl) {
        this.predefined = bl;
    }

    public void setTokenSection(String string) {
        this.tokenSection = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String toString() {
        String string = "";
        if (this.preambleAction != null) {
            string = string + this.preambleAction;
        }
        if (this.superGrammar == null) {
            return "class " + this.name + ";";
        }
        String string2 = "";
        string = string + "class " + this.name + " extends " + this.type + string2 + ";" + System.getProperty("line.separator") + System.getProperty("line.separator");
        if (this.options != null) {
            string = string + Hierarchy.optionsToString(this.options);
        }
        if (this.tokenSection != null) {
            string = string + this.tokenSection + "\n";
        }
        if (this.memberAction != null) {
            string = string + this.memberAction + System.getProperty("line.separator");
        }
        int n = 0;
        while (n < this.rules.size()) {
            Rule rule = (Rule)this.rules.elementAt(n);
            if (!this.getName().equals(rule.enclosingGrammar.getName())) {
                string = string + "// inherited from grammar " + rule.enclosingGrammar.getName() + System.getProperty("line.separator");
            }
            string = string + rule + System.getProperty("line.separator") + System.getProperty("line.separator");
            ++n;
        }
        return string;
    }

    public Grammar(String string, String string2, IndexedVector indexedVector) {
        this.name = string;
        this.superGrammar = string2;
        this.rules = indexedVector;
    }
}

