/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyPair;
import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.Password;

public class SigTest {
    public static void main(String[] stringArray) {
        try {
            byte[] byArray = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
            if (stringArray.length != 2) {
                SigTest.usage();
                System.exit(1);
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(stringArray[0]);
            CryptoManager.initialize(initializationValues);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            cryptoManager.setPasswordCallback(new Password("netscape".toCharArray()));
            Enumeration enumeration = cryptoManager.getAllTokens();
            System.out.println("Available tokens:");
            while (enumeration.hasMoreElements()) {
                PK11Token pK11Token = (PK11Token)enumeration.nextElement();
                System.out.println(" token : " + pK11Token.getName());
            }
            CryptoToken cryptoToken = cryptoManager.getTokenByName(string2);
            KeyPairGenerator keyPairGenerator = cryptoToken.getKeyPairGenerator(KeyPairAlgorithm.RSA);
            keyPairGenerator.initialize(1024);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            Signature signature = cryptoToken.getSignatureContext(SignatureAlgorithm.RSASignatureWithMD5Digest);
            System.out.println("Created a signing context");
            signature.initSign((PrivateKey)keyPair.getPrivate());
            System.out.println("initialized the signing operation");
            signature.update(byArray);
            System.out.println("updated signature with data");
            byte[] byArray2 = signature.sign();
            System.out.println("Successfully signed!");
            signature.initVerify(keyPair.getPublic());
            System.out.println("initialized verification");
            signature.update(byArray);
            System.out.println("updated verification with data");
            if (signature.verify(byArray2)) {
                System.out.println("Signature Verified Successfully!");
            } else {
                System.out.println("ERROR: Signature failed to verify.");
            }
            System.out.println("SigTest passed.");
            System.exit(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public static void usage() {
        System.out.println("Usage: java org.mozilla.jss.crypto.SigTest <dbdir> <tokenname>");
    }
}

