/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class NULL
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 5L);
    public static final Form FORM = Form.PRIMITIVE;
    private static final NULL instance = new NULL();
    private static final Template templateInstance = new Template();

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(tag, FORM, 0L);
        aSN1Header.encode(outputStream);
    }

    public static NULL getInstance() {
        return instance;
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                ASN1Header aSN1Header = new ASN1Header(inputStream);
                aSN1Header.validate(tag, FORM);
                if (aSN1Header.getContentLength() != 0L) {
                    throw new InvalidBERException("Invalid length (" + aSN1Header.getContentLength() + ") for NULL; only 0 is permitted");
                }
                return new NULL();
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "NULL");
            }
        }

        public Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }
    }
}

