/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.parser.ParserUtils;
import org.apache.jasper.parser.TreeNode;

public class TldLocationsCache {
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private Hashtable mappings = new Hashtable();

    public TldLocationsCache(ServletContext servletContext) {
        try {
            this.processWebDotXml(servletContext);
            this.processJars(servletContext);
        }
        catch (JasperException jasperException) {
            Constants.message("jsp.error.internal.tldinit", new Object[]{jasperException.getMessage()}, 1);
        }
    }

    private void processWebDotXml(ServletContext servletContext) throws JasperException {
        InputStream inputStream = null;
        String string = null;
        string = (String)servletContext.getAttribute("org.apache.catalina.deploy.alt_dd");
        if (string != null) {
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Constants.message("jsp.error.internal.filenotfound", new Object[]{string}, 2);
            }
        } else {
            inputStream = servletContext.getResourceAsStream(WEB_XML);
        }
        if (inputStream == null) {
            return;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        ParserUtils parserUtils = ParserUtils.createParserUtils(classLoader);
        TreeNode treeNode = null;
        treeNode = string != null ? parserUtils.parseXMLDocument(string, inputStream) : parserUtils.parseXMLDocument(WEB_XML, inputStream);
        Iterator iterator = treeNode.findChildren("taglib");
        while (iterator.hasNext()) {
            TreeNode treeNode2 = (TreeNode)iterator.next();
            String string2 = null;
            String string3 = null;
            TreeNode treeNode3 = treeNode2.findChild("taglib-uri");
            if (treeNode3 != null) {
                string2 = treeNode3.getBody();
            }
            if ((treeNode3 = treeNode2.findChild("taglib-location")) != null) {
                string3 = treeNode3.getBody();
            }
            if (string3 == null) continue;
            if (TldLocationsCache.uriType(string3) == 2) {
                string3 = "/WEB-INF/" + string3;
            }
            String string4 = null;
            if (string3.endsWith(".jar")) {
                string4 = "META-INF/taglib.tld";
            }
            this.mappings.put(string2, new String[]{string3, string4});
        }
    }

    private void processJars(ServletContext servletContext) throws JasperException {
        Set set = servletContext.getResourcePaths("/WEB-INF/lib");
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!string.endsWith(".jar")) continue;
            this.tldConfigJar(servletContext, string);
        }
    }

    private void tldConfigJar(ServletContext servletContext, String string) throws JasperException {
        block9: {
            ZipFile zipFile = null;
            InputStream inputStream = null;
            try {
                URL uRL = servletContext.getResource(string);
                if (uRL == null) {
                    return;
                }
                uRL = new URL("jar:" + uRL.toString() + "!/");
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                zipFile = jarURLConnection.getJarFile();
                Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                while (enumeration.hasMoreElements()) {
                    String string2;
                    JarEntry jarEntry = enumeration.nextElement();
                    String string3 = jarEntry.getName();
                    if (!string3.startsWith("META-INF/") || !string3.endsWith(".tld") || (string2 = this.parseTldForUri(string, inputStream = ((JarFile)zipFile).getInputStream(jarEntry))) == null) continue;
                    this.mappings.put(string2, new String[]{string, string3});
                }
            }
            catch (Exception exception) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (zipFile == null) break block9;
                try {
                    zipFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private String parseTldForUri(String string, InputStream inputStream) throws JasperException {
        String string2;
        ClassLoader classLoader = this.getClass().getClassLoader();
        ParserUtils parserUtils = ParserUtils.createParserUtils(classLoader);
        TreeNode treeNode = parserUtils.parseXMLDocument(string, inputStream);
        TreeNode treeNode2 = treeNode.findChild("uri");
        if (treeNode2 != null && (string2 = treeNode2.getBody()) != null) {
            return string2;
        }
        return null;
    }

    public String[] getLocation(String string) throws JasperException {
        return (String[])this.mappings.get(string);
    }

    public static int uriType(String string) {
        if (string.indexOf(58) != -1) {
            return 0;
        }
        if (string.startsWith("/")) {
            return 1;
        }
        return 2;
    }

    private void p(String string) {
        System.out.println("[TldLocationsCache] " + string);
    }
}

