/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspLineMap;
import org.apache.jasper.compiler.JspLineMapItem;
import org.apache.jasper.compiler.JspParseEventListener;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParseException;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.ServletWriter;
import org.xml.sax.Attributes;

public class Compiler {
    protected JavaCompiler javac;
    protected Mangler mangler;
    protected JspCompilationContext ctxt;

    public Compiler(JspCompilationContext jspCompilationContext) {
        this.ctxt = jspCompilationContext;
    }

    public boolean compile() throws FileNotFoundException, JasperException, Exception {
        Object object;
        OutputStreamWriter outputStreamWriter;
        if (!this.isOutDated()) {
            return false;
        }
        String string = this.mangler.getPackageName();
        this.ctxt.setServletPackageName(string);
        Constants.message("jsp.message.package_name_is", new Object[]{string}, 4);
        String string2 = this.mangler.getClassName();
        this.ctxt.setServletClassName(string2);
        Constants.message("jsp.message.class_name_is", new Object[]{string2}, 4);
        String string3 = this.mangler.getJavaFileName();
        this.ctxt.setServletJavaFileName(string3);
        Constants.message("jsp.message.java_file_name_is", new Object[]{string3}, 4);
        this.makeOutputDirectory(string3);
        String string4 = "UTF8";
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string3), string4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string4 = this.ctxt.getOptions().getJavaEncoding();
            if (string4 != null) {
                try {
                    outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string3), string4);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    throw new JasperException(Constants.getString("jsp.error.invalid.javaEncoding", new Object[]{"UTF8", string4}));
                }
            }
            throw new JasperException(Constants.getString("jsp.error.needAlternateJavaEncoding", new Object[]{"UTF8"}));
        }
        ServletWriter servletWriter = new ServletWriter(new PrintWriter(outputStreamWriter));
        this.ctxt.setWriter(servletWriter);
        ParserController parserController = new ParserController(this.ctxt);
        parserController.parse(this.ctxt.getJspFile());
        ParseEventListener parseEventListener = parserController.getParseEventListener();
        parseEventListener.beginPageProcessing();
        parseEventListener.endPageProcessing();
        servletWriter.close();
        ((JspParseEventListener)parseEventListener).validate();
        String string5 = this.ctxt.getClassPath();
        String[] stringArray = new String[]{"-encoding", string4, "-classpath", string5, "-d", this.ctxt.getOutputDir(), string3};
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append(" ");
            ++n;
        }
        Constants.message("jsp.message.compiling_with", new Object[]{stringBuffer.toString()}, 4);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        if (this.javac == null) {
            return true;
        }
        this.javac.setEncoding(string4);
        this.javac.setClasspath(string5);
        this.javac.setOutputDir(this.ctxt.getOutputDir());
        this.javac.setMsgOutput(byteArrayOutputStream);
        this.javac.setClassDebugInfo(this.ctxt.getOptions().getClassDebugInfo());
        boolean bl = this.javac.compile(string3);
        if (!this.ctxt.keepGenerated()) {
            object = new File(string3);
            ((File)object).delete();
        }
        if (!bl) {
            object = byteArrayOutputStream.toString();
            object = this.getJspLineErrors((String)object, servletWriter.getLineMap());
            throw new JasperException(Constants.getString("jsp.error.unable.compile") + (String)object);
        }
        return true;
    }

    private String getJspLineErrors(String string, JspLineMap jspLineMap) throws IOException {
        String string2;
        if (jspLineMap == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            char c;
            int n = string2.indexOf(58, 2);
            int n2 = string2.indexOf(58, n + 1);
            if (n >= 0 && n2 >= 0 && !string2.startsWith("Note: ")) {
                try {
                    String string3 = string2.substring(n + 1, n2);
                    c = Integer.parseInt(string3);
                    String string4 = this.findMapping(jspLineMap, c);
                    if (string4 == null) {
                        stringBuffer.append('\n');
                    } else {
                        stringBuffer.append(string4);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int n3 = 0;
            while (n3 < string2.length()) {
                c = string2.charAt(n3);
                if (c == '<') {
                    stringBuffer.append("&lt;");
                } else if (c == '>') {
                    stringBuffer.append("&gt;");
                } else {
                    stringBuffer.append(c);
                }
                ++n3;
            }
            stringBuffer.append('\n');
        }
        bufferedReader.close();
        jspLineMap.clear();
        return stringBuffer.toString();
    }

    private String findMapping(JspLineMap jspLineMap, int n) {
        int n2 = jspLineMap.size() - 1;
        while (n2 >= 0) {
            JspLineMapItem jspLineMapItem = jspLineMap.get(n2);
            if (jspLineMapItem != null && jspLineMapItem.getBeginServletLnr() <= n && jspLineMapItem.getEndServletLnr() >= n) {
                return this.createErrorMsg(jspLineMap, jspLineMapItem);
            }
            --n2;
        }
        return null;
    }

    private String createErrorMsg(JspLineMap jspLineMap, JspLineMapItem jspLineMapItem) {
        StringBuffer stringBuffer = new StringBuffer();
        if (jspLineMapItem.getBeginJspLnr() == jspLineMapItem.getEndJspLnr()) {
            stringBuffer.append(Constants.getString("jsp.error.single.line.number", new Object[]{new Integer(jspLineMapItem.getBeginJspLnr()), jspLineMap.getFileName(jspLineMapItem.getStartJspFileNr())}));
        } else {
            stringBuffer.append(Constants.getString("jsp.error.multiple.line.number", new Object[]{new Integer(jspLineMapItem.getBeginJspLnr()), new Integer(jspLineMapItem.getEndJspLnr()), jspLineMap.getFileName(jspLineMapItem.getStartJspFileNr())}));
        }
        stringBuffer.append(Constants.getString("jsp.error.corresponding.servlet"));
        return stringBuffer.toString();
    }

    public boolean isOutDated() {
        return true;
    }

    public void setJavaCompiler(JavaCompiler javaCompiler) {
        this.javac = javaCompiler;
    }

    public void setMangler(Mangler mangler) {
        this.mangler = mangler;
    }

    public String changeEncodingIfNecessary(JspReader jspReader) throws ParseException {
        while (jspReader.skipUntil("<%@") != null) {
            jspReader.skipSpaces();
            if (!jspReader.matches("page")) continue;
            jspReader.advance(4);
            jspReader.skipSpaces();
            try {
                int n;
                Attributes attributes = jspReader.parseTagAttributes();
                String string = attributes.getValue("contentType");
                if (string == null || (n = string.indexOf("charset=")) <= 0) continue;
                String string2 = string.substring(n + 8);
                return string2;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    public void removeGeneratedFiles() {
        try {
            String string = this.mangler.getClassFileName();
            if (string != null) {
                File file = new File(string);
                file.delete();
            }
        }
        catch (Exception exception) {}
    }

    private boolean makeOutputDirectory(String string) throws FileNotFoundException, Exception {
        String string2;
        File file;
        boolean bl = false;
        int n = string.lastIndexOf(File.separatorChar);
        if (n != -1 && !(bl = (file = new File(string2 = string.substring(0, n))).exists())) {
            bl = file.mkdirs();
        }
        return bl;
    }
}

