/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.net.InetAddress;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.startup.Embedded;
import org.apache.catalina.startup.EmbeddedManagerMBean;

public final class EmbeddedManager
extends NotificationBroadcasterSupport
implements EmbeddedManagerMBean,
MBeanRegistration {
    private int state = 0;
    private long sequenceNumber = 0L;
    private Embedded embedded = new Embedded();

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return new ObjectName(":service=Catalina");
    }

    public void postRegister(Boolean bl) {
        if (!bl.booleanValue()) {
            this.destroy();
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.destroy();
    }

    public String getName() {
        return "Catalina servlet container";
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return EmbeddedManagerMBean.states[this.state];
    }

    public void start() {
        AttributeChangeNotification attributeChangeNotification = null;
        if (this.state != 0) {
            return;
        }
        this.state = 2;
        attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Starting Catalina servlet container", "State", "java.lang.Integer", new Integer(0), new Integer(2));
        this.sendNotification(attributeChangeNotification);
        try {
            this.embedded.start();
            this.state = 3;
            attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Started Catalina servlet container", "State", "java.lang.Integer", new Integer(2), new Integer(3));
            this.sendNotification(attributeChangeNotification);
        }
        catch (Throwable throwable) {
            this.state = 0;
            attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Catalina servlet container", "State", "java.lang.Integer", new Integer(2), new Integer(0));
            this.sendNotification(attributeChangeNotification);
        }
    }

    public void stop() {
        AttributeChangeNotification attributeChangeNotification = null;
        if (this.state != 3) {
            return;
        }
        this.state = 1;
        attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopping Catalina servlet container", "State", "java.lang.Integer", new Integer(3), new Integer(1));
        this.sendNotification(attributeChangeNotification);
        try {
            this.embedded.stop();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.state = 0;
        attributeChangeNotification = new AttributeChangeNotification(this, this.sequenceNumber++, System.currentTimeMillis(), "Stopped Catalina servlet container", "State", "java.lang.Integer", new Integer(1), new Integer(0));
        this.sendNotification(attributeChangeNotification);
    }

    public void destroy() {
        if (this.getState() != 0) {
            this.stop();
        }
    }

    public int getDebug() {
        return this.embedded.getDebug();
    }

    public void setDebug(int n) {
        this.embedded.setDebug(n);
    }

    public boolean isUseNaming() {
        return this.embedded.isUseNaming();
    }

    public void setUseNaming(boolean bl) {
        this.embedded.setUseNaming(bl);
    }

    public Logger getLogger() {
        return this.embedded.getLogger();
    }

    public void setLogger(Logger logger) {
        this.embedded.setLogger(logger);
    }

    public Realm getRealm() {
        return this.embedded.getRealm();
    }

    public void setRealm(Realm realm) {
        this.embedded.setRealm(realm);
    }

    public String getSocketFactory() {
        return this.embedded.getSocketFactory();
    }

    public void setSocketFactory(String string) {
        this.embedded.setSocketFactory(string);
    }

    public void addConnector(Connector connector) {
        this.embedded.addConnector(connector);
    }

    public void addEngine(Engine engine) {
        this.embedded.addEngine(engine);
    }

    public Connector createConnector(InetAddress inetAddress, int n, boolean bl) {
        return this.embedded.createConnector(inetAddress, n, bl);
    }

    public Context createContext(String string, String string2) {
        return this.embedded.createContext(string, string2);
    }

    public Engine createEngine() {
        return this.embedded.createEngine();
    }

    public Host createHost(String string, String string2) {
        return this.embedded.createHost(string, string2);
    }

    public String getInfo() {
        return this.embedded.getInfo();
    }

    public void removeConnector(Connector connector) {
        this.embedded.removeConnector(connector);
    }

    public void removeContext(Context context) {
        this.embedded.removeContext(context);
    }

    public void removeEngine(Engine engine) {
        this.embedded.removeEngine(engine);
    }

    public void removeHost(Host host) {
        this.embedded.removeHost(host);
    }
}

